package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1890.class)
public class EnchantmentHelperMixin {

    @ModifyExpressionValue(
            method = "getComponentType",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z"
            )
    )
    private static boolean storeEnchantmentsIfWhetstone(boolean original, @Local(argsOnly = true) class_1799 stack) {
        if (SSO.CONFIG.whetstone.enableWhetstone.get()) {
            return original || stack.method_31574(ModItems.WHETSTONE);
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "getAvailableEnchantmentResults",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z"
            )
    )
    private static boolean handleWhetstoneEnchanting(boolean original, @Local(argsOnly = true) class_1799 stack) {
        if (SSO.CONFIG.whetstone.enableWhetstone.get()) {
            return original || stack.method_31574(ModItems.WHETSTONE);
        }
        return original;
    }
}
