package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1718.class)
public class EnchantmentMenuMixin {

    @ModifyExpressionValue(
            method = "getEnchantmentList",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z"
            )
    )
    private boolean getEnchantmentList_handleWhetstoneEnchanting(boolean original, @Local(argsOnly = true) class_1799 stack) {
        if (SSO.CONFIG.whetstone.enableWhetstone.get()) {
            return original || stack.method_31574(ModItems.WHETSTONE);
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "slotsChanged",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;isEnchantable()Z"
            )
    )
    private boolean slotsChanged_handleWhetstoneEnchanting(boolean original, @Local class_1799 stack) {
        if (SSO.CONFIG.whetstone.enableWhetstone.get() && stack.method_31574(ModItems.WHETSTONE)) {
            return original && stack.method_57824(class_9334.field_49643).method_57543();
        }
        return original;
    }

    @ModifyExpressionValue(
			//? if fabric
            method = "method_17411",
			//? if neoforge
			/*method = "lambda$slotsChanged$0",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/EnchantingTableBlock;isValidBookShelf(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Z"
            )
    )
    private boolean limitTablePower(boolean original, @Local /*? if fabric {*/int/*?} else {*//*float*//*?}*/ ix) {
        if (SSO.CONFIG.enchantmentLimits.limitEnchantingTablePower.get() && ix >= SSO.CONFIG.enchantmentLimits.enchantingTablePowerLimit.get()) {
            return false;
        }
        return original;
    }
}
