package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_3222;
import net.minecraft.class_3803;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets = "net/minecraft/world/inventory/GrindstoneMenu$4")
public abstract class GrindstoneMenuOutputSlotMixin {

	//? if fabric
	@Shadow @Final class_3803 field_16780;
	//? if neoforge
	/*@Shadow @Final GrindstoneMenu this$0;*/

	@ModifyExpressionValue(
            method = "getExperienceFromItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/enchantment/Enchantment;getMinCost(I)I"
            )
    )
    private int modifyXpCalculation(int original, @Local Object2IntMap.Entry<class_6880<class_1887>> entry) {
        if (SSO.CONFIG.grindstoneImprovements.increasedDisenchantXpGain.get()) {
            return ModUtil.calculateGrindstoneReward(entry);
        }
        return original;
    }

    @ModifyReturnValue(
            method = "getExperienceAmount",
            at = @At(
                    value = "RETURN",
                    ordinal = /*? if fabric {*/0/*?} else {*//*1*//*?}*/
            )
    )
    private int modifyXpAmount(int original, @Local(ordinal = 0) int i) {
        if (SSO.CONFIG.grindstoneImprovements.increasedDisenchantXpGain.get()) {
            return i;
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "getExperienceAmount",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/inventory/GrindstoneMenu;repairSlots:Lnet/minecraft/world/Container;",
                    ordinal = 1
            )
    )
    private class_1263 preventXpAwardIfRepairCostReductionRecipe(class_1263 original, @Cancellable CallbackInfoReturnable<Integer> ci) {
        if (SSO.CONFIG.grindstoneImprovements.repairCostReductionRecipe.get() && original.method_5438(1).method_31574(class_1802.field_22021)) {
            ci.setReturnValue(0);
        }
        return original;
    }

    @Inject(
            method = "onTake",
            at = @At("HEAD")
    )
    private void grantAdvancement(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (player instanceof class_3222 p) {
            if (/*? if fabric {*/field_16780/*?} else {*//*this$0*//*?}*/.field_7761.get(1).method_7677().method_31574(class_1802.field_22021)) ModCriteria.REDUCE_REPAIR_COST.trigger(p);
            else ModCriteria.DISENCHANT_ITEM.trigger(p);
        }
    }
}
