package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
//? if > 1.21.1 {
/*import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.apache.commons.lang3.function.TriConsumer;
*///?}

import java.util.function.BiConsumer;

@Mixin(class_1799.class)
public abstract class ItemStackMixin implements class_9322 {

    @Shadow @Nullable
    public abstract <T> T set(class_9331<? super T> component, @Nullable T value);

    @Shadow @Nullable
    public abstract <T> T remove(class_9331<? extends T> component);

    @Shadow
    public abstract int getMaxDamage();

    @Shadow
    public abstract boolean isEnchanted();

    @Shadow
    public abstract boolean isDamageableItem();

    @Shadow
    public abstract boolean is(class_1792 item);

    @Shadow
    public abstract int getDamageValue();

    @Unique
    private final class_1799 thisStack = (class_1799) (Object) this;

    @SuppressWarnings("ConstantValue")
    @Inject(
            method = "set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;",
            at = @At("HEAD")
    )
    private <T> void manageBrokenState(class_9331<? super T> component, T value, CallbackInfoReturnable<T> cir) {
        if (component == class_9334.field_49629 && isDamageableItem()) {
            if ((int) value < getMaxDamage()) remove(ModDataComponents.BROKEN);
            else switch (SSO.CONFIG.streamlinedRepairs.preventItemDestruction.get()) {
                case ALL -> set(ModDataComponents.BROKEN, true);
                case ENCHANTED -> {
                    if (isEnchanted()) set(ModDataComponents.BROKEN, true);
                }
            }
        }
    }

    @WrapWithCondition(
            //? if <= 1.21.1 && fabric
            method = "hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V",
			//? if <= 1.21.1 && neoforge
			/*method = "hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V",*/
            //? if > 1.21.1 && fabric
            /*method = "applyDamage",*/
			//? if > 1.21.1 && neoforge
			/*method = "applyDamage(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;shrink(I)V"
            )
    )
    private boolean preventDestruction(class_1799 instance, int decrement) {
        return !ModUtil.isBroken(instance);
    }

    @WrapMethod(method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")
    private void noAttributesIfBroken(class_1304 equipmentSLot, BiConsumer<class_6880<class_1320>, class_1322> action, Operation<Void> original) {
        if (!ModUtil.isBroken(thisStack)) original.call(equipmentSLot, action);
    }

    @WrapMethod(
            //? if <= 1.21.1
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"
            //? if > 1.21.1
            /*method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Lorg/apache/commons/lang3/function/TriConsumer;)V"*/
    )
    private void noAttributesIfBroken(
            //? if <= 1.21.1
            class_9274 slotGroup, BiConsumer<class_6880<class_1320>, class_1322> action, Operation<Void> original
            //? if > 1.21.1
            /*EquipmentSlotGroup slotGroup, TriConsumer<Holder<Attribute>, AttributeModifier, ItemAttributeModifiers.Display> action, Operation<Void> original*/
    ) {
        if (!ModUtil.isBroken(thisStack)) original.call(slotGroup, action);
    }

    @ModifyReturnValue(
            method = "getHoverName",
            at = @At("RETURN")
    )
    private class_2561 changeNameIfBroken(class_2561 original) {
        if (ModUtil.isBroken(thisStack) || (is(class_1802.field_8833) && getMaxDamage() - getDamageValue() == 1)) {
            class_5250 name = class_2561.method_43469("item.simple_smithing_overhaul.broken", original);
            name.method_27692(class_124.field_1061);
            return name;
        }
        return original;
    }
}
