package me.pajic.simple_smithing_overhaul.mixin;

import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import me.pajic.simple_smithing_overhaul.SSO;
import net.minecraft.class_3288;
import net.minecraft.class_5369;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

/**
 * This just hides the conditionally loaded resource packs from the resource pack and datapack selection UIs to prevent clutter.
 */
@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_5369.class)
public class PackSelectionModelMixin {

    @Shadow @Final List<class_3288> selected;
    @Shadow @Final List<class_3288> unselected;

    @Inject(
            method = "findNewPacks",
            at = @At("TAIL")
    )
    private void filterPacks(CallbackInfo ci) {
        selected.removeIf(pack -> pack.method_14463().contains(SSO.MOD_ID));
        unselected.removeIf(pack -> pack.method_14463().contains(SSO.MOD_ID));
    }
}
