package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.recipe.UpgradeRecipeHandler;
import me.pajic.simple_smithing_overhaul.util.CostAccess;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//? if <= 1.21.1
import com.llamalad7.mixinextras.injector.ModifyReturnValue;

@Mixin(class_4862.class)
public abstract class SmithingMenuMixin extends class_4861 {

    @Shadow @Final public class_1937 level;

    //? if <= 1.21.1 {
    public SmithingMenuMixin(@Nullable class_3917<?> menuType, int i, class_1661 inventory, class_3914 containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }
    //?} else {
    /*public SmithingMenuMixin(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access, ItemCombinerMenuSlotDefinition slotDefinition) {
        super(menuType, containerId, inventory, access, slotDefinition);
    }
    *///?}

    @Inject(
            //? if <= 1.21.1 {
            method = "createResult",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/Level;enabledFeatures()Lnet/minecraft/world/flag/FeatureFlagSet;"
            ),
            //?} else {
			/*//? if fabric
            method = "method_64653",
			//? if neoforge
			/^method = "lambda$createResult$1",^/
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/inventory/SmithingMenu;resultSlots:Lnet/minecraft/world/inventory/ResultContainer;",
                    ordinal = 0
            ),
            *///?}
            cancellable = true
    )
    private void handleSmithingUpgradeRecipes(CallbackInfo ci, @Local LocalRef<class_1799> stack) {
        UpgradeRecipeHandler.handleRecipe(ci, stack, field_7761, field_22479, level, this);
    }

    //? if <= 1.21.1 {
    @ModifyReturnValue(
            method = "mayPickup",
            at = @At("RETURN")
    )
    private boolean modifyMayPickup(boolean original) {
        if (
                SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get() &&
				SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get() &&
                (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe(field_7761) || ModUtil.isEnchantedItemUpgradeRecipe(field_7761))
        ) {
            return (field_22482.method_56992() || field_22482.field_7520 >= ((CostAccess) this).sso$getCost()) && ((CostAccess) this).sso$getCost() > 0;
        }
        if (
				SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get() &&
                ModUtil.isPinnacleEnchantmentRecipe(field_7761)
        ) {
            return (field_22482.method_56992() || field_22482.field_7520 >= ((CostAccess) this).sso$getCost()) && ((CostAccess) this).sso$getCost() > 0;
        }
        return original;
    }
    //?}

    @Inject(
            method = "onTake",
            at = @At("HEAD")
    )
    private void hookOnTake(class_1657 player, class_1799 itemStack, CallbackInfo ci) {
        if (
				SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get() &&
				SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get() &&
                (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe(field_7761) || ModUtil.isEnchantedItemUpgradeRecipe(field_7761))
        ) {
            if (!player.method_31549().field_7477) ModUtil.payXpCost(player, ((CostAccess) this).sso$getCost());
            if (player instanceof class_3222 p) ModCriteria.APPLY_ENCHANTMENT_UPGRADE.trigger(p);
        }
        if (
				SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get() &&
                ModUtil.isPinnacleEnchantmentRecipe(field_7761)
        ) {
            if (!player.method_31549().field_7477) ModUtil.payXpCost(player, ((CostAccess) this).sso$getCost());
            if (player instanceof class_3222 p) {
                ModCriteria.APPLY_PINNACLE_ENCHANTMENT.trigger(p);
                if (itemStack.method_57825(ModDataComponents.PINNACLE_COUNT, 0) == 10) ModCriteria.BAD_RNG.trigger(p);
            }
        }
    }
}
