package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4862;
import net.minecraft.class_4894;
import net.minecraft.class_4895;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_4895.class)
public abstract class SmithingScreenMixin extends class_4894<class_4862> {

    public SmithingScreenMixin(class_4862 itemCombinerMenu, class_1661 inventory, class_2561 component, class_2960 resourceLocation) {
        super(itemCombinerMenu, inventory, component, resourceLocation);
    }

    @Override
    @SuppressWarnings("ConstantConditions")
    protected void method_2388(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
        if (
				SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get() &&
				SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get() &&
                (ModUtil.isEnchantedItemUpgradeRecipe(field_2797.field_7761) || ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe(field_2797.field_7761)) &&
                field_2797.field_7761.get(2).method_7677().method_31574(class_1802.field_8759) &&
                field_2797.field_7761.get(3).method_7681()
        ) {
            class_1799 stack = field_2797.field_7761.get(1).method_7677();
            int repairCost = SSO.CONFIG.enchantmentUpgrading.upgradingBaseExperienceCost.get() +
                    stack.method_57825(class_9334.field_49639, 0);
            if (repairCost > 0) {
                class_2561 component = class_2561.method_43469("container.repair.cost", repairCost);
                int textColor = (field_22787.field_1724.method_56992() || field_22787.field_1724.field_7520 >= repairCost) && repairCost > 0 ? 0xFF80FF20 : 0xFFFF6060;
                if (!SSO.CONFIG.enchantmentUpgrading.ignoreTooExpensive.get() && repairCost >= 40) {
                    component = class_2561.method_43471("container.repair.expensive");
                    textColor = 0xFF6060;
                }
                int x = field_2792 - 8 - field_22793.method_27525(component) - 2;
                guiGraphics.method_25294(x - 2, 67, field_2792 - 8, 79, 0x4F000000);
                guiGraphics.method_27535(field_22793, component, x, 69, textColor);
            }
        }
        if (
				SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get() &&
                ModUtil.isPinnacleEnchantmentRecipe(field_2797.field_7761) &&
                field_2797.field_7761.get(3).method_7681()
        ) {
            int repairCost = SSO.CONFIG.pinnacleEnchantment.pinnacleBaseExperienceCost.get() + SSO.CONFIG.pinnacleEnchantment.pinnacleExperienceCostIncrease.get() * field_2797.field_7761.get(3).method_7677().method_57825(ModDataComponents.PINNACLE_COUNT, 0);
            class_2561 component = class_2561.method_43469("container.repair.cost", repairCost);
            int textColor = (field_22787.field_1724.method_56992() || field_22787.field_1724.field_7520 >= repairCost) ? 0xFF80FF20 : 0xFFFF6060;
            int x = field_2792 - 8 - field_22793.method_27525(component) - 2;
            guiGraphics.method_25294(x - 2, 67, field_2792 - 8, 79, 0x4F000000);
            guiGraphics.method_27535(field_22793, component, x, 69, textColor);
        }
    }

    @ModifyExpressionValue(
            method = "renderBg",
            at = @At(
                    value = "CONSTANT",
                    args = /*? if <= 1.21.1 {*/"intValue=75"/*?} else {*//*"intValue=20"*//*?}*/
            )
    )
    private int nudgeArmorStandUp(int original) {
        if (
                (SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get() &&
				SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()) ||
				SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()
        ) {
            return original - /*? if <= 1.21.1 {*/10/*?} else {*//*20*//*?}*/;
        }
        return original;
    }
}
