package me.pajic.simple_smithing_overhaul.platform.fabric;

//? fabric {

import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.blocks.ModBlocks;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.mixson.ResourceModifications;
import me.pajic.simple_smithing_overhaul.recipe.ModRecipeSerializers;
import me.pajic.simple_smithing_overhaul.util.CompatFlags;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

@SuppressWarnings("unused")
public class FabricEntrypoint implements ModInitializer {

	@Override
	public void onInitialize() {
		ResourceModifications.init();
		SSO.onInitialize();
		ModBlocks.init();
		ModItems.init();
		ModDataComponents.init();
		ModCriteria.init();
		ModRecipeSerializers.init();
		initRegistry();
		initConditionalCommonResources();
		initCreativeTabs();
		initEvents();
	}

	private void initConditionalCommonResources() {
		FabricLoader.getInstance().getModContainer(SSO.MOD_ID).ifPresent(modContainer -> {
			ResourceManagerHelper.registerBuiltinResourcePack(
					SSO.id(SSO.PACK_VERSION + "/dp"),
					modContainer,
					ResourcePackActivationType.ALWAYS_ENABLED
			);
			//? if > 1.21.1 {
			/*switch (SSO.CONFIG.streamlinedRepairs.netheriteRepairMaterial.get()) {
				case DIAMOND -> ResourceManagerHelper.registerBuiltinResourcePack(
						SSO.id(SSO.PACK_VERSION + "/netherite_repair_diamond"),
						modContainer,
						ResourcePackActivationType.ALWAYS_ENABLED
				);
				case NETHERITE_SCRAP -> ResourceManagerHelper.registerBuiltinResourcePack(
						SSO.id(SSO.PACK_VERSION + "/netherite_repair_scrap"),
						modContainer,
						ResourcePackActivationType.ALWAYS_ENABLED
				);
			}
			*///?}
			if (CompatFlags.CHALK_LOADED) ResourceManagerHelper.registerBuiltinResourcePack(
					SSO.id(SSO.PACK_VERSION + "/chalk_item_tags"),
					modContainer,
					ResourcePackActivationType.ALWAYS_ENABLED
			);
		});
	}

	private void initRegistry() {
		class_2378.method_10230(
				class_7923.field_41175,
				SSO.id("broken_anvil"),
				ModBlocks.BROKEN_ANVIL
		);
		class_2378.method_10230(
				class_7923.field_41178,
				SSO.id("enchantment_upgrade"),
				ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE
		);
		class_2378.method_10230(
				class_7923.field_41178,
				SSO.id("pinnacle_enchantment"),
				ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE
		);
		class_2378.method_10230(
				class_7923.field_41178,
				SSO.id("whetstone"),
				ModItems.WHETSTONE
		);
		class_2378.method_10230(
				class_7923.field_41178,
				SSO.id("broken_anvil"),
				ModItems.BROKEN_ANVIL
		);
		class_2378.method_10230(
				class_7923.field_49658,
				SSO.id("repair_count"),
				ModDataComponents.REPAIR_COUNT
		);
		class_2378.method_10230(
				class_7923.field_49658,
				SSO.id("pinnacle_count"),
				ModDataComponents.PINNACLE_COUNT
		);
		class_2378.method_10230(
				class_7923.field_49658,
				SSO.id("broken"),
				ModDataComponents.BROKEN
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("repair_item"), ModCriteria.REPAIR_ITEM
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("repair_item_whetstone"), ModCriteria.REPAIR_ITEM_WHETSTONE
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("repair_item_whetstone_enchanted"), ModCriteria.REPAIR_ITEM_WHETSTONE_ENCHANTED
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("max_whetstone"), ModCriteria.MAX_WHETSTONE
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("item_repair_count"), ModCriteria.ITEM_REPAIR_COUNT
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("item_repair_count_big"), ModCriteria.ITEM_REPAIR_COUNT_BIG
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("disenchant_item"), ModCriteria.DISENCHANT_ITEM
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("reduce_repair_cost"), ModCriteria.REDUCE_REPAIR_COST
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("apply_enchantment_upgrade"), ModCriteria.APPLY_ENCHANTMENT_UPGRADE
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("apply_pinnacle_enchantment"), ModCriteria.APPLY_PINNACLE_ENCHANTMENT
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("bad_rng"), ModCriteria.BAD_RNG
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("maxed_out"), ModCriteria.MAXED_OUT
		);
		class_2378.method_10230(
				class_7923.field_47496,
				SSO.id("anvil_enchant_combine"), ModCriteria.ANVIL_ENCHANT_COMBINE
		);
		class_2378.method_10230(
				class_7923.field_41189,
				class_2960.method_60656("crafting_special_portable_repairitem"),
				ModRecipeSerializers.PORTABLE_ITEM_REPAIR
		);
	}

	private void initCreativeTabs() {
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(contents -> contents.addAfter(
				class_1802.field_41946,
				ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE
		));
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(contents -> contents.addAfter(
				ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE,
				ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE
		));
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(contents -> contents.addAfter(
				class_1802.field_22026,
				ModItems.WHETSTONE
		));
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(contents -> contents.addAfter(
				class_1802.field_8427,
				ModItems.BROKEN_ANVIL
		));
	}

	private void initEvents() {
		CommonLifecycleEvents.TAGS_LOADED.register((registryAccess, client) -> ModUtil.updateAdditionalRepairables(registryAccess));
		AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> ModUtil.canUse(player, hand));
		UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> ModUtil.canUse(player, hand));
		AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> ModUtil.canUse(player, hand));
		UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> ModUtil.canUse(player, hand));
		UseItemCallback.EVENT.register((player, world, hand) -> {
			class_1799 stack = player.method_6047();
			//? if <= 1.21.1
			return ModUtil.isBroken(stack) ? class_1271.method_22431(stack) : class_1271.method_22430(stack);
			//? if > 1.21.1
			/*return ModUtil.isBroken(stack) ? InteractionResult.FAIL : InteractionResult.PASS;*/
		});
	}
}
//?}
