package me.pajic.simple_smithing_overhaul.recipe;

import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;

public class PortableItemRepairRecipe extends class_1852 {
    private class_1799 itemToRepair;
    private List<class_1799> repairMaterials;
    private List<class_1799> repairableItems;
    private int unitCost;
    private int flintCount = 0;
    private class_5819 random;

    public PortableItemRepairRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(@NotNull class_9694 input, @NotNull class_1937 level) {
        random = level.method_8409();
        List<class_1799> whetstones = input.method_59989().stream().filter(itemStack -> itemStack.method_31574(ModItems.WHETSTONE)).toList();
        List<class_1799> flint = input.method_59989().stream().filter(itemStack -> itemStack.method_31574(class_1802.field_8145)).toList();
        if (whetstones.isEmpty() ^ flint.isEmpty()) {
            if (whetstones.size() == 1) {
                class_1799 whetstone = whetstones.getFirst();
                repairableItems = input.method_59989().stream().filter(itemStack ->
                        itemStack.method_7963() && !itemStack.method_31574(ModItems.WHETSTONE)).toList();
                if (!repairableItems.isEmpty()) {
                    itemToRepair = repairableItems.getFirst();
                    if (itemToRepair.method_7986() && whetstone.method_7919() < whetstone.method_7936()) {
                        class_9304 whetstoneEnchantments = whetstone.method_57825(
                                class_9334.field_49643,
                                class_9304.field_49385
                        );
                        if (itemToRepair.method_58657().method_57539().stream().allMatch(
                                entry -> whetstoneEnchantments.method_57536(entry.getKey()) >= Math.min(
                                        entry.getIntValue(),
                                        entry.getKey().comp_349().method_8183()
                                )
                        )) {
                            return processRepair(input);
                        }
                    }
                }
            } else if (flint.size() == 1) {
                flintCount = flint.getFirst().method_7947();
                repairableItems = input.method_59989().stream().filter(itemStack ->
                        itemStack.method_7963() && !itemStack.method_31574(class_1802.field_8145)).toList();
                if (!repairableItems.isEmpty()) {
                    itemToRepair = repairableItems.getFirst();
                    if (itemToRepair.method_7986() && !itemToRepair.method_7942()) {
                        return processRepair(input);
                    }
                }
            }
        }
        return false;
    }

    //? if > 1.21.1
    /*@SuppressWarnings("DataFlowIssue")*/
    private boolean processRepair(class_9694 input) {
        unitCost = ModUtil.determineUnitCost(itemToRepair);
        int damageRepairedPerUnit = Math.round((float) itemToRepair.method_7936() / unitCost);
        int unitsToMaxRepair = itemToRepair.method_7919() / damageRepairedPerUnit;
        repairMaterials = input.method_59989().stream().filter(itemStack ->
            //? if <= 1.21.1 {
            ModUtil.hasAdditionalRepair(itemToRepair, itemStack) ||
            itemToRepair.method_7909().method_7878(itemToRepair, itemStack)).toList();
            //?} else {
            /*{
                if (itemToRepair.has(DataComponents.REPAIRABLE)) {
                    return itemToRepair.get(DataComponents.REPAIRABLE).isValidRepairItem(itemStack);
                }
                return false;
            }).toList();
        *///?}
        boolean flintMaterialValid = true;
        if (flintCount > 0) {
            for (String s : SSO.CONFIG.streamlinedRepairs.flintMaterialBlacklist.get()) {
                for (class_1799 i : repairMaterials) {
                    Optional<class_1792> opt = class_7923.field_41178.method_17966(class_2960.method_12829(s));
                    if (opt.isPresent() && i.method_31574(opt.get())) {
                        flintMaterialValid = false;
                    }
                }
            }
        }
        return !repairMaterials.isEmpty() && repairMaterials.size() <= unitsToMaxRepair + 1 && (flintCount == 0 || (flintMaterialValid && flintCount >= repairMaterials.size()));
    }

    @Override
    public @NotNull class_1799 assemble(@NotNull class_9694 input, @NotNull class_7225.class_7874 registries) {
        class_1799 outputItem = itemToRepair.method_7972();
        outputItem.method_7974(
                outputItem.method_7919() - (Math.round((float) outputItem.method_7936() / unitCost) * repairMaterials.size())
        );
        outputItem.method_57379(ModDataComponents.REPAIR_COUNT, outputItem.method_57825(ModDataComponents.REPAIR_COUNT, 0) + 1);
        return outputItem;
    }

    @Override
    public @NotNull class_2371<class_1799> getRemainingItems(@NotNull class_9694 input) {
        List<class_1799> otherGear = repairableItems.subList(1, repairableItems.size());
        class_2371<class_1799> remainingItems = class_2371.method_10213(input.method_59983(), class_1799.field_8037);
        for (int i = 0; i < remainingItems.size(); i++) {
            class_1799 itemStack = input.method_59984(i);
            if (itemStack.method_31574(ModItems.WHETSTONE)) {
                float degradationChance = SSO.CONFIG.anvilImprovements.modifyDegradationChance.get() ?
                        SSO.CONFIG.anvilImprovements.degradationChance.get() / 50 : 0.24F;
                if (random.method_43057() < degradationChance) {
                    itemStack.method_7974(itemStack.method_7919() + 1);
                }
                remainingItems.set(i, itemStack.method_7972());
            } else if (itemStack.method_31574(class_1802.field_8145)) {
                class_1799 updated = new class_1799(class_1802.field_8145);
                updated.method_7939(itemStack.method_7947() - repairMaterials.size());
                itemStack.method_7939(0);
                remainingItems.set(i, updated);
            } else if (otherGear.contains(itemStack)) {
                remainingItems.set(i, itemStack.method_7972());
            } else if (!itemStack.method_31574(repairMaterials.getFirst().method_7909()) && !itemStack.method_31574(repairableItems.getFirst().method_7909())) {
                remainingItems.set(i, new class_1799(itemStack.method_7909()));
            }
        }
        return remainingItems;
    }

    //? if <= 1.21.1 {
    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 4;
    }
    //?}

    @Override
    public @NotNull class_1865<?/*? if > 1.21.1 {*/ /*extends CustomRecipe*//*?}*/> method_8119() {
        return ModRecipeSerializers.PORTABLE_ITEM_REPAIR;
    }
}
