package me.pajic.simple_smithing_overhaul.recipe;

import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.util.CostAccess;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class UpgradeRecipeHandler {

    public static void handleRecipe(
            CallbackInfo ci,
            LocalRef<class_1799> stack,
            class_2371<class_1735> slots,
            class_1731 resultSlots,
            class_1937 level,
            class_4861 menu
    ) {
        if (SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get()) {
            class_9304 itemEnchantments = null;
            if (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe(slots)) {
                itemEnchantments = stack.get().method_57824(class_9334.field_49643);
            } else if (ModUtil.isEnchantedItemUpgradeRecipe(slots)) {
                itemEnchantments = stack.get().method_57824(class_9334.field_49633);
            }
            if (itemEnchantments != null) {
                boolean success = false;
                int lapisAmount = slots.get(2).method_7677().method_7947();
                if (lapisAmount <= itemEnchantments.method_57539().size() && slots.get(1).method_7677().method_7947() == 1) {
                    class_1799 updatedStack = slots.get(1).method_7677().method_7972();
                    List<class_2561> enchantmentNames = new ArrayList<>();
                    Consumer<class_2561> consumer = enchantmentNames::add;
                    itemEnchantments.method_57409(class_1792.class_9635.method_59528(level), consumer, class_1836.field_41070/*? if > 1.21.1 {*//*, updatedStack.getComponents()*//*?}*/);
                    for (int i = 0; i < enchantmentNames.size(); i++) {
                        if (i + 1 == lapisAmount) {
                            class_2561 enchantmentName = enchantmentNames.get(i);
                            for (Object2IntMap.Entry<class_6880<class_1887>> entry : itemEnchantments.method_57539()) {
                                if (
                                        class_1887.method_8179(entry.getKey(), entry.getIntValue()).equals(enchantmentName) &&
                                                entry.getIntValue() < entry.getKey().comp_349().method_8183()
                                ) {
                                    class_1890.method_57531(updatedStack, mutable ->
                                            mutable.method_57550(entry.getKey(), entry.getIntValue() + 1)
                                    );
                                    if (SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()) {
                                        int originalRepairCost = stack.get().method_57825(class_9334.field_49639, 0);
                                        ((CostAccess) menu).sso$setCost(SSO.CONFIG.enchantmentUpgrading.upgradingBaseExperienceCost.get() + originalRepairCost);
                                        if (((CostAccess) menu).sso$getCost() < 1 || (!SSO.CONFIG.enchantmentUpgrading.ignoreTooExpensive.get() && ((CostAccess) menu).sso$getCost() >= 40)) break;
                                        updatedStack.method_57379(class_9334.field_49639, class_1706.method_20398(originalRepairCost));
                                    }
                                    stack.set(updatedStack);
                                    success = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!success) {
                    resultSlots.method_5447(0, class_1799.field_8037);
                    ci.cancel();
                }
            }
        }
        if (SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()) {
            if (ModUtil.isPinnacleEnchantmentRecipe(slots)) {
                boolean success = false;
                if (slots.get(1).method_7677().method_7947() == 1) {
                    class_7225.class_7226<class_1887> registry = level.method_30349().method_46762(class_7924.field_41265);
                    class_1799 itemStack = slots.get(1).method_7677().method_7972();
                    Set<class_1889> itemEnchantments = itemStack.method_58657().method_57539()
                            .stream().map(entry -> new class_1889(entry.getKey(), entry.getIntValue()))
                            .collect(Collectors.toSet());
                    if (itemEnchantments.stream().allMatch(ei -> ei.field_9094/*? if > 1.21.1 {*//*()*//*?}*/ >= ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183() && !registry.method_46735(class_9636.field_51551).method_40241(ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/))) {
                        Set<class_1889> maxedOutEnchantments = new HashSet<>();
                        registry.method_42017().forEach(ref -> {
                            if (ref.comp_349().method_8192(itemStack) && ModUtil.enchantmentEligible(ref))
                                maxedOutEnchantments.add(new class_1889(ref, ref.comp_349().method_8183()));
                        });
                        maxedOutEnchantments.removeIf(ei -> registry.method_46735(class_9636.field_51551).method_40241(ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/));
                        itemEnchantments.forEach(ei -> maxedOutEnchantments.removeIf(ei1 -> !class_1887.method_60033(ei1.field_9093/*? if > 1.21.1 {*//*()*//*?}*/, ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/)));
                        if (maxedOutEnchantments.isEmpty()) {
                            Set<class_1889> possibleUpgrades = itemEnchantments.stream().filter(ei ->
                                    (ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183() > 1) &&
                                    (ei.field_9094/*? if > 1.21.1 {*//*()*//*?}*/ <= ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183()) &&
                                    ModUtil.enchantmentEligible(ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/)
                            ).collect(Collectors.toSet());
                            if (!possibleUpgrades.isEmpty()) {
                                success = true;
                                ((CostAccess) menu).sso$setCost(SSO.CONFIG.pinnacleEnchantment.pinnacleBaseExperienceCost.get() + SSO.CONFIG.pinnacleEnchantment.pinnacleExperienceCostIncrease.get() * itemStack.method_57825(ModDataComponents.PINNACLE_COUNT, 0));
                                class_1799 updatedStack = slots.get(1).method_7677().method_7972();
                                updatedStack.method_57379(class_9334.field_49631, class_2561.method_43471("text.item.simple_smithing_overhaul.pinnacleCustomName").method_27692(class_124.field_1076));
                                stack.set(updatedStack);
                            }
                        }
                    }
                }
                if (!success) {
                    resultSlots.method_5447(0, class_1799.field_8037);
                    ci.cancel();
                }
            }
        }
    }

    public static class_1799 applyPinnacleUpgrade(class_1799 original, class_1735 slot, class_1703 container, class_2371<class_1735> slots) {
        if (container instanceof class_4862 sm && ModUtil.isPinnacleEnchantmentRecipe(slots) && slot.equals(slots.get(3))) {
            class_5819 random = sm.field_25385.method_8409();
            class_2561 itemName = slots.get(1).method_7677().method_57825(class_9334.field_49631, original.method_7909().method_7864(original));
            original.method_57379(class_9334.field_49631, itemName.method_27661().method_27692(class_124.method_533(SSO.CONFIG.pinnacleEnchantment.pinnacleItemNameColor.get().replace(" ", "_").toUpperCase())));
            List<class_1889> existingPinnacleEnchantments = original.method_58657().method_57539()
                    .stream().map(entry -> new class_1889(entry.getKey(), entry.getIntValue()))
                    .filter(ei -> ei.field_9094/*? if > 1.21.1 {*//*()*//*?}*/ > ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183())
                    .toList();
            if (existingPinnacleEnchantments.size() >= SSO.CONFIG.pinnacleEnchantment.maxPinnacleEnchantmentsOnItem.get()) {
                int index = random.method_43048(existingPinnacleEnchantments.size());
                class_1889 toDowngrade = existingPinnacleEnchantments.get(index);
                class_1890.method_57531(original, mutable -> mutable.method_57547(
                        toDowngrade.field_9093/*? if > 1.21.1 {*//*()*//*?}*/,
                        toDowngrade.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183()
                ));
            }
            List<class_1889> possibleUpgrades = new ArrayList<>(original.method_58657().method_57539()
                    .stream().map(entry -> new class_1889(entry.getKey(), entry.getIntValue())).toList());
            possibleUpgrades.removeIf(ei ->
                    (ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.comp_349().method_8183() == 1) ||
                    !ModUtil.enchantmentEligible(ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/) ||
                    existingPinnacleEnchantments.stream().anyMatch(ei1 -> ei.field_9093/*? if > 1.21.1 {*//*()*//*?}*/.equals(ei1.field_9093/*? if > 1.21.1 {*//*()*//*?}*/))
            );
            class_1889 toUpgrade = possibleUpgrades.get(random.method_43048(possibleUpgrades.size()));
            class_1890.method_57531(original, mutable ->
                    mutable.method_57550(toUpgrade.field_9093/*? if > 1.21.1 {*//*()*//*?}*/, toUpgrade.field_9094/*? if > 1.21.1 {*//*()*//*?}*/ + 1)
            );
            original.method_57379(ModDataComponents.PINNACLE_COUNT, original.method_57825(ModDataComponents.PINNACLE_COUNT, 0) + 1);
        }
        return original;
    }
}
