package me.pajic.simple_smithing_overhaul.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.compat.EDCompat;
import me.pajic.simple_smithing_overhaul.compat.TFLCompat;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_4059;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ModUtil {
    public static final Map<class_1856, class_1856> additionalRepairables = new HashMap<>();
    public static final List<String> itemSuggestions = new ArrayList<>();

	//? if > 1.21.1
	/*@SuppressWarnings("deprecation")*/
	public static void updateAdditionalRepairables(class_7225.class_7874 provider) {
		// Custom repairs 101
		// 2 maps, item to ingredient and ingredient to ingredient, populated in the initializer
		// In 1.21.1, ModUtil.hasAdditionalRepairables contains logic to determine if an item has a custom repair based on the two maps
		// This method is injected via mixin to vanilla methods which determine if an item has a repair recipe
		// In 1.21.1+, the components of each item are patched to add a repairable component containing the repair materials,
		// so ModUtil.hasAdditionalRepairables isn't required and is not injected anywhere
		ModUtil.additionalRepairables.clear();
		class_7225<class_1792> registry = provider.method_46762(class_7924.field_41197);

		// Vanilla repairs
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8102), class_1856.method_8091(class_1802.field_8276));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8399), class_1856.method_8091(class_1802.field_8276));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8378), class_1856.method_8091(class_1802.field_8276));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8884), class_1856.method_8091(class_1802.field_8620));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8868), class_1856.method_8091(class_1802.field_8620));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_42716), class_1856.method_8091(class_1802.field_8153));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8184), class_1856.method_8091(class_1802.field_8179));
		ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_23254), class_1856.method_8091(class_1802.field_21988));
		if (!CompatFlags.BETTER_TRIDENTS_LOADED) ModUtil.additionalRepairables.put(class_1856.method_8091(class_1802.field_8547), class_1856.method_8091(class_1802.field_8662));
		// Modded repairs
		SSO.CONFIG.streamlinedRepairs.modRepairableItems.forEach((repairItem, repairMaterial) -> {
			try {
				if (repairItem.startsWith("#")) {
					if (repairMaterial.startsWith("#")) {
						ModUtil.additionalRepairables.put(
								ingredientFromItemTag(repairItem, registry),
								ingredientFromItemTag(repairMaterial, registry)
						);
					} else {
						registry.method_46746(class_5321.method_29179(class_7924.field_41197, class_2960.method_12829(repairMaterial))).ifPresent(value ->
								ModUtil.additionalRepairables.put(
										ingredientFromItemTag(repairItem, registry),
										class_1856.method_8091(value.comp_349())
								)
						);
					}
				} else {
					Optional<class_6880.class_6883<class_1792>> item = registry.method_46746(class_5321.method_29179(class_7924.field_41197, class_2960.method_60654(repairItem)));
					if (item.isPresent()) {
						if (repairMaterial.startsWith("#")) {
							ModUtil.additionalRepairables.put(
									class_1856.method_8091(item.get().comp_349()),
									ingredientFromItemTag(repairMaterial, registry)
							);
						} else {
							registry.method_46746(class_5321.method_29179(class_7924.field_41197, class_2960.method_60654(repairMaterial))).ifPresent(value ->
									ModUtil.additionalRepairables.put(class_1856.method_8091(item.get().comp_349()), class_1856.method_8091(value.comp_349()))
							);
						}
					}
				}
				// Catch anything that explodes above because I cannot be bothered
			} catch (Throwable t) {
				SSO.LOGGER.warn("Unable to load additional repair {} with {}, skipping: {}", repairItem, repairMaterial, t.getMessage());
			}
		});
		// Patch item components to add the repairable component
		//? if > 1.21.1 {
        /*ModUtil.additionalRepairables.forEach((itemIngredient, materialIngredient) ->
                itemIngredient.items().forEach(itemHolder ->
                        itemHolder.value().components = PatchedDataComponentMap.fromPatch(
                                itemHolder.value().components,
                                DataComponentPatch.builder().set(
                                        DataComponents.REPAIRABLE,
                                        new Repairable(HolderSet.direct(materialIngredient.items().toList()))
                                ).build()
                        )
                )
        );
        *///?}
	}

    //? if > 1.21.1
    /*@SuppressWarnings("DataFlowIssue")*/
    public static int determineUnitCost(class_1799 stack) {
        if (SSO.CONFIG.streamlinedRepairs.modifyAnvilRepairUnitCosts.get() && !stack.method_31574(class_1802.field_8162)) {
            if (stack.method_31573(class_3489.field_48297)) return SSO.CONFIG.streamlinedRepairs.armor.headArmorUnits.get();
            if (stack.method_31573(class_3489.field_48296)) return SSO.CONFIG.streamlinedRepairs.armor.chestArmorUnits.get();
            if (stack.method_31573(class_3489.field_48295)) return SSO.CONFIG.streamlinedRepairs.armor.legArmorUnits.get();
            if (stack.method_31573(class_3489.field_48294)) return SSO.CONFIG.streamlinedRepairs.armor.footArmorUnits.get();
            //? if <= 1.21.1 {
            if (stack.method_7909() instanceof class_4059 aai) {
                if (aai.method_55756().equals(class_4059.class_9076.field_47825)) return SSO.CONFIG.streamlinedRepairs.armor.horseArmorUnits.get();
                if (aai.method_55756().equals(class_4059.class_9076.field_47826)) return SSO.CONFIG.streamlinedRepairs.armor.wolfArmorUnits.get();
            }
            //?} else {
            /*if (stack.has(DataComponents.EQUIPPABLE)) {
                Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
                if (equippable.canBeEquippedBy(EntityType.WOLF)) return SSO.CONFIG.streamlinedRepairs.armor.wolfArmorUnits.get();
                if (equippable.canBeEquippedBy(EntityType.HORSE)) return SSO.CONFIG.streamlinedRepairs.armor.horseArmorUnits.get();
            }
            *///?}

            if (stack.method_31573(class_3489.field_42614)) return SSO.CONFIG.streamlinedRepairs.tools.pickaxeUnits.get();
            if (stack.method_31573(class_3489.field_42612)) return SSO.CONFIG.streamlinedRepairs.tools.axeUnits.get();
            if (stack.method_31573(class_3489.field_42611)) return SSO.CONFIG.streamlinedRepairs.tools.swordUnits.get();
            if (stack.method_31573(class_3489.field_42613)) return SSO.CONFIG.streamlinedRepairs.tools.hoeUnits.get();
            if (stack.method_31573(class_3489.field_42615)) return SSO.CONFIG.streamlinedRepairs.tools.shovelUnits.get();

            if (stack.method_31574(class_1802.field_8255)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.shieldUnits.get();
            if (stack.method_31574(class_1802.field_8833)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.elytraUnits.get();
            if (stack.method_31574(class_1802.field_49814)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.maceUnits.get();
            if (stack.method_31574(ModItems.WHETSTONE)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.whetstoneUnits.get();
            if (stack.method_31574(class_1802.field_8102)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.bowUnits.get();
            if (stack.method_31574(class_1802.field_8399)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.crossbowUnits.get();
            if (stack.method_31574(class_1802.field_8884)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.flintAndSteelUnits.get();
            if (stack.method_31574(class_1802.field_8868)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.shearsUnits.get();
            if (stack.method_31574(class_1802.field_8547)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.tridentUnits.get();
            if (stack.method_31574(class_1802.field_42716)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.brushUnits.get();
            if (stack.method_31574(class_1802.field_8378)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.fishingRodUnits.get();
            if (stack.method_31574(class_1802.field_8184)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.carrotOnAStickUnits.get();
            if (stack.method_31574(class_1802.field_23254)) return SSO.CONFIG.streamlinedRepairs.uniqueItems.warpedFungusOnAStickUnits.get();

            for (Map.Entry<String, Integer> entry : SSO.CONFIG.streamlinedRepairs.modItemUnitCosts.entrySet()) {
                if (entry.getKey().startsWith("#")) {
                    if (stack.method_31573(class_6862.method_40092(class_7924.field_41197, class_2960.method_60654(entry.getKey().replace("#", ""))))) {
                        return entry.getValue();
                    }
                } else {
                    Optional<class_1792> item = class_7923.field_41178.method_17966(class_2960.method_60654(entry.getKey()));
                    if (item.isPresent() && stack.method_31574(item.get())) {
                        return entry.getValue();
                    }
                }
            }
        }
        return 4;
    }

	public static void initItemProperties() {
		//? if <= 1.21.1 {
		class_5272.method_27879(
				ModItems.WHETSTONE,
				SSO.id("damage_state"),
				(stack, level, entity, i) -> (float) stack.method_7919() / stack.method_7936()
		);
		//?}
	}

    public static int calculateGrindstoneReward(Object2IntMap.Entry<class_6880<class_1887>> entry) {
        class_1887 e = entry.getKey().comp_349();
        int level = entry.getIntValue();
        int min = e.method_8182(level);
        int max = e.method_20742(level);
        return Math.round(min + (max - min) * ((float) level / e.method_8183()));
    }

    public static boolean isEnchantedBookOrWhetstoneUpgradeRecipe(class_2371<class_1735> slots) {
        return slots.get(0).method_7677().method_31574(ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE) &&
                (slots.get(1).method_7677().method_31574(class_1802.field_8598) || slots.get(1).method_7677().method_31574(ModItems.WHETSTONE)) &&
                slots.get(1).method_7677().method_57826(class_9334.field_49643);
    }

    public static boolean isEnchantedItemUpgradeRecipe(class_2371<class_1735> slots) {
        return slots.get(0).method_7677().method_31574(ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE) &&
                slots.get(1).method_7677().method_57826(class_9334.field_50072) &&
                slots.get(1).method_7677().method_7914() == 1 &&
                slots.get(1).method_7677().method_57826(class_9334.field_49633);
    }

    public static boolean isPinnacleEnchantmentRecipe(class_2371<class_1735> slots) {
        return slots.get(0).method_7677().method_31574(ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE) &&
                slots.get(1).method_7677().method_57826(class_9334.field_50072) &&
                slots.get(1).method_7677().method_7914() == 1 &&
                slots.get(1).method_7677().method_57826(class_9334.field_49633) &&
                slots.get(2).method_7677().method_31574(class_1802.field_38746);
    }

    public static boolean enchantmentEligible(class_6880<class_1887> enchantment) {
        return SSO.CONFIG.pinnacleEnchantment.excludedFromMaxedOutCheck.stream()
                .noneMatch(enchantment::method_40226) && (!CompatFlags.ED_LOADED || EDCompat.enchantmentEnabled(enchantment));
    }

    public static class_1792 getNetheriteRepairMaterial() {
        return switch (SSO.CONFIG.streamlinedRepairs.netheriteRepairMaterial.get()) {
            case DIAMOND -> class_1802.field_8477;
            case NETHERITE_SCRAP -> class_1802.field_22021;
            default -> class_1802.field_22020;
        };
    }

    public static boolean hasAdditionalRepair(class_1799 stack, class_1799 repairCandidate) {
        for (Map.Entry<class_1856, class_1856> tagRepair : additionalRepairables.entrySet()) {
            if (tagRepair.getKey().method_8093(stack)) return tagRepair.getValue().method_8093(repairCandidate);
        }
        return false;
    }

    public static boolean isBroken(class_1799 stack) {
        return stack.method_57825(ModDataComponents.BROKEN, false);
    }

    public static void payXpCost(class_1657 player, int cost) {
        if (CompatFlags.TAX_FREE_LEVELS_LOADED) TFLCompat.payXpCost(player, cost);
        else player.method_7316(-cost);
    }

    public static int calculateNewEnchantmentLevel(int maxLevel, class_5819 randomSource, int original) {
        if (SSO.CONFIG.enchantedBookLootTweaks.weightedLevels.get()) {
            // fills up a pool with enchantment levels and picks a level randomly
            // for level 5 the pool would look like this
            // 1 x lv5, 9 x lv4, 25 x lv3, 49 x lv2, 81 x lv1
            if (maxLevel == 1) return 1;
            IntList pool = new IntArrayList();
            for (int i = maxLevel, j = 1; i > 0; i--, j += 2) {
                for (int k = 0; k < j * j; k++) {
                    pool.add(i);
                }
            }
            return pool.getInt(randomSource.method_43048(pool.size()));
        }
        return original;
    }

	public static class_1269 canUse(class_1657 player, class_1268 hand) {
		return ModUtil.isBroken(player.method_5998(hand)) ? class_1269.field_5814 : class_1269.field_5811;
	}

	private static class_1856 ingredientFromItemTag(String s, class_7225<class_1792> registry) {
		return class_1856.method_8106(/*? if > 1.21.1 {*//*registry.get(*//*?}*/class_6862.method_40092(class_7924.field_41197, class_2960.method_12829(s.substring(1)))/*? if > 1.21.1 {*//*).orElseThrow()*//*?}*/);
	}

    public static List<String> colorNames = List.of(
            "Black",
            "Dark Blue",
            "Dark Green",
            "Dark Aqua",
            "Dark Red",
            "Dark Purple",
            "Gold",
            "Gray",
            "Dark Gray",
            "Blue",
            "Green",
            "Aqua",
            "Red",
            "Light Purple",
            "Yellow",
            "White"
    );
}
