/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.recipe;

import java.util.List;
import java.util.Optional;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.recipe.ModRecipeSerializers;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;

public class PortableItemRepairRecipe
extends class_1852 {
    private class_1799 itemToRepair;
    private List<class_1799> repairMaterials;
    private List<class_1799> repairableItems;
    private int unitCost;
    private int flintCount = 0;
    private class_5819 random;

    public PortableItemRepairRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(@NotNull class_9694 input, @NotNull class_1937 level) {
        this.random = level.method_8409();
        List<class_1799> whetstones = input.method_59989().stream().filter(itemStack -> itemStack.method_31574(ModItems.WHETSTONE)).toList();
        List<class_1799> flint = input.method_59989().stream().filter(itemStack -> itemStack.method_31574(class_1802.field_8145)).toList();
        if (whetstones.isEmpty() ^ flint.isEmpty()) {
            if (whetstones.size() == 1) {
                class_1799 whetstone = whetstones.getFirst();
                this.repairableItems = input.method_59989().stream().filter(itemStack -> itemStack.method_7963() && !itemStack.method_31574(ModItems.WHETSTONE)).toList();
                if (!this.repairableItems.isEmpty()) {
                    this.itemToRepair = this.repairableItems.getFirst();
                    if (this.itemToRepair.method_7986() && whetstone.method_7919() < whetstone.method_7936()) {
                        class_9304 whetstoneEnchantments = (class_9304)whetstone.method_57825(class_9334.field_49643, (Object)class_9304.field_49385);
                        if (this.itemToRepair.method_58657().method_57539().stream().allMatch(entry -> whetstoneEnchantments.method_57536((class_6880)entry.getKey()) >= Math.min(entry.getIntValue(), ((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183()))) {
                            return this.processRepair(input);
                        }
                    }
                }
            } else if (flint.size() == 1) {
                this.flintCount = flint.getFirst().method_7947();
                this.repairableItems = input.method_59989().stream().filter(itemStack -> itemStack.method_7963() && !itemStack.method_31574(class_1802.field_8145)).toList();
                if (!this.repairableItems.isEmpty()) {
                    this.itemToRepair = this.repairableItems.getFirst();
                    if (this.itemToRepair.method_7986() && !this.itemToRepair.method_7942()) {
                        return this.processRepair(input);
                    }
                }
            }
        }
        return false;
    }

    private boolean processRepair(class_9694 input) {
        this.unitCost = ModUtil.determineUnitCost(this.itemToRepair);
        int damageRepairedPerUnit = Math.round((float)this.itemToRepair.method_7936() / (float)this.unitCost);
        int unitsToMaxRepair = this.itemToRepair.method_7919() / damageRepairedPerUnit;
        this.repairMaterials = input.method_59989().stream().filter(itemStack -> ModUtil.hasAdditionalRepair(this.itemToRepair, itemStack) || this.itemToRepair.method_7909().method_7878(this.itemToRepair, itemStack)).toList();
        boolean flintMaterialValid = true;
        if (this.flintCount > 0) {
            for (String s : (List)SSO.CONFIG.streamlinedRepairs.flintMaterialBlacklist.get()) {
                for (class_1799 i : this.repairMaterials) {
                    Optional opt = class_7923.field_41178.method_17966(class_2960.method_12829((String)s));
                    if (!opt.isPresent() || !i.method_31574((class_1792)opt.get())) continue;
                    flintMaterialValid = false;
                }
            }
        }
        return !this.repairMaterials.isEmpty() && this.repairMaterials.size() <= unitsToMaxRepair + 1 && (this.flintCount == 0 || flintMaterialValid && this.flintCount >= this.repairMaterials.size());
    }

    @NotNull
    public class_1799 assemble(@NotNull class_9694 input, @NotNull class_7225.class_7874 registries) {
        class_1799 outputItem = this.itemToRepair.method_7972();
        outputItem.method_7974(outputItem.method_7919() - Math.round((float)outputItem.method_7936() / (float)this.unitCost) * this.repairMaterials.size());
        outputItem.method_57379(ModDataComponents.REPAIR_COUNT, (Object)((Integer)outputItem.method_57825(ModDataComponents.REPAIR_COUNT, (Object)0) + 1));
        return outputItem;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_9694 input) {
        List<class_1799> otherGear = this.repairableItems.subList(1, this.repairableItems.size());
        class_2371 remainingItems = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < remainingItems.size(); ++i) {
            class_1799 itemStack = input.method_59984(i);
            if (itemStack.method_31574(ModItems.WHETSTONE)) {
                float degradationChance;
                float f = degradationChance = (Boolean)SSO.CONFIG.anvilImprovements.modifyDegradationChance.get() != false ? ((Float)SSO.CONFIG.anvilImprovements.degradationChance.get()).floatValue() / 50.0f : 0.24f;
                if (this.random.method_43057() < degradationChance) {
                    itemStack.method_7974(itemStack.method_7919() + 1);
                }
                remainingItems.set(i, (Object)itemStack.method_7972());
                continue;
            }
            if (itemStack.method_31574(class_1802.field_8145)) {
                class_1799 updated = new class_1799((class_1935)class_1802.field_8145);
                updated.method_7939(itemStack.method_7947() - this.repairMaterials.size());
                itemStack.method_7939(0);
                remainingItems.set(i, (Object)updated);
                continue;
            }
            if (otherGear.contains(itemStack)) {
                remainingItems.set(i, (Object)itemStack.method_7972());
                continue;
            }
            if (itemStack.method_31574(this.repairMaterials.getFirst().method_7909()) || itemStack.method_31574(this.repairableItems.getFirst().method_7909())) continue;
            remainingItems.set(i, (Object)new class_1799((class_1935)itemStack.method_7909()));
        }
        return remainingItems;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 4;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return ModRecipeSerializers.PORTABLE_ITEM_REPAIR;
    }
}

