/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.blocks.ModBlocks;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class}, priority=2000)
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    public int repairItemCountCost;
    @Shadow
    @Final
    private DataSlot cost;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access, ItemCombinerMenuSlotDefinition slotDefinition) {
        super(menuType, containerId, inventory, access, slotDefinition);
    }

    @WrapMethod(method={"createResult"})
    private void nonFunctionalIfBroken(Operation<Void> original) {
        Optional bl = this.access.evaluate((level, blockPos) -> level.getBlockState(blockPos).is(ModBlocks.BROKEN_ANVIL));
        if (bl.isPresent() && !((Boolean)bl.get()).booleanValue()) {
            original.call(new Object[0]);
        }
    }

    @ModifyArg(method={"lambda$onTake$2"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;levelEvent(ILnet/minecraft/core/BlockPos;I)V", ordinal=1), index=0)
    private static int breakSoundIfBroken(int original, @Local(ordinal=1) BlockState blockState2) {
        return blockState2.is(ModBlocks.BROKEN_ANVIL) ? 1029 : original;
    }

    @ModifyExpressionValue(method={"createResultInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;supportsEnchantment(Lnet/minecraft/core/Holder;)Z")})
    private boolean allowAddingEnchantmentsToWhetstone(boolean original, @Local(ordinal=0) ItemStack itemStack) {
        if (((Boolean)SSO.CONFIG.whetstone.enableWhetstone.get()).booleanValue()) {
            return original || itemStack.is(ModItems.WHETSTONE);
        }
        return original;
    }

    @ModifyArg(method={"createResultInternal"}, at=@At(value="INVOKE", target="Ljava/lang/Math;min(II)I"), index=1)
    private int modifyRepairUnitCost(int original, @Local(ordinal=1) ItemStack itemStack) {
        return Math.round((float)itemStack.getMaxDamage() / (float)ModUtil.determineUnitCost(itemStack));
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void noXPCostIfUnenchanted(Player player, ItemStack itemStack, CallbackInfo ci) {
        if (((Boolean)SSO.CONFIG.anvilImprovements.freeUnenchantedRepairs.get()).booleanValue() && !itemStack.isEnchanted() && ((ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()) {
            this.cost.set(0);
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void grantAdvancements(Player player, ItemStack stack, CallbackInfo ci) {
        if (this.resultSlots.getItem(0).getDamageValue() < this.inputSlots.getItem(0).getDamageValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)player;
                ModCriteria.REPAIR_ITEM.trigger(p);
            }
            int repairCount = (Integer)stack.getOrDefault(ModDataComponents.REPAIR_COUNT, (Object)0);
            if (player instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)player;
                if (repairCount + 1 == 100) {
                    ModCriteria.ITEM_REPAIR_COUNT.trigger(p);
                }
                if (repairCount + 1 == 1000) {
                    ModCriteria.ITEM_REPAIR_COUNT_BIG.trigger(p);
                }
            }
            stack.set(ModDataComponents.REPAIR_COUNT, (Object)(repairCount + 1));
        }
        if (this.inputSlots.getItem(1).is(Items.ENCHANTED_BOOK) && !this.inputSlots.getItem(0).is(Items.ENCHANTED_BOOK) && player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            ModCriteria.ANVIL_ENCHANT_COMBINE.trigger(p);
        }
        if (this.resultSlots.getItem(0).is(ModItems.WHETSTONE)) {
            HashSet allEnchantments = new HashSet();
            player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).listElements().forEach(ref -> {
                if (ModUtil.enchantmentEligible((Holder<Enchantment>)ref)) {
                    allEnchantments.add(new EnchantmentInstance((Holder)ref, ((Enchantment)ref.value()).getMaxLevel()));
                }
            });
            Set whetstoneEnchantments = this.resultSlots.getItem(0).getEnchantments().entrySet().stream().map(entry -> new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue())).collect(Collectors.toSet());
            if (whetstoneEnchantments.containsAll(allEnchantments) && player instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)player;
                ModCriteria.MAX_WHETSTONE.trigger(p);
            }
        }
    }

    @ModifyArg(method={"createResultInternal"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(JJJ)J"), index=0)
    private long modifyXPCost(long value, @Local long l, @Local(ordinal=1) int j) {
        if (((Boolean)SSO.CONFIG.anvilImprovements.freeRenames.get()).booleanValue()) {
            value -= (long)j;
        }
        if (value == l) {
            value = 0L;
        }
        if (value != 0L && ((Boolean)SSO.CONFIG.anvilImprovements.noPriorWorkCost.get()).booleanValue()) {
            value -= l;
        }
        return value;
    }

    @IfModLoaded(value="taxfreelevels")
    @Inject(method={"createResultInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=2)})
    private void interceptRenameCostSet(CallbackInfo ci, @Local(ordinal=0) int i, @Local(ordinal=1) int j) {
        if (((Boolean)SSO.CONFIG.anvilImprovements.freeRenames.get()).booleanValue() && j > 0 && j == i) {
            this.cost.set(0);
        }
    }

    @ModifyExpressionValue(method={"mayPickup"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;get()I", ordinal=1)})
    private int allowTakingFreeRepairs(int original) {
        return original == 0 && this.repairItemCountCost >= 0 ? 1 : original;
    }

    @WrapOperation(method={"createResultInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AnvilMenu;calculateIncreasedRepairCost(I)I")})
    private int preventPriorWorkCostIncrease(int oldRepairCost, Operation<Integer> original) {
        if (((Boolean)SSO.CONFIG.anvilImprovements.noPriorWorkCost.get()).booleanValue()) {
            return oldRepairCost;
        }
        if (((Boolean)SSO.CONFIG.anvilImprovements.noWorkCostIncreaseOnRepair.get()).booleanValue() && this.inputSlots.getItem(0).isDamageableItem() && this.inputSlots.getItem(0).has(DataComponents.REPAIRABLE) && ((Repairable)this.inputSlots.getItem(0).get(DataComponents.REPAIRABLE)).isValidRepairItem(this.inputSlots.getItem(1))) {
            return oldRepairCost;
        }
        return (Integer)original.call(new Object[]{oldRepairCost});
    }

    @ModifyExpressionValue(method={"createResultInternal"}, at={@At(value="CONSTANT", args={"intValue=40"})})
    private int ignoreTooExpensive(int original) {
        if (((Boolean)SSO.CONFIG.anvilImprovements.noTooExpensive.get()).booleanValue()) {
            return Integer.MAX_VALUE;
        }
        return original;
    }
}

