/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.recipe.UpgradeRecipeHandler;
import me.pajic.simple_smithing_overhaul.util.CostAccess;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={ItemCombinerMenu.class})
public abstract class ItemCombinerMenuMixin
extends AbstractContainerMenu
implements CostAccess {
    @Unique
    private int cost = 0;

    protected ItemCombinerMenuMixin(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @ModifyArg(method={"quickMoveStack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ItemCombinerMenu;moveItemStackTo(Lnet/minecraft/world/item/ItemStack;IIZ)Z", ordinal=0), index=0)
    private ItemStack upgradeItemAfterQuickMove(ItemStack original, @Local Slot slot) {
        return UpgradeRecipeHandler.applyPinnacleUpgrade(original, slot, (AbstractContainerMenu)((ItemCombinerMenu)this), (NonNullList<Slot>)this.slots);
    }

    @WrapMethod(method={"mayPickup"})
    private boolean modifyMayPickup(Player player, boolean hasStack, Operation<Boolean> original) {
        if (((Boolean)SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get()).booleanValue() && ((Boolean)SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()).booleanValue() && (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe((NonNullList<Slot>)this.slots) || ModUtil.isEnchantedItemUpgradeRecipe((NonNullList<Slot>)this.slots))) {
            return (player.hasInfiniteMaterials() || player.experienceLevel >= this.cost) && this.cost > 0;
        }
        if (((Boolean)SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()).booleanValue() && ModUtil.isPinnacleEnchantmentRecipe((NonNullList<Slot>)this.slots)) {
            return (player.hasInfiniteMaterials() || player.experienceLevel >= this.cost) && this.cost > 0;
        }
        return (Boolean)original.call(new Object[]{player, hasStack});
    }

    @Override
    public int sso$getCost() {
        return this.cost;
    }

    @Override
    public void sso$setCost(int cost) {
        this.cost = cost;
    }
}

