/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.recipe;

import java.util.List;
import java.util.Optional;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.recipe.ModRecipeSerializers;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PortableItemRepairRecipe
extends CustomRecipe {
    private ItemStack itemToRepair;
    private List<ItemStack> repairMaterials;
    private List<ItemStack> repairableItems;
    private int unitCost;
    private int flintCount = 0;
    private RandomSource random;

    public PortableItemRepairRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        this.random = level.getRandom();
        List<ItemStack> whetstones = input.items().stream().filter(itemStack -> itemStack.is(ModItems.WHETSTONE)).toList();
        List<ItemStack> flint = input.items().stream().filter(itemStack -> itemStack.is(Items.FLINT)).toList();
        if (whetstones.isEmpty() ^ flint.isEmpty()) {
            if (whetstones.size() == 1) {
                ItemStack whetstone = whetstones.getFirst();
                this.repairableItems = input.items().stream().filter(itemStack -> itemStack.isDamageableItem() && !itemStack.is(ModItems.WHETSTONE)).toList();
                if (!this.repairableItems.isEmpty()) {
                    this.itemToRepair = this.repairableItems.getFirst();
                    if (this.itemToRepair.isDamaged() && whetstone.getDamageValue() < whetstone.getMaxDamage()) {
                        ItemEnchantments whetstoneEnchantments = (ItemEnchantments)whetstone.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                        if (this.itemToRepair.getEnchantments().entrySet().stream().allMatch(entry -> whetstoneEnchantments.getLevel((Holder)entry.getKey()) >= Math.min(entry.getIntValue(), ((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel()))) {
                            return this.processRepair(input);
                        }
                    }
                }
            } else if (flint.size() == 1) {
                this.flintCount = flint.getFirst().getCount();
                this.repairableItems = input.items().stream().filter(itemStack -> itemStack.isDamageableItem() && !itemStack.is(Items.FLINT)).toList();
                if (!this.repairableItems.isEmpty()) {
                    this.itemToRepair = this.repairableItems.getFirst();
                    if (this.itemToRepair.isDamaged() && !this.itemToRepair.isEnchanted()) {
                        return this.processRepair(input);
                    }
                }
            }
        }
        return false;
    }

    private boolean processRepair(CraftingInput input) {
        this.unitCost = ModUtil.determineUnitCost(this.itemToRepair);
        int damageRepairedPerUnit = Math.round((float)this.itemToRepair.getMaxDamage() / (float)this.unitCost);
        int unitsToMaxRepair = this.itemToRepair.getDamageValue() / damageRepairedPerUnit;
        this.repairMaterials = input.items().stream().filter(itemStack -> {
            if (this.itemToRepair.has(DataComponents.REPAIRABLE)) {
                return ((Repairable)this.itemToRepair.get(DataComponents.REPAIRABLE)).isValidRepairItem(itemStack);
            }
            return false;
        }).toList();
        boolean flintMaterialValid = true;
        if (this.flintCount > 0) {
            for (String s : (List)SSO.CONFIG.streamlinedRepairs.flintMaterialBlacklist.get()) {
                for (ItemStack i : this.repairMaterials) {
                    Optional opt = BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)s));
                    if (!opt.isPresent() || !i.is((Item)opt.get())) continue;
                    flintMaterialValid = false;
                }
            }
        }
        return !this.repairMaterials.isEmpty() && this.repairMaterials.size() <= unitsToMaxRepair + 1 && (this.flintCount == 0 || flintMaterialValid && this.flintCount >= this.repairMaterials.size());
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        ItemStack outputItem = this.itemToRepair.copy();
        outputItem.setDamageValue(outputItem.getDamageValue() - Math.round((float)outputItem.getMaxDamage() / (float)this.unitCost) * this.repairMaterials.size());
        outputItem.set(ModDataComponents.REPAIR_COUNT, (Object)((Integer)outputItem.getOrDefault(ModDataComponents.REPAIR_COUNT, (Object)0) + 1));
        return outputItem;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        List<ItemStack> otherGear = this.repairableItems.subList(1, this.repairableItems.size());
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemStack = input.getItem(i);
            if (itemStack.is(ModItems.WHETSTONE)) {
                float degradationChance;
                float f = degradationChance = (Boolean)SSO.CONFIG.anvilImprovements.modifyDegradationChance.get() != false ? ((Float)SSO.CONFIG.anvilImprovements.degradationChance.get()).floatValue() / 50.0f : 0.24f;
                if (this.random.nextFloat() < degradationChance) {
                    itemStack.setDamageValue(itemStack.getDamageValue() + 1);
                }
                remainingItems.set(i, (Object)itemStack.copy());
                continue;
            }
            if (itemStack.is(Items.FLINT)) {
                ItemStack updated = new ItemStack((ItemLike)Items.FLINT);
                updated.setCount(itemStack.getCount() - this.repairMaterials.size());
                itemStack.setCount(0);
                remainingItems.set(i, (Object)updated);
                continue;
            }
            if (otherGear.contains(itemStack)) {
                remainingItems.set(i, (Object)itemStack.copy());
                continue;
            }
            if (itemStack.is(this.repairMaterials.getFirst().getItem()) || itemStack.is(this.repairableItems.getFirst().getItem())) continue;
            remainingItems.set(i, (Object)new ItemStack((ItemLike)itemStack.getItem()));
        }
        return remainingItems;
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return ModRecipeSerializers.PORTABLE_ITEM_REPAIR;
    }
}

