/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.recipe;

import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.util.CostAccess;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class UpgradeRecipeHandler {
    public static void handleRecipe(CallbackInfo ci, LocalRef<ItemStack> stack, NonNullList<Slot> slots, ResultContainer resultSlots, Level level, ItemCombinerMenu menu) {
        if (((Boolean)SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get()).booleanValue()) {
            ItemEnchantments itemEnchantments = null;
            if (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe(slots)) {
                itemEnchantments = (ItemEnchantments)((ItemStack)stack.get()).get(DataComponents.STORED_ENCHANTMENTS);
            } else if (ModUtil.isEnchantedItemUpgradeRecipe(slots)) {
                itemEnchantments = (ItemEnchantments)((ItemStack)stack.get()).get(DataComponents.ENCHANTMENTS);
            }
            if (itemEnchantments != null) {
                boolean success = false;
                int lapisAmount = ((Slot)slots.get(2)).getItem().getCount();
                if (lapisAmount <= itemEnchantments.entrySet().size() && ((Slot)slots.get(1)).getItem().getCount() == 1) {
                    ItemStack updatedStack = ((Slot)slots.get(1)).getItem().copy();
                    ArrayList enchantmentNames = new ArrayList();
                    Consumer<Component> consumer = enchantmentNames::add;
                    itemEnchantments.addToTooltip(Item.TooltipContext.of((Level)level), consumer, (TooltipFlag)TooltipFlag.NORMAL, (DataComponentGetter)updatedStack.getComponents());
                    block0: for (int i = 0; i < enchantmentNames.size(); ++i) {
                        if (i + 1 != lapisAmount) continue;
                        Component enchantmentName = (Component)enchantmentNames.get(i);
                        for (Object2IntMap.Entry entry2 : itemEnchantments.entrySet()) {
                            if (!Enchantment.getFullname((Holder)((Holder)entry2.getKey()), (int)entry2.getIntValue()).equals((Object)enchantmentName) || entry2.getIntValue() >= ((Enchantment)((Holder)entry2.getKey()).value()).getMaxLevel()) continue;
                            EnchantmentHelper.updateEnchantments((ItemStack)updatedStack, mutable -> mutable.upgrade((Holder)entry2.getKey(), entry2.getIntValue() + 1));
                            if (((Boolean)SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()).booleanValue()) {
                                int originalRepairCost = (Integer)((ItemStack)stack.get()).getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                                ((CostAccess)menu).sso$setCost((Integer)SSO.CONFIG.enchantmentUpgrading.upgradingBaseExperienceCost.get() + originalRepairCost);
                                if (((CostAccess)menu).sso$getCost() < 1 || !((Boolean)SSO.CONFIG.enchantmentUpgrading.ignoreTooExpensive.get()).booleanValue() && ((CostAccess)menu).sso$getCost() >= 40) continue block0;
                                updatedStack.set(DataComponents.REPAIR_COST, (Object)AnvilMenu.calculateIncreasedRepairCost((int)originalRepairCost));
                            }
                            stack.set((Object)updatedStack);
                            success = true;
                            continue block0;
                        }
                    }
                }
                if (!success) {
                    resultSlots.setItem(0, ItemStack.EMPTY);
                    ci.cancel();
                }
            }
        }
        if (((Boolean)SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()).booleanValue() && ModUtil.isPinnacleEnchantmentRecipe(slots)) {
            boolean success = false;
            if (((Slot)slots.get(1)).getItem().getCount() == 1) {
                Registry registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                ItemStack itemStack = ((Slot)slots.get(1)).getItem().copy();
                Set<EnchantmentInstance> itemEnchantments = itemStack.getEnchantments().entrySet().stream().map(entry -> new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue())).collect(Collectors.toSet());
                if (itemEnchantments.stream().allMatch(arg_0 -> UpgradeRecipeHandler.lambda$handleRecipe$2((HolderLookup.RegistryLookup)registry, arg_0))) {
                    Set possibleUpgrades;
                    HashSet<EnchantmentInstance> maxedOutEnchantments = new HashSet<EnchantmentInstance>();
                    registry.listElements().forEach(ref -> {
                        if (((Enchantment)ref.value()).canEnchant(itemStack) && ModUtil.enchantmentEligible((Holder<Enchantment>)ref)) {
                            maxedOutEnchantments.add(new EnchantmentInstance((Holder)ref, ((Enchantment)ref.value()).getMaxLevel()));
                        }
                    });
                    maxedOutEnchantments.removeIf(arg_0 -> UpgradeRecipeHandler.lambda$handleRecipe$4((HolderLookup.RegistryLookup)registry, arg_0));
                    itemEnchantments.forEach(ei -> maxedOutEnchantments.removeIf(ei1 -> !Enchantment.areCompatible((Holder)ei1.enchantment(), (Holder)ei.enchantment())));
                    if (maxedOutEnchantments.isEmpty() && !(possibleUpgrades = itemEnchantments.stream().filter(ei -> ((Enchantment)ei.enchantment().value()).getMaxLevel() > 1 && ei.level() <= ((Enchantment)ei.enchantment().value()).getMaxLevel() && ModUtil.enchantmentEligible((Holder<Enchantment>)ei.enchantment())).collect(Collectors.toSet())).isEmpty()) {
                        success = true;
                        ((CostAccess)menu).sso$setCost((Integer)SSO.CONFIG.pinnacleEnchantment.pinnacleBaseExperienceCost.get() + (Integer)SSO.CONFIG.pinnacleEnchantment.pinnacleExperienceCostIncrease.get() * (Integer)itemStack.getOrDefault(ModDataComponents.PINNACLE_COUNT, (Object)0));
                        ItemStack updatedStack = ((Slot)slots.get(1)).getItem().copy();
                        updatedStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"text.item.simple_smithing_overhaul.pinnacleCustomName").withStyle(ChatFormatting.LIGHT_PURPLE));
                        stack.set((Object)updatedStack);
                    }
                }
            }
            if (!success) {
                resultSlots.setItem(0, ItemStack.EMPTY);
                ci.cancel();
            }
        }
    }

    public static ItemStack applyPinnacleUpgrade(ItemStack original, Slot slot, AbstractContainerMenu container, NonNullList<Slot> slots) {
        if (container instanceof SmithingMenu) {
            SmithingMenu sm = (SmithingMenu)container;
            if (ModUtil.isPinnacleEnchantmentRecipe(slots) && slot.equals(slots.get(3))) {
                RandomSource random = sm.level.getRandom();
                Component itemName = (Component)((Slot)slots.get(1)).getItem().getOrDefault(DataComponents.CUSTOM_NAME, (Object)original.getItem().getName(original));
                original.set(DataComponents.CUSTOM_NAME, (Object)itemName.copy().withStyle(ChatFormatting.getByName((String)((String)SSO.CONFIG.pinnacleEnchantment.pinnacleItemNameColor.get()).replace(" ", "_").toUpperCase())));
                List<EnchantmentInstance> existingPinnacleEnchantments = original.getEnchantments().entrySet().stream().map(entry -> new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue())).filter(ei -> ei.level() > ((Enchantment)ei.enchantment().value()).getMaxLevel()).toList();
                if (existingPinnacleEnchantments.size() >= (Integer)SSO.CONFIG.pinnacleEnchantment.maxPinnacleEnchantmentsOnItem.get()) {
                    int index = random.nextInt(existingPinnacleEnchantments.size());
                    EnchantmentInstance toDowngrade = existingPinnacleEnchantments.get(index);
                    EnchantmentHelper.updateEnchantments((ItemStack)original, mutable -> mutable.set(toDowngrade.enchantment(), ((Enchantment)toDowngrade.enchantment().value()).getMaxLevel()));
                }
                ArrayList<EnchantmentInstance> possibleUpgrades = new ArrayList<EnchantmentInstance>(original.getEnchantments().entrySet().stream().map(entry -> new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue())).toList());
                possibleUpgrades.removeIf(ei -> ((Enchantment)ei.enchantment().value()).getMaxLevel() == 1 || !ModUtil.enchantmentEligible((Holder<Enchantment>)ei.enchantment()) || existingPinnacleEnchantments.stream().anyMatch(ei1 -> ei.enchantment().equals((Object)ei1.enchantment())));
                EnchantmentInstance toUpgrade = (EnchantmentInstance)possibleUpgrades.get(random.nextInt(possibleUpgrades.size()));
                EnchantmentHelper.updateEnchantments((ItemStack)original, mutable -> mutable.upgrade(toUpgrade.enchantment(), toUpgrade.level() + 1));
                original.set(ModDataComponents.PINNACLE_COUNT, (Object)((Integer)original.getOrDefault(ModDataComponents.PINNACLE_COUNT, (Object)0) + 1));
            }
        }
        return original;
    }

    private static /* synthetic */ boolean lambda$handleRecipe$4(HolderLookup.RegistryLookup registry, EnchantmentInstance ei) {
        return registry.getOrThrow(EnchantmentTags.CURSE).contains(ei.enchantment());
    }

    private static /* synthetic */ boolean lambda$handleRecipe$2(HolderLookup.RegistryLookup registry, EnchantmentInstance ei) {
        return ei.level() >= ((Enchantment)ei.enchantment().value()).getMaxLevel() && !registry.getOrThrow(EnchantmentTags.CURSE).contains(ei.enchantment());
    }
}

