/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.compat.EDCompat;
import me.pajic.simple_smithing_overhaul.compat.TFLCompat;
import me.pajic.simple_smithing_overhaul.config.NetheriteRepairMaterials;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.CompatFlags;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;

public class ModUtil {
    public static final Map<Ingredient, Ingredient> additionalRepairables = new HashMap<Ingredient, Ingredient>();
    public static final List<String> itemSuggestions = new ArrayList<String>();
    public static List<String> colorNames = List.of("Black", "Dark Blue", "Dark Green", "Dark Aqua", "Dark Red", "Dark Purple", "Gold", "Gray", "Dark Gray", "Blue", "Green", "Aqua", "Red", "Light Purple", "Yellow", "White");

    public static void updateAdditionalRepairables(HolderLookup.Provider provider) {
        additionalRepairables.clear();
        HolderLookup.RegistryLookup registry = provider.lookupOrThrow(Registries.ITEM);
        additionalRepairables.put(Ingredient.of((ItemLike)Items.BOW), Ingredient.of((ItemLike)Items.STRING));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.CROSSBOW), Ingredient.of((ItemLike)Items.STRING));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.FISHING_ROD), Ingredient.of((ItemLike)Items.STRING));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.FLINT_AND_STEEL), Ingredient.of((ItemLike)Items.IRON_INGOT));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.SHEARS), Ingredient.of((ItemLike)Items.IRON_INGOT));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.BRUSH), Ingredient.of((ItemLike)Items.FEATHER));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.CARROT_ON_A_STICK), Ingredient.of((ItemLike)Items.CARROT));
        additionalRepairables.put(Ingredient.of((ItemLike)Items.WARPED_FUNGUS_ON_A_STICK), Ingredient.of((ItemLike)Items.WARPED_FUNGUS));
        if (!CompatFlags.BETTER_TRIDENTS_LOADED) {
            additionalRepairables.put(Ingredient.of((ItemLike)Items.TRIDENT), Ingredient.of((ItemLike)Items.PRISMARINE_SHARD));
        }
        SSO.CONFIG.streamlinedRepairs.modRepairableItems.forEach((arg_0, arg_1) -> ModUtil.lambda$updateAdditionalRepairables$2((HolderLookup)registry, arg_0, arg_1));
        additionalRepairables.forEach((itemIngredient, materialIngredient) -> itemIngredient.items().forEach(itemHolder -> {
            ((Item)itemHolder.value()).components = PatchedDataComponentMap.fromPatch((DataComponentMap)((Item)itemHolder.value()).components, (DataComponentPatch)DataComponentPatch.builder().set(DataComponents.REPAIRABLE, (Object)new Repairable((HolderSet)HolderSet.direct(materialIngredient.items().toList()))).build());
        }));
    }

    public static int determineUnitCost(ItemStack stack) {
        if (((Boolean)SSO.CONFIG.streamlinedRepairs.modifyAnvilRepairUnitCosts.get()).booleanValue() && !stack.is(Items.AIR)) {
            if (stack.is(ItemTags.HEAD_ARMOR)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.armor.headArmorUnits.get();
            }
            if (stack.is(ItemTags.CHEST_ARMOR)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.armor.chestArmorUnits.get();
            }
            if (stack.is(ItemTags.LEG_ARMOR)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.armor.legArmorUnits.get();
            }
            if (stack.is(ItemTags.FOOT_ARMOR)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.armor.footArmorUnits.get();
            }
            if (stack.has(DataComponents.EQUIPPABLE)) {
                Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
                if (equippable.canBeEquippedBy(EntityType.WOLF)) {
                    return (Integer)SSO.CONFIG.streamlinedRepairs.armor.wolfArmorUnits.get();
                }
                if (equippable.canBeEquippedBy(EntityType.HORSE)) {
                    return (Integer)SSO.CONFIG.streamlinedRepairs.armor.horseArmorUnits.get();
                }
            }
            if (stack.is(ItemTags.PICKAXES)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.tools.pickaxeUnits.get();
            }
            if (stack.is(ItemTags.AXES)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.tools.axeUnits.get();
            }
            if (stack.is(ItemTags.SWORDS)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.tools.swordUnits.get();
            }
            if (stack.is(ItemTags.HOES)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.tools.hoeUnits.get();
            }
            if (stack.is(ItemTags.SHOVELS)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.tools.shovelUnits.get();
            }
            if (stack.is(Items.SHIELD)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.shieldUnits.get();
            }
            if (stack.is(Items.ELYTRA)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.elytraUnits.get();
            }
            if (stack.is(Items.MACE)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.maceUnits.get();
            }
            if (stack.is(ModItems.WHETSTONE)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.whetstoneUnits.get();
            }
            if (stack.is(Items.BOW)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.bowUnits.get();
            }
            if (stack.is(Items.CROSSBOW)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.crossbowUnits.get();
            }
            if (stack.is(Items.FLINT_AND_STEEL)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.flintAndSteelUnits.get();
            }
            if (stack.is(Items.SHEARS)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.shearsUnits.get();
            }
            if (stack.is(Items.TRIDENT)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.tridentUnits.get();
            }
            if (stack.is(Items.BRUSH)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.brushUnits.get();
            }
            if (stack.is(Items.FISHING_ROD)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.fishingRodUnits.get();
            }
            if (stack.is(Items.CARROT_ON_A_STICK)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.carrotOnAStickUnits.get();
            }
            if (stack.is(Items.WARPED_FUNGUS_ON_A_STICK)) {
                return (Integer)SSO.CONFIG.streamlinedRepairs.uniqueItems.warpedFungusOnAStickUnits.get();
            }
            for (Map.Entry entry : SSO.CONFIG.streamlinedRepairs.modItemUnitCosts.entrySet()) {
                Optional item;
                if (!(((String)entry.getKey()).startsWith("#") ? stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)((String)entry.getKey()).replace("#", "")))) : (item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)((String)entry.getKey())))).isPresent() && stack.is((Item)item.get()))) continue;
                return (Integer)entry.getValue();
            }
        }
        return 4;
    }

    public static void initItemProperties() {
    }

    public static int calculateGrindstoneReward(Object2IntMap.Entry<Holder<Enchantment>> entry) {
        Enchantment e = (Enchantment)((Holder)entry.getKey()).value();
        int level = entry.getIntValue();
        int min = e.getMinCost(level);
        int max = e.getMaxCost(level);
        return Math.round((float)min + (float)(max - min) * ((float)level / (float)e.getMaxLevel()));
    }

    public static boolean isEnchantedBookOrWhetstoneUpgradeRecipe(NonNullList<Slot> slots) {
        return ((Slot)slots.get(0)).getItem().is(ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE) && (((Slot)slots.get(1)).getItem().is(Items.ENCHANTED_BOOK) || ((Slot)slots.get(1)).getItem().is(ModItems.WHETSTONE)) && ((Slot)slots.get(1)).getItem().has(DataComponents.STORED_ENCHANTMENTS);
    }

    public static boolean isEnchantedItemUpgradeRecipe(NonNullList<Slot> slots) {
        return ((Slot)slots.get(0)).getItem().is(ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE) && ((Slot)slots.get(1)).getItem().has(DataComponents.MAX_DAMAGE) && ((Slot)slots.get(1)).getItem().getMaxStackSize() == 1 && ((Slot)slots.get(1)).getItem().has(DataComponents.ENCHANTMENTS);
    }

    public static boolean isPinnacleEnchantmentRecipe(NonNullList<Slot> slots) {
        return ((Slot)slots.get(0)).getItem().is(ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE) && ((Slot)slots.get(1)).getItem().has(DataComponents.MAX_DAMAGE) && ((Slot)slots.get(1)).getItem().getMaxStackSize() == 1 && ((Slot)slots.get(1)).getItem().has(DataComponents.ENCHANTMENTS) && ((Slot)slots.get(2)).getItem().is(Items.ECHO_SHARD);
    }

    public static boolean enchantmentEligible(Holder<Enchantment> enchantment) {
        return SSO.CONFIG.pinnacleEnchantment.excludedFromMaxedOutCheck.stream().noneMatch(arg_0 -> enchantment.is(arg_0)) && (!CompatFlags.ED_LOADED || EDCompat.enchantmentEnabled(enchantment));
    }

    public static Item getNetheriteRepairMaterial() {
        return switch ((NetheriteRepairMaterials)((Object)SSO.CONFIG.streamlinedRepairs.netheriteRepairMaterial.get())) {
            case NetheriteRepairMaterials.DIAMOND -> Items.DIAMOND;
            case NetheriteRepairMaterials.NETHERITE_SCRAP -> Items.NETHERITE_SCRAP;
            default -> Items.NETHERITE_INGOT;
        };
    }

    public static boolean hasAdditionalRepair(ItemStack stack, ItemStack repairCandidate) {
        for (Map.Entry<Ingredient, Ingredient> tagRepair : additionalRepairables.entrySet()) {
            if (!tagRepair.getKey().test(stack)) continue;
            return tagRepair.getValue().test(repairCandidate);
        }
        return false;
    }

    public static boolean isBroken(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.BROKEN, (Object)false);
    }

    public static void payXpCost(Player player, int cost) {
        if (CompatFlags.TAX_FREE_LEVELS_LOADED) {
            TFLCompat.payXpCost(player, cost);
        } else {
            player.giveExperienceLevels(-cost);
        }
    }

    public static int calculateNewEnchantmentLevel(int maxLevel, RandomSource randomSource, int original) {
        if (((Boolean)SSO.CONFIG.enchantedBookLootTweaks.weightedLevels.get()).booleanValue()) {
            if (maxLevel == 1) {
                return 1;
            }
            IntArrayList pool = new IntArrayList();
            int i = maxLevel;
            int j = 1;
            while (i > 0) {
                for (int k = 0; k < j * j; ++k) {
                    pool.add(i);
                }
                --i;
                j += 2;
            }
            return pool.getInt(randomSource.nextInt(pool.size()));
        }
        return original;
    }

    public static InteractionResult canUse(Player player, InteractionHand hand) {
        return ModUtil.isBroken(player.getItemInHand(hand)) ? InteractionResult.FAIL : InteractionResult.PASS;
    }

    private static Ingredient ingredientFromItemTag(String s, HolderLookup<Item> registry) {
        return Ingredient.of((HolderSet)((HolderSet)registry.get(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)s.substring(1)))).orElseThrow()));
    }

    private static /* synthetic */ void lambda$updateAdditionalRepairables$2(HolderLookup registry, String repairItem, String repairMaterial) {
        try {
            if (repairItem.startsWith("#")) {
                if (repairMaterial.startsWith("#")) {
                    additionalRepairables.put(ModUtil.ingredientFromItemTag(repairItem, (HolderLookup<Item>)registry), ModUtil.ingredientFromItemTag(repairMaterial, (HolderLookup<Item>)registry));
                } else {
                    registry.get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)repairMaterial))).ifPresent(value -> additionalRepairables.put(ModUtil.ingredientFromItemTag(repairItem, (HolderLookup<Item>)registry), Ingredient.of((ItemLike)((ItemLike)value.value()))));
                }
            } else {
                Optional item = registry.get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)repairItem)));
                if (item.isPresent()) {
                    if (repairMaterial.startsWith("#")) {
                        additionalRepairables.put(Ingredient.of((ItemLike)((ItemLike)((Holder.Reference)item.get()).value())), ModUtil.ingredientFromItemTag(repairMaterial, (HolderLookup<Item>)registry));
                    } else {
                        registry.get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)repairMaterial))).ifPresent(value -> additionalRepairables.put(Ingredient.of((ItemLike)((ItemLike)((Holder.Reference)item.get()).value())), Ingredient.of((ItemLike)((ItemLike)value.value()))));
                    }
                }
            }
        }
        catch (Throwable t) {
            SSO.LOGGER.warn("Unable to load additional repair {} with {}, skipping: {}", new Object[]{repairItem, repairMaterial, t.getMessage()});
        }
    }
}

