/*
 * Decompiled with CFR 0.152.
 */
package net.hypestyle.ljm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Config {
    public String joinMessage = "&aWelcome, %player%!";
    public String quitMessage = "&c%player% has left the server.";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Config loadOrCreate(Path path) {
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Config def = new Config();
                Config.write(path, def);
                return def;
            }
            String json = Files.readString(path, StandardCharsets.UTF_8);
            Config cfg = (Config)GSON.fromJson(json, Config.class);
            if (cfg == null) {
                cfg = new Config();
            }
            return cfg;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config: " + e.getMessage(), e);
        }
    }

    private static void write(Path path, Config cfg) {
        try {
            String json = GSON.toJson((Object)cfg);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config: " + e.getMessage(), e);
        }
    }
}

