/*
 * Decompiled with CFR 0.152.
 */
package net.hypestyle.ljm;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.nio.file.Path;
import net.hypestyle.ljm.Config;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="ljm")
public class Ljm {
    public static final String MODID = "ljm";
    private static Config config;

    public Ljm() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Path cfgPath = FMLPaths.CONFIGDIR.get().resolve("ljm.json");
        config = Config.loadOrCreate(cfgPath);
    }

    public static boolean reloadConfig() {
        try {
            Path cfgPath = FMLPaths.CONFIGDIR.get().resolve("ljm.json");
            config = Config.loadOrCreate(cfgPath);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.f_8924_;
            if (server == null) {
                return;
            }
            String msg = Ljm.config.joinMessage.replace("%player%", player2.m_7755_().getString());
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)Ljm.translateColorCodes(msg)), false);
        }
    }

    @SubscribeEvent
    public void onQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.f_8924_;
            if (server == null) {
                return;
            }
            String msg = Ljm.config.quitMessage.replace("%player%", player2.m_7755_().getString());
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)Ljm.translateColorCodes(msg)), false);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ljmreload").requires(src -> src.m_6761_(2))).executes(ctx -> {
            if (Ljm.reloadConfig()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"LJM config reloaded!"), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to reload LJM config."));
            return 0;
        }));
    }

    private static String translateColorCodes(String s) {
        return s == null ? "" : s.replace('&', '\u00a7');
    }
}

