/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.minecraft.class_5253;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class TintColor {
    public static final TintColor WHITE = new TintColor(255, 255, 255, 255);
    public static Codec<TintColor> CODEC_ARGB = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).optionalFieldOf("alpha", (Object)255).forGetter(TintColor::alpha), (App)Codec.intRange((int)0, (int)255).optionalFieldOf("red", (Object)255).forGetter(TintColor::red), (App)Codec.intRange((int)0, (int)255).optionalFieldOf("green", (Object)255).forGetter(TintColor::green), (App)Codec.intRange((int)0, (int)255).optionalFieldOf("blue", (Object)255).forGetter(TintColor::blue)).apply((Applicative)instance, TintColor::new));
    public static Codec<TintColor> CODEC_STRING = Codec.STRING.xmap(TintColor::fromHex, TintColor::asHex);
    public static Codec<TintColor> CODEC = MapCodecs.xor(CODEC_ARGB, CODEC_STRING);
    public static class_9139<ByteBuf, TintColor> STREAM = class_9135.field_49675.method_56432(TintColor::unpack, TintColor::pack);
    private final int[] components;
    private final float[] percentages;

    public TintColor(int alpha, int red, int green, int blue) {
        this.components = new int[]{alpha, red, green, blue};
        this.percentages = new float[]{(float)alpha / 255.0f, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }

    public String asHex() {
        return Integer.toHexString(this.pack());
    }

    public float[] asPercents() {
        return this.percentages;
    }

    public int[] asArray() {
        return this.components;
    }

    public int pack() {
        return class_5253.class_5254.method_27764((int)this.alpha(), (int)this.red(), (int)this.green(), (int)this.blue());
    }

    public int alpha() {
        return this.components[0];
    }

    public int red() {
        return this.components[1];
    }

    public int green() {
        return this.components[2];
    }

    public int blue() {
        return this.components[3];
    }

    public static TintColor unpack(int color) {
        return new TintColor(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public static TintColor fromHex(String hexCode) {
        String original = hexCode;
        if (hexCode.startsWith("#")) {
            hexCode = hexCode.substring(1);
        }
        if (hexCode.length() == 6) {
            int red = Integer.valueOf(hexCode.substring(0, 2), 16);
            int green = Integer.valueOf(hexCode.substring(2, 4), 16);
            int blue = Integer.valueOf(hexCode.substring(4, 6), 16);
            return new TintColor(255, red, green, blue);
        }
        if (hexCode.length() == 8) {
            int alpha = Integer.valueOf(hexCode.substring(0, 2), 16);
            int red = Integer.valueOf(hexCode.substring(2, 4), 16);
            int green = Integer.valueOf(hexCode.substring(4, 6), 16);
            int blue = Integer.valueOf(hexCode.substring(6, 8), 16);
            return new TintColor(alpha, red, green, blue);
        }
        throw new IllegalArgumentException("Hexcode " + original + " is not valid. Must be in RRGGBB or AARRGGBB format.");
    }
}

