/*
 * Decompiled with CFR 0.152.
 */
package eu.magkari.mc.stewdetective.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import eu.magkari.mc.stewdetective.StewDetective;
import eu.magkari.mc.stewdetective.config.ConfigData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path path;
    private ConfigData data;

    public Config(Path path) {
        this.path = path;
    }

    public void load() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.saveConfig(true);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            this.data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            if (this.data == null) {
                StewDetective.LOGGER.warn("Config file was empty or malformed. Using default settings.");
                this.data = new ConfigData(true);
                this.save();
            }
        }
        catch (JsonIOException | JsonSyntaxException e) {
            StewDetective.LOGGER.warn("Invalid config JSON, using default settings.", e);
            this.data = new ConfigData(true);
            this.save();
        }
        catch (IOException e) {
            StewDetective.LOGGER.error("Failed to read or create config file", (Throwable)e);
            this.data = new ConfigData(true);
        }
    }

    public void saveConfig(boolean heldItemInfoIntegration) {
        this.data = new ConfigData(heldItemInfoIntegration);
        this.save();
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            GSON.toJson((Object)this.data, (Appendable)writer);
            StewDetective.LOGGER.info("Saved config at {}", (Object)this.path);
        }
        catch (IOException e) {
            StewDetective.LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.data != null && this.data.heldItemInfoIntegration;
    }

    public void setEnabled(boolean heldItemInfoIntegration) {
        this.data.heldItemInfoIntegration = heldItemInfoIntegration;
        this.save();
    }
}

