/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.changelist;

import java.util.List;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Anchor;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerImpl;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Composition;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.CompositionContext;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.IntStack;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.MovableContentState;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.MovableContentStateReference;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.RememberObserver;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotReader;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTable;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Stack;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.changelist.ChangeList;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.changelist.FixupList;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.internal.IntRef;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class ComposerChangeListWriter {
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    public final ComposerImpl composer;
    public ChangeList changeList;
    public boolean startedGroup;
    public final IntStack startedGroups;
    public boolean implicitRootStart;
    public int writersReaderDelta;
    public int pendingUps;
    public Stack pendingDownNodes;
    public int removeFrom;
    public int moveFrom;
    public int moveTo;
    public int moveCount;

    public ComposerChangeListWriter(ComposerImpl composerImpl, ChangeList changeList) {
        Stack stack;
        IntStack intStack;
        Intrinsics.checkNotNullParameter(composerImpl, "composer");
        Intrinsics.checkNotNullParameter(changeList, "changeList");
        ((ComposerChangeListWriter)object).composer = composerImpl;
        ((ComposerChangeListWriter)object).changeList = changeList;
        Object object = intStack;
        intStack = new IntStack();
        v1.startedGroups = object;
        v1.implicitRootStart = true;
        object = stack;
        stack = new Stack();
        v1.pendingDownNodes = object;
        v1.removeFrom = -1;
        v1.moveFrom = -1;
        v1.moveTo = -1;
    }

    public static /* synthetic */ void pushSlotTableOperationPreamble$default(ComposerChangeListWriter composerChangeListWriter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        composerChangeListWriter.pushSlotTableOperationPreamble(bl);
    }

    public static /* synthetic */ void realizeOperationLocation$default(ComposerChangeListWriter composerChangeListWriter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        composerChangeListWriter.realizeOperationLocation(bl);
    }

    public final SlotReader getReader() {
        return this.composer.getReader$runtime();
    }

    public final void pushApplierOperationPreamble() {
        this.pushPendingUpsAndDowns();
    }

    public final void pushSlotEditingOperationPreamble() {
        ComposerChangeListWriter composerChangeListWriter = this;
        ComposerChangeListWriter.realizeOperationLocation$default(composerChangeListWriter, false, 1, null);
        composerChangeListWriter.recordSlotEditing();
    }

    public final void pushSlotTableOperationPreamble(boolean bl) {
        this.realizeOperationLocation(bl);
    }

    public final void ensureRootStarted() {
        if (!this.startedGroup && this.implicitRootStart) {
            ComposerChangeListWriter composerChangeListWriter = this;
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter, false, 1, null);
            composerChangeListWriter.changeList.pushEnsureRootStarted();
            composerChangeListWriter.startedGroup = true;
        }
    }

    public final void ensureGroupStarted(Anchor anchor) {
        ComposerChangeListWriter composerChangeListWriter = this;
        ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter, false, 1, null);
        composerChangeListWriter.changeList.pushEnsureGroupStarted(anchor);
        composerChangeListWriter.startedGroup = true;
    }

    public final void realizeOperationLocation(boolean bl) {
        int n = (bl = bl ? this.getReader().getParent() : this.getReader().getCurrentGroup()) - this.writersReaderDelta;
        if (!(n >= 0)) {
            ComposerKt.composeImmediateRuntimeError("Tried to seek backward");
        }
        if (n > 0) {
            this.changeList.pushAdvanceSlotsBy(n);
            this.writersReaderDelta = bl ? 1 : 0;
        }
    }

    public final void realizeNodeMovementOperations() {
        int n = this.moveCount;
        if (n > 0) {
            int n2 = this.removeFrom;
            if (n2 >= 0) {
                this.realizeRemoveNode(n2, n);
                this.removeFrom = -1;
            } else {
                ComposerChangeListWriter composerChangeListWriter = this;
                n2 = composerChangeListWriter.moveTo;
                composerChangeListWriter.realizeMoveNode(n2, composerChangeListWriter.moveFrom, n);
                composerChangeListWriter.moveFrom = -1;
                composerChangeListWriter.moveTo = -1;
            }
            this.moveCount = 0;
        }
    }

    public final void realizeRemoveNode(int n, int n2) {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushApplierOperationPreamble();
        composerChangeListWriter.changeList.pushRemoveNode(n, n2);
    }

    public final void realizeMoveNode(int n, int n2, int n3) {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushApplierOperationPreamble();
        composerChangeListWriter.changeList.pushMoveNode(n, n2, n3);
    }

    public final void pushPendingUpsAndDowns() {
        int n = this.pendingUps;
        if (n > 0) {
            this.changeList.pushUps(n);
            this.pendingUps = 0;
        }
        if (this.pendingDownNodes.isNotEmpty()) {
            ComposerChangeListWriter composerChangeListWriter = this;
            composerChangeListWriter.changeList.pushDowns(this.pendingDownNodes.toArray());
            composerChangeListWriter.pendingDownNodes.clear();
        }
    }

    public final ChangeList getChangeList() {
        return this.changeList;
    }

    public final void setChangeList(ChangeList changeList) {
        Intrinsics.checkNotNullParameter(changeList, "<set-?>");
        this.changeList = changeList;
    }

    public final boolean getImplicitRootStart() {
        return this.implicitRootStart;
    }

    public final void setImplicitRootStart(boolean bl) {
        this.implicitRootStart = bl;
    }

    public final void moveReaderRelativeTo(int n) {
        this.writersReaderDelta += n - this.getReader().getCurrentGroup();
    }

    public final void moveReaderToAbsolute(int n) {
        this.writersReaderDelta = n;
    }

    public final void recordSlotEditing() {
        if (this.getReader().getSize() > 0) {
            ComposerChangeListWriter composerChangeListWriter = this;
            SlotReader slotReader = composerChangeListWriter.getReader();
            int n = slotReader.getParent();
            if (composerChangeListWriter.startedGroups.peekOr(-2) != n) {
                this.ensureRootStarted();
                if (n > 0) {
                    Anchor anchor = slotReader.anchor(n);
                    this.startedGroups.push(n);
                    this.ensureGroupStarted(anchor);
                }
            }
        }
    }

    public final boolean getPastParent() {
        return this.getReader().getParent() - this.writersReaderDelta < 0;
    }

    public final void remember(RememberObserver rememberObserver) {
        Intrinsics.checkNotNullParameter(rememberObserver, "value");
        this.changeList.pushRemember(rememberObserver);
    }

    public final void updateValue(Object object, int n) {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushSlotTableOperationPreamble(true);
        composerChangeListWriter.changeList.pushUpdateValue(object, n);
    }

    public final void updateAnchoredValue(Object object, Anchor anchor, int n) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.changeList.pushUpdateAnchoredValue(object, anchor, n);
    }

    public final void appendValue(Anchor anchor, Object object) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.changeList.pushAppendValue(anchor, object);
    }

    public final void trimValues(int n) {
        if (n > 0) {
            ComposerChangeListWriter composerChangeListWriter = this;
            composerChangeListWriter.pushSlotEditingOperationPreamble();
            composerChangeListWriter.changeList.pushTrimValues(n);
        }
    }

    public final void resetSlots() {
        this.changeList.pushResetSlots();
    }

    public final void updateAuxData(Object object) {
        ComposerChangeListWriter composerChangeListWriter = this;
        ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter, false, 1, null);
        composerChangeListWriter.changeList.pushUpdateAuxData(object);
    }

    public final void endRoot() {
        if (this.startedGroup) {
            ComposerChangeListWriter composerChangeListWriter = this;
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter, false, 1, null);
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter, false, 1, null);
            composerChangeListWriter.changeList.pushEndCurrentGroup();
            composerChangeListWriter.startedGroup = false;
        }
    }

    public final void endCurrentGroup() {
        ComposerChangeListWriter composerChangeListWriter = this;
        int n = composerChangeListWriter.getReader().getParent();
        if (!(composerChangeListWriter.startedGroups.peekOr(-1) <= n)) {
            ComposerKt.composeImmediateRuntimeError("Missed recording an endGroup");
        }
        if (this.startedGroups.peekOr(-1) == n) {
            ComposerChangeListWriter composerChangeListWriter2 = this;
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(composerChangeListWriter2, false, 1, null);
            composerChangeListWriter2.startedGroups.pop();
            composerChangeListWriter2.changeList.pushEndCurrentGroup();
        }
    }

    public final void skipToEndOfCurrentGroup() {
        this.changeList.pushSkipToEndOfCurrentGroup();
    }

    public final void removeCurrentGroup() {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushSlotEditingOperationPreamble();
        composerChangeListWriter.changeList.pushRemoveCurrentGroup();
        composerChangeListWriter.writersReaderDelta += this.getReader().getGroupSize();
    }

    public final void insertSlots(Anchor anchor, SlotTable slotTable) {
        ComposerChangeListWriter composerChangeListWriter = this;
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        Intrinsics.checkNotNullParameter(slotTable, "from");
        composerChangeListWriter.pushPendingUpsAndDowns();
        composerChangeListWriter.pushSlotEditingOperationPreamble();
        composerChangeListWriter.realizeNodeMovementOperations();
        composerChangeListWriter.changeList.pushInsertSlots(anchor, slotTable);
    }

    public final void insertSlots(Anchor anchor, SlotTable slotTable, FixupList fixupList) {
        ComposerChangeListWriter composerChangeListWriter = this;
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        Intrinsics.checkNotNullParameter(slotTable, "from");
        Intrinsics.checkNotNullParameter(fixupList, "fixups");
        composerChangeListWriter.pushPendingUpsAndDowns();
        composerChangeListWriter.pushSlotEditingOperationPreamble();
        composerChangeListWriter.realizeNodeMovementOperations();
        composerChangeListWriter.changeList.pushInsertSlots(anchor, slotTable, fixupList);
    }

    public final void moveCurrentGroup(int n) {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushSlotEditingOperationPreamble();
        composerChangeListWriter.changeList.pushMoveCurrentGroup(n);
    }

    public final void endCompositionScope(Function1 function1, Composition composition) {
        Intrinsics.checkNotNullParameter(function1, "action");
        Intrinsics.checkNotNullParameter(composition, "composition");
        this.changeList.pushEndCompositionScope(function1, composition);
    }

    public final void updateNode(Object object, Function2 function2) {
        ComposerChangeListWriter composerChangeListWriter = this;
        Intrinsics.checkNotNullParameter(function2, "block");
        composerChangeListWriter.pushApplierOperationPreamble();
        composerChangeListWriter.changeList.pushUpdateNode(object, function2);
    }

    public final void removeNode(int n, int n2) {
        if (n2 > 0) {
            if (!(n >= 0)) {
                ComposerKt.composeImmediateRuntimeError("Invalid remove index " + n);
            }
            if (this.removeFrom == n) {
                this.moveCount += n2;
            } else {
                this.realizeNodeMovementOperations();
                this.removeFrom = n;
                this.moveCount = n2;
            }
        }
    }

    public final void moveNode(int n, int n2, int n3) {
        if (n3 > 0) {
            int n4 = this.moveCount;
            if (n4 > 0 && this.moveFrom == n - n4 && this.moveTo == n2 - n4) {
                this.moveCount = n4 + n3;
            } else {
                this.realizeNodeMovementOperations();
                this.moveFrom = n;
                this.moveTo = n2;
                this.moveCount = n3;
            }
        }
    }

    public final void releaseMovableContent() {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushPendingUpsAndDowns();
        if (composerChangeListWriter.startedGroup) {
            ComposerChangeListWriter composerChangeListWriter2 = this;
            composerChangeListWriter2.skipToEndOfCurrentGroup();
            composerChangeListWriter2.endRoot();
        }
    }

    public final void endNodeMovement() {
        this.realizeNodeMovementOperations();
    }

    public final void moveUp() {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.realizeNodeMovementOperations();
        if (composerChangeListWriter.pendingDownNodes.isNotEmpty()) {
            this.pendingDownNodes.pop();
        } else {
            ++this.pendingUps;
        }
    }

    public final void moveDown(Object object) {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.realizeNodeMovementOperations();
        composerChangeListWriter.pendingDownNodes.push(object);
    }

    public final void sideEffect(Function0 function0) {
        Intrinsics.checkNotNullParameter(function0, "effect");
        this.changeList.pushSideEffect(function0);
    }

    public final void determineMovableContentNodeIndex(IntRef intRef, Anchor anchor) {
        ComposerChangeListWriter composerChangeListWriter = this;
        Intrinsics.checkNotNullParameter(intRef, "effectiveNodeIndexOut");
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        composerChangeListWriter.pushPendingUpsAndDowns();
        composerChangeListWriter.changeList.pushDetermineMovableContentNodeIndex(intRef, anchor);
    }

    public final void copyNodesToNewAnchorLocation(List list, IntRef intRef) {
        Intrinsics.checkNotNullParameter(list, "nodes");
        Intrinsics.checkNotNullParameter(intRef, "effectiveNodeIndex");
        this.changeList.pushCopyNodesToNewAnchorLocation(list, intRef);
    }

    public final void copySlotTableToAnchorLocation(MovableContentState movableContentState, CompositionContext compositionContext, MovableContentStateReference movableContentStateReference, MovableContentStateReference movableContentStateReference2) {
        Intrinsics.checkNotNullParameter(compositionContext, "parentContext");
        Intrinsics.checkNotNullParameter(movableContentStateReference, "from");
        Intrinsics.checkNotNullParameter(movableContentStateReference2, "to");
        this.changeList.pushCopySlotTableToAnchorLocation(movableContentState, compositionContext, movableContentStateReference, movableContentStateReference2);
    }

    public final void endMovableContentPlacement() {
        this.changeList.pushEndMovableContentPlacement();
        this.writersReaderDelta = 0;
    }

    public final void includeOperationsIn(ChangeList changeList, IntRef intRef) {
        Intrinsics.checkNotNullParameter(changeList, "other");
        this.changeList.pushExecuteOperationsIn(changeList, intRef);
    }

    public final void finalizeComposition() {
        ComposerChangeListWriter composerChangeListWriter = this;
        composerChangeListWriter.pushPendingUpsAndDowns();
        if (!composerChangeListWriter.startedGroups.isEmpty()) {
            ComposerKt.composeImmediateRuntimeError("Missed recording an endGroup()");
        }
    }

    public final void resetTransientState() {
        this.startedGroup = false;
        this.startedGroups.clear();
        this.writersReaderDelta = 0;
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

