/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Map;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__IndentKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.KSerializer;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.PrimitiveKind;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PlatformKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveSerialDescriptor;

public abstract class PrimitivesKt {
    public static final Map BUILTIN_SERIALIZERS = PlatformKt.initBuiltins();

    public static final SerialDescriptor PrimitiveDescriptorSafe(String string, PrimitiveKind primitiveKind) {
        Intrinsics.checkNotNullParameter(string, "serialName");
        Intrinsics.checkNotNullParameter(primitiveKind, "kind");
        PrimitivesKt.checkNameIsNotAPrimitive(string);
        return new PrimitiveSerialDescriptor(string, primitiveKind);
    }

    public static final void checkNameIsNotAPrimitive(String string) {
        Intrinsics.checkNotNullParameter(string, "serialName");
        for (KSerializer kSerializer : BUILTIN_SERIALIZERS.values()) {
            if (!Intrinsics.areEqual(string, kSerializer.getDescriptor().getSerialName())) continue;
            throw new IllegalArgumentException(StringsKt__IndentKt.trimIndent("\n                The name of serial descriptor should uniquely identify associated serializer.\n                For serial name " + string + " there already exists " + Reflection.getOrCreateKotlinClass(kSerializer.getClass()).getSimpleName() + ".\n                Please refer to SerialDescriptor documentation for additional information.\n            "));
        }
    }
}

