/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.platform.android;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.common.platform.Platform;
import top.fifthlight.touchcontroller.common.platform.android.Transport;
import top.fifthlight.touchcontroller.proxy.message.MessageDecodeException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory;

public final class AndroidPlatform
implements Platform {
    public final Logger logger;
    public final long handle;
    public final byte[] readBuffer;

    public AndroidPlatform(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        this.logger = LoggerFactory.getLogger(AndroidPlatform.class);
        this.handle = Transport.INSTANCE.new(string);
        this.readBuffer = new byte[128];
    }

    @Override
    public ProxyMessage pollEvent() {
        AndroidPlatform androidPlatform = object;
        long l = androidPlatform.handle;
        byte[] byArray = androidPlatform.readBuffer;
        Integer n = Transport.INSTANCE.receive(l, byArray);
        if (n <= 0) {
            n = null;
        }
        if (n != null) {
            Object object;
            int n2 = n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(((AndroidPlatform)object).readBuffer);
            ((Buffer)byteBuffer).limit(n2);
            if (byteBuffer.remaining() < 4) {
                return null;
            }
            try {
                Intrinsics.checkNotNull(byteBuffer);
                object = ProxyMessage.Companion.decode(byteBuffer.getInt(), byteBuffer);
            }
            catch (MessageDecodeException messageDecodeException) {
                ((AndroidPlatform)object).logger.warn("Bad message: " + messageDecodeException);
                object = null;
            }
            return object;
        }
        return null;
    }

    @Override
    public void sendEvent(ProxyMessage proxyMessage) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(proxyMessage, "message");
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(256);
        Intrinsics.checkNotNull(byteBuffer2);
        proxyMessage.encode(byteBuffer2);
        ((Buffer)byteBuffer).flip();
        ByteBuffer byteBuffer3 = byteBuffer;
        long l = this.handle;
        byte[] byArray = byteBuffer3.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        int n = byteBuffer3.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer3.remaining();
        Transport.INSTANCE.send(l, byArray, n, n2);
    }

    @Override
    public void resize(int n, int n2) {
        Platform.DefaultImpls.resize(this, n, n2);
    }
}

