/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageException;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.UInt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;

public final class CapabilityMessage
extends ProxyMessage {
    public final String capability;
    public final boolean enabled;
    public final int type;

    public CapabilityMessage(String string, boolean bl) {
        CapabilityMessage capabilityMessage = this;
        Intrinsics.checkNotNullParameter(string, "capability");
        super(null);
        this.capability = string;
        capabilityMessage.enabled = bl;
        capabilityMessage.type = 5;
        if (string.length() < 128) {
            return;
        }
        string = "Capability too long: " + string;
        throw new IllegalArgumentException(string.toString());
    }

    public final String getCapability() {
        return this.capability;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        CapabilityMessage capabilityMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        byteBuffer.put((byte)capabilityMessage.capability.length());
        byteBuffer.put(StringsKt__StringsJVMKt.encodeToByteArray(this.capability));
        if (this.enabled) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String toString() {
        return "CapabilityMessage(capability=" + this.capability + ", enabled=" + this.enabled + ')';
    }

    public int hashCode() {
        return this.capability.hashCode() * 31 + Boolean.hashCode(this.enabled);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CapabilityMessage)) {
            return false;
        }
        object = (CapabilityMessage)object;
        if (!Intrinsics.areEqual(this.capability, ((CapabilityMessage)object).capability)) {
            return false;
        }
        return this.enabled == ((CapabilityMessage)object).enabled;
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public CapabilityMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 2) {
                int n = UInt.constructor-impl(byteBuffer.get());
                if (n > 0) {
                    int n2 = n + 1;
                    if (byteBuffer.remaining() == n2) {
                        ByteBuffer byteBuffer3 = byteBuffer;
                        byte[] byArray = new byte[n];
                        byteBuffer3.get(byArray);
                        boolean bl = UInt.constructor-impl(byteBuffer3.get()) != 0;
                        return new CapabilityMessage(StringsKt__StringsJVMKt.decodeToString(byArray), bl);
                    }
                    throw new BadMessageLengthException(n2, byteBuffer.remaining());
                }
                throw new BadMessageException("Bad capability message: length " + n);
            }
            throw new BadMessageLengthException(2, byteBuffer.remaining());
        }
    }
}

