/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractList;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractMutableList;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt__ArraysJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;

public final class ArrayDeque
extends AbstractMutableList {
    public static final Companion Companion = new Companion(null);
    public static final Object[] emptyElementData = new Object[0];
    public int head;
    public Object[] elementData;
    public int size;

    public ArrayDeque() {
        this.elementData = emptyElementData;
    }

    public ArrayDeque(Collection objectArray) {
        ArrayDeque arrayDeque = this;
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        objectArray = objectArray.toArray(new Object[0]);
        arrayDeque.elementData = objectArray;
        arrayDeque.size = objectArray.length;
        if (objectArray.length == 0) {
            this.elementData = emptyElementData;
        }
    }

    public final void ensureCapacity(int n) {
        if (n >= 0) {
            Object[] objectArray = this.elementData;
            if (n <= this.elementData.length) {
                return;
            }
            if (objectArray == emptyElementData) {
                this.elementData = new Object[RangesKt___RangesKt.coerceAtLeast(n, 10)];
                return;
            }
            this.copyElements(AbstractList.Companion.newCapacity$kotlin_stdlib(objectArray.length, n));
            return;
        }
        throw new IllegalStateException("Deque is too big.");
    }

    public final void copyElements(int n) {
        ArrayDeque arrayDeque = this;
        Object[] objectArray = new Object[n];
        int n2 = this.head;
        int n3 = arrayDeque.elementData.length;
        ArraysKt___ArraysJvmKt.copyInto(arrayDeque.elementData, objectArray, 0, n2, n3);
        int n4 = this.head;
        ArraysKt___ArraysJvmKt.copyInto(arrayDeque.elementData, objectArray, arrayDeque.elementData.length - n4, 0, n4);
        arrayDeque.head = 0;
        arrayDeque.elementData = objectArray;
    }

    public final int positiveMod(int n) {
        Object[] objectArray = objectArray.elementData;
        if (n >= objectArray.elementData.length) {
            n -= objectArray.length;
        }
        return n;
    }

    public final int negativeMod(int n) {
        if (n < 0) {
            n += this.elementData.length;
        }
        return n;
    }

    public final int incremented(int n) {
        return n == ArraysKt___ArraysKt.getLastIndex(this.elementData) ? 0 : n + 1;
    }

    public final int decremented(int n) {
        return n == 0 ? ArraysKt___ArraysKt.getLastIndex(this.elementData) : n - 1;
    }

    public final void copyCollectionElements(int n, Collection collection) {
        Iterator iterator2 = collection.iterator();
        int n2 = this.elementData.length;
        while (n < n2 && iterator2.hasNext()) {
            this.elementData[n] = iterator2.next();
            ++n;
        }
        n2 = this.head;
        for (n = 0; n < n2 && iterator2.hasNext(); ++n) {
            this.elementData[n] = iterator2.next();
        }
        this.size = this.size() + collection.size();
    }

    public final void removeRangeShiftPreceding(int n, int n2) {
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + (n - 1));
        n2 = arrayDeque.positiveMod(arrayDeque.head + (n2 - 1));
        while (n > 0) {
            int n4 = n;
            ArrayDeque arrayDeque2 = this;
            int n5 = n;
            n = n3 + 1;
            int n6 = Math.min(n5, Math.min(n, n2 + 1));
            int n7 = n3;
            n3 = (n2 -= n6) + 1;
            int n8 = n7 - n6;
            ArraysKt___ArraysJvmKt.copyInto(arrayDeque2.elementData, arrayDeque2.elementData, n3, n8 + 1, n);
            n3 = arrayDeque2.negativeMod(n8);
            n2 = arrayDeque2.negativeMod(n2);
            n = n4 - n6;
        }
    }

    public final void removeRangeShiftSucceeding(int n, int n2) {
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + n2);
        n = arrayDeque.positiveMod(arrayDeque.head + n);
        n2 = arrayDeque.size() - n2;
        while (n2 > 0) {
            int n4 = n2;
            ArrayDeque arrayDeque2 = this;
            Object[] objectArray = this.elementData;
            n2 = Math.min(n2, Math.min(this.elementData.length - n3, objectArray.length - n));
            int n5 = n3 + n2;
            ArraysKt___ArraysJvmKt.copyInto(arrayDeque2.elementData, arrayDeque2.elementData, n, n3, n5);
            n3 = arrayDeque2.positiveMod(n5);
            n = this.positiveMod(n + n2);
            n2 = n4 - n2;
        }
    }

    public final void nullifyNonEmpty(int n, int n2) {
        if (n < n2) {
            ArraysKt___ArraysJvmKt.fill(this.elementData, null, n, n2);
        } else {
            ArrayDeque arrayDeque = this;
            int n3 = arrayDeque.elementData.length;
            ArraysKt___ArraysJvmKt.fill(arrayDeque.elementData, null, n, n3);
            ArraysKt___ArraysJvmKt.fill(arrayDeque.elementData, null, 0, n2);
        }
    }

    public final void registerModification() {
        ++this.modCount;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final Object firstOrNull() {
        return this.isEmpty() ? null : this.elementData[this.head];
    }

    @Override
    public final void addFirst(Object object) {
        int n;
        ArrayDeque arrayDeque = this;
        arrayDeque.registerModification();
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        arrayDeque.head = n = arrayDeque.decremented(arrayDeque.head);
        arrayDeque.elementData[n] = object;
        arrayDeque.size = arrayDeque.size() + 1;
    }

    @Override
    public final void addLast(Object object) {
        ArrayDeque arrayDeque = this;
        arrayDeque.registerModification();
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        ArrayDeque arrayDeque2 = this;
        arrayDeque.elementData[arrayDeque2.positiveMod((int)(arrayDeque2.head + this.size()))] = object;
        arrayDeque.size = arrayDeque.size() + 1;
    }

    @Override
    public final Object removeFirst() {
        if (!this.isEmpty()) {
            ArrayDeque arrayDeque = this;
            arrayDeque.registerModification();
            Object[] objectArray = arrayDeque.elementData;
            int n = this.head;
            ArrayDeque arrayDeque2 = this;
            objectArray[n] = null;
            arrayDeque2.head = arrayDeque2.incremented(n);
            arrayDeque2.size = arrayDeque2.size() - 1;
            return arrayDeque.elementData[n];
        }
        throw new NoSuchElementException("ArrayDeque is empty.");
    }

    public final Object removeFirstOrNull() {
        return this.isEmpty() ? null : this.removeFirst();
    }

    @Override
    public final Object removeLast() {
        if (!this.isEmpty()) {
            ArrayDeque arrayDeque = this;
            arrayDeque.registerModification();
            int n = arrayDeque.positiveMod(arrayDeque.head + CollectionsKt__CollectionsKt.getLastIndex(this));
            Object[] objectArray = arrayDeque.elementData;
            objectArray[n] = null;
            this.size = this.size() - 1;
            return arrayDeque.elementData[n];
        }
        throw new NoSuchElementException("ArrayDeque is empty.");
    }

    public final Object removeLastOrNull() {
        return this.isEmpty() ? null : this.removeLast();
    }

    @Override
    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public void add(int n, Object object) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.size());
        if (n == this.size()) {
            this.addLast(object);
            return;
        }
        if (n == 0) {
            this.addFirst(object);
            return;
        }
        int n2 = n;
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        n = this.positiveMod(this.head + n);
        if (n2 < this.size() + 1 >> 1) {
            n = this.decremented(n);
            int n3 = this.decremented(this.head);
            int n4 = this.head;
            if (n >= n4) {
                Object[] objectArray = this.elementData;
                Object[] objectArray2 = objectArray;
                objectArray[n3] = this.elementData[n4];
                int n5 = n4 + 1;
                int n6 = n + 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray2, n4, n5, n6);
            } else {
                int n7 = n4 - 1;
                int n8 = this.elementData.length;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n7, n4, n8);
                Object[] objectArray = this.elementData;
                n4 = objectArray.length - 1;
                objectArray[n4] = objectArray[0];
                n4 = n + 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, 0, 1, n4);
            }
            this.elementData[n] = object;
            this.head = n3;
        } else {
            int n9 = this.positiveMod(this.head + this.size());
            if (n < n9) {
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n + 1, n, n9);
            } else {
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, 1, 0, n9);
                Object[] objectArray = this.elementData;
                objectArray[0] = this.elementData[objectArray.length - 1];
                n9 = n + 1;
                int n10 = this.elementData.length - 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, n9, n, n10);
            }
            this.elementData[n] = object;
        }
        this.size = this.size() + 1;
    }

    @Override
    public boolean addAll(Collection collection) {
        Collection collection2 = collection;
        Intrinsics.checkNotNullParameter(collection2, "elements");
        if (collection2.isEmpty()) {
            return false;
        }
        ArrayDeque arrayDeque = this;
        arrayDeque.registerModification();
        arrayDeque.ensureCapacity(arrayDeque.size() + collection.size());
        arrayDeque.copyCollectionElements(arrayDeque.positiveMod(arrayDeque.head + this.size()), collection);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        Collection collection2 = collection;
        Intrinsics.checkNotNullParameter(collection2, "elements");
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.size());
        if (collection2.isEmpty()) {
            return false;
        }
        if (n == this.size()) {
            return this.addAll(collection);
        }
        int n2 = n;
        this.registerModification();
        this.ensureCapacity(this.size() + collection.size());
        int n3 = this.positiveMod(this.head + this.size());
        n = this.positiveMod(this.head + n);
        int n4 = collection.size();
        if (n2 < this.size() + 1 >> 1) {
            n3 = this.head;
            int n5 = n3 - n4;
            if (n >= n3) {
                if (n5 >= 0) {
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n5, n3, n);
                } else {
                    Object[] objectArray = this.elementData;
                    int n6 = n5 + this.elementData.length;
                    int n7 = objectArray.length - n6;
                    int n8 = n - n3;
                    if (n7 >= n8) {
                        ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n6, n3, n);
                    } else {
                        int n9 = n3 + n7;
                        ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n6, n3, n9);
                        ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, 0, this.head + n7, n);
                    }
                    n5 = n6;
                }
            } else {
                Object[] objectArray = this.elementData;
                int n10 = objectArray.length;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, n5, n3, n10);
                if (n4 >= n) {
                    Object[] objectArray2 = this.elementData;
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray2, objectArray2.length - n4, 0, n);
                } else {
                    Object[] objectArray3 = this.elementData;
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray3, objectArray3.length - n4, 0, n4);
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, 0, n4, n);
                }
            }
            this.head = n5;
            this.copyCollectionElements(this.negativeMod(n - n4), collection);
        } else {
            int n11 = n;
            int n12 = n11 + n4;
            if (n11 < n3) {
                n4 = n3 + n4;
                Object[] objectArray = this.elementData;
                if (n4 <= this.elementData.length) {
                    ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n12, n, n3);
                } else if (n12 >= objectArray.length) {
                    ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n12 - objectArray.length, n, n3);
                } else {
                    n4 = n3 - (n4 - objectArray.length);
                    ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, 0, n4, n3);
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n12, n, n4);
                }
            } else {
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n4, 0, n3);
                Object[] objectArray = this.elementData;
                if (n12 >= this.elementData.length) {
                    int n13 = n12 - objectArray.length;
                    n4 = objectArray.length;
                    ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n13, n, n4);
                } else {
                    int n14 = objectArray.length - n4;
                    int n15 = objectArray.length;
                    ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, 0, n14, n15);
                    n14 = this.elementData.length - n4;
                    ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n12, n, n14);
                }
            }
            this.copyCollectionElements(n, collection);
        }
        return true;
    }

    public Object get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        ArrayDeque arrayDeque = this;
        return this.elementData[arrayDeque.positiveMod(arrayDeque.head + n)];
    }

    public Object set(int n, Object object) {
        ArrayDeque arrayDeque = this;
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        int n2 = arrayDeque.positiveMod(arrayDeque.head + n);
        Object[] objectArray = arrayDeque.elementData;
        objectArray[n2] = object;
        return arrayDeque.elementData[n2];
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int indexOf(Object object) {
        block6: {
            int n;
            int n2;
            block5: {
                ArrayDeque arrayDeque = this;
                n2 = arrayDeque.head;
                n = arrayDeque.positiveMod(arrayDeque.head + this.size());
                if (n2 >= n) break block5;
                while (n2 < n) {
                    if (Intrinsics.areEqual(object, this.elementData[n2])) {
                        return n2 - this.head;
                    }
                    ++n2;
                }
                break block6;
            }
            if (n2 < n) break block6;
            int n3 = this.elementData.length;
            while (n2 < n3) {
                if (Intrinsics.areEqual(object, this.elementData[n2])) {
                    return n2 - this.head;
                }
                ++n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!Intrinsics.areEqual(object, this.elementData[n2])) continue;
                return n2 + this.elementData.length - this.head;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.head;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (n < n2) {
            if (n <= --n2) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n2])) {
                        return n2 - this.head;
                    }
                    if (n2 != n) {
                        --n2;
                        continue;
                    }
                    break;
                }
            }
        } else if (n > n2) {
            --n2;
            while (-1 < n2) {
                if (Intrinsics.areEqual(object, this.elementData[n2])) {
                    return n2 + this.elementData.length - this.head;
                }
                --n2;
            }
            ArrayDeque arrayDeque2 = this;
            n = arrayDeque2.head;
            n2 = ArraysKt___ArraysKt.getLastIndex(arrayDeque2.elementData);
            if (n <= n2) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n2])) {
                        return n2 - this.head;
                    }
                    if (n2 == n) break;
                    --n2;
                }
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public Object removeAt(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        if (n == CollectionsKt__CollectionsKt.getLastIndex(this)) {
            return this.removeLast();
        }
        if (n == 0) {
            return this.removeFirst();
        }
        int n2 = n;
        this.registerModification();
        n = this.positiveMod(this.head + n);
        Object object = this.elementData[n];
        if (n2 < this.size() >> 1) {
            int n3 = this.head;
            if (n >= n3) {
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n3 + 1, n3, n);
            } else {
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, 1, 0, n);
                Object[] objectArray = this.elementData;
                objectArray[0] = this.elementData[objectArray.length - 1];
                n = this.head;
                n3 = n + 1;
                int n4 = this.elementData.length - 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, n3, n, n4);
            }
            n = this.head;
            this.elementData[n] = null;
            this.head = this.incremented(n);
        } else {
            int n5 = this.positiveMod(this.head + CollectionsKt__CollectionsKt.getLastIndex(this));
            if (n <= n5) {
                Object[] objectArray = this.elementData;
                int n6 = n + 1;
                int n7 = n5 + 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, n, n6, n7);
            } else {
                int n8 = n + 1;
                int n9 = this.elementData.length;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, this.elementData, n, n8, n9);
                Object[] objectArray = this.elementData;
                n = objectArray.length - 1;
                objectArray[n] = objectArray[0];
                n = n5 + 1;
                ArraysKt___ArraysJvmKt.copyInto(this.elementData, objectArray, 0, 1, n);
            }
            this.elementData[n5] = null;
        }
        this.size = this.size() - 1;
        return object;
    }

    @Override
    public boolean removeAll(Collection collection) {
        int n;
        Intrinsics.checkNotNullParameter(collection, "elements");
        if (!this.isEmpty() && this.elementData.length != 0) {
            int n2;
            ArrayDeque arrayDeque = this;
            int n3 = arrayDeque.positiveMod(arrayDeque.head + this.size());
            int n4 = 0;
            if (n2 < n3) {
                n = n4;
                n4 = n2;
                for (n2 = (v251041).head; n2 < n3; ++n2) {
                    Object object = this.elementData[n2];
                    if (collection.contains(object) ^ true) {
                        this.elementData[n4++] = object;
                        continue;
                    }
                    n = 1;
                }
                ArraysKt___ArraysJvmKt.fill(this.elementData, null, n4, n3);
            } else {
                n = this.elementData.length;
                int n5 = n4;
                n4 = n2;
                while (n2 < n) {
                    Object object = this.elementData[n2];
                    this.elementData[n2] = null;
                    if (collection.contains(object) ^ true) {
                        this.elementData[n4++] = object;
                    } else {
                        n5 = 1;
                    }
                    ++n2;
                }
                n2 = this.positiveMod(n4);
                n = n5;
                for (n4 = 0; n4 < n3; ++n4) {
                    Object object = this.elementData[n4];
                    this.elementData[n4] = null;
                    if (collection.contains(object) ^ true) {
                        this.elementData[n2] = object;
                        n2 = this.incremented(n2);
                        continue;
                    }
                    n = 1;
                }
                n4 = n2;
            }
            if (n != 0) {
                ArrayDeque arrayDeque2 = this;
                arrayDeque2.registerModification();
                this.size = this.negativeMod(n4 - arrayDeque2.head);
            }
        } else {
            n = 0;
        }
        return n != 0;
    }

    @Override
    public boolean retainAll(Collection collection) {
        int n;
        Intrinsics.checkNotNullParameter(collection, "elements");
        if (!this.isEmpty() && this.elementData.length != 0) {
            int n2;
            ArrayDeque arrayDeque = this;
            int n3 = arrayDeque.positiveMod(arrayDeque.head + this.size());
            int n4 = 0;
            if (n2 < n3) {
                n = n4;
                n4 = n2;
                for (n2 = (v251173).head; n2 < n3; ++n2) {
                    Object object = this.elementData[n2];
                    if (collection.contains(object)) {
                        this.elementData[n4++] = object;
                        continue;
                    }
                    n = 1;
                }
                ArraysKt___ArraysJvmKt.fill(this.elementData, null, n4, n3);
            } else {
                n = this.elementData.length;
                int n5 = n4;
                n4 = n2;
                while (n2 < n) {
                    Object object = this.elementData[n2];
                    this.elementData[n2] = null;
                    if (collection.contains(object)) {
                        this.elementData[n4++] = object;
                    } else {
                        n5 = 1;
                    }
                    ++n2;
                }
                n2 = this.positiveMod(n4);
                n = n5;
                for (n4 = 0; n4 < n3; ++n4) {
                    Object object = this.elementData[n4];
                    this.elementData[n4] = null;
                    if (collection.contains(object)) {
                        this.elementData[n2] = object;
                        n2 = this.incremented(n2);
                        continue;
                    }
                    n = 1;
                }
                n4 = n2;
            }
            if (n != 0) {
                ArrayDeque arrayDeque2 = this;
                arrayDeque2.registerModification();
                this.size = this.negativeMod(n4 - arrayDeque2.head);
            }
        } else {
            n = 0;
        }
        return n != 0;
    }

    @Override
    public void clear() {
        if (this.isEmpty() ^ true) {
            ArrayDeque arrayDeque = this;
            arrayDeque.registerModification();
            int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
            arrayDeque.nullifyNonEmpty(arrayDeque.head, n);
        }
        ArrayDeque arrayDeque = this;
        arrayDeque.head = 0;
        arrayDeque.size = 0;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "array");
        if (objectArray.length < this.size()) {
            objectArray = ArraysKt__ArraysJVMKt.arrayOfNulls(objectArray, this.size());
        }
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int n2 = arrayDeque.head;
        if (n2 < n) {
            ArraysKt___ArraysJvmKt.copyInto$default(this.elementData, objectArray, 0, n2, n, 2, null);
        } else if (this.isEmpty() ^ true) {
            ArrayDeque arrayDeque2 = this;
            n2 = this.head;
            int n3 = arrayDeque2.elementData.length;
            ArraysKt___ArraysJvmKt.copyInto(arrayDeque2.elementData, objectArray, 0, n2, n3);
            ArraysKt___ArraysJvmKt.copyInto(arrayDeque2.elementData, objectArray, arrayDeque2.elementData.length - this.head, 0, n);
        }
        return CollectionsKt__CollectionsJVMKt.terminateCollectionToArray(this.size(), objectArray);
    }

    @Override
    public Object[] toArray() {
        ArrayDeque arrayDeque = this;
        return arrayDeque.toArray(new Object[arrayDeque.size()]);
    }

    @Override
    public void removeRange(int n, int n2) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this.size());
        int n3 = n2 - n;
        if (n3 == 0) {
            return;
        }
        if (n3 == this.size()) {
            this.clear();
            return;
        }
        if (n3 == 1) {
            this.remove(n);
            return;
        }
        ArrayDeque arrayDeque = this;
        arrayDeque.registerModification();
        if (n < arrayDeque.size() - n2) {
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.removeRangeShiftPreceding(n, n2);
            n = arrayDeque2.positiveMod(arrayDeque2.head + n3);
            arrayDeque2.nullifyNonEmpty(arrayDeque2.head, n);
            arrayDeque2.head = n;
        } else {
            ArrayDeque arrayDeque3 = this;
            arrayDeque3.removeRangeShiftSucceeding(n, n2);
            n = arrayDeque3.positiveMod(arrayDeque3.head + this.size());
            arrayDeque3.nullifyNonEmpty(arrayDeque3.negativeMod(n - n3), n);
        }
        this.size = this.size() - n3;
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

