/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import top.fifthlight.touchcontroller.relocated.org.joml.Math;
import top.fifthlight.touchcontroller.relocated.org.joml.Options;
import top.fifthlight.touchcontroller.relocated.org.joml.Runtime;

public class Vector3d
implements Externalizable,
Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3d rotateX(double d) {
        Vector3d vector3d = this;
        double d2 = Math.sin(d);
        d = Math.cosFromSin(d2, d);
        double d3 = vector3d.y;
        double d4 = d3;
        double d5 = d2;
        double d6 = d4 * d;
        d4 = this.z;
        d2 = d6 - d4 * d2;
        double d7 = d3 * d5 + d4 * d;
        vector3d.y = d2;
        vector3d.z = d7;
        return vector3d;
    }

    public Vector3d rotateY(double d) {
        Vector3d vector3d = this;
        double d2 = Math.sin(d);
        d = Math.cosFromSin(d2, d);
        double d3 = vector3d.x;
        double d4 = this.z;
        double d5 = -d3 * d2 + d4 * d;
        vector3d.x = d3 * d + d4 * d2;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector3d normalize() {
        Vector3d vector3d = this;
        double d = vector3d.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = Math.invsqrt(Math.fma(d, d, Math.fma(d2, d2, d3 * d3)));
        vector3d.x *= d4;
        vector3d.y *= d4;
        vector3d.z *= d4;
        return vector3d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
    }

    public void readExternal(ObjectInput objectInput) {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
    }

    public int hashCode() {
        long l;
        long l2 = Double.doubleToLongBits(this.x);
        long l3 = l = Double.doubleToLongBits(this.y);
        long l4 = l = Double.doubleToLongBits(this.z);
        return ((31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector3d)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(((Vector3d)object).x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(((Vector3d)object).y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(((Vector3d)object).z);
    }

    public Object clone() {
        return super.clone();
    }
}

