/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.config.ControllerLayout;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.config.LayerConditionKey;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetControlInfo;
import top.fifthlight.touchcontroller.common.event.RenderEvents$special$;
import top.fifthlight.touchcontroller.common.event.WindowEvents;
import top.fifthlight.touchcontroller.common.gal.CameraPerspective;
import top.fifthlight.touchcontroller.common.gal.CrosshairTarget;
import top.fifthlight.touchcontroller.common.gal.DefaultKeyBindingType;
import top.fifthlight.touchcontroller.common.gal.GameState;
import top.fifthlight.touchcontroller.common.gal.GameStateProvider;
import top.fifthlight.touchcontroller.common.gal.KeyBindingHandler;
import top.fifthlight.touchcontroller.common.gal.PlayerHandleFactory;
import top.fifthlight.touchcontroller.common.gal.RidingEntityType;
import top.fifthlight.touchcontroller.common.gal.ViewActionProvider;
import top.fifthlight.touchcontroller.common.gal.WindowHandle;
import top.fifthlight.touchcontroller.common.helper.OffsetHelperKt;
import top.fifthlight.touchcontroller.common.input.InputManager;
import top.fifthlight.touchcontroller.common.layout.Context;
import top.fifthlight.touchcontroller.common.layout.ContextInput;
import top.fifthlight.touchcontroller.common.layout.ContextResult;
import top.fifthlight.touchcontroller.common.layout.ContextStatus;
import top.fifthlight.touchcontroller.common.layout.ContextTimer;
import top.fifthlight.touchcontroller.common.layout.DrawQueue;
import top.fifthlight.touchcontroller.common.layout.HudKt;
import top.fifthlight.touchcontroller.common.layout.InventorySlotStatus;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.common.model.TouchStateModel;
import top.fifthlight.touchcontroller.common.platform.PlatformProvider;
import top.fifthlight.touchcontroller.proxy.client.PlatformCapability;
import top.fifthlight.touchcontroller.proxy.message.AddPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.CapabilityMessage;
import top.fifthlight.touchcontroller.proxy.message.ClearPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.InputStatusMessage;
import top.fifthlight.touchcontroller.proxy.message.MoveViewMessage;
import top.fifthlight.touchcontroller.proxy.message.RemovePointerMessage;
import top.fifthlight.touchcontroller.proxy.message.VibrateMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.Uuid;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.ExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentMap;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentSet;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextInputState;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextRange;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.Canvas;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntOffset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntSize;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Offset;

public final class RenderEvents
implements KoinComponent {
    public static final RenderEvents INSTANCE;
    public static final Logger logger;
    public static final Lazy window$delegate;
    public static final Lazy configHolder$delegate;
    public static final Lazy controllerHudModel$delegate;
    public static final Lazy touchStateModel$delegate;
    public static final Lazy playerHandleFactory$delegate;
    public static final Lazy platformProvider$delegate;
    public static final Lazy gameStateProvider$delegate;
    public static final Lazy keyBindingHandler$delegate;
    public static final Lazy viewActionProvider$delegate;
    public static int prevWidth;
    public static int prevHeight;
    public static final Set _platformCapabilities;
    public static final Set platformCapabilities;
    public static final int $stable;

    private final ControllerHudModel getControllerHudModel() {
        return (ControllerHudModel)controllerHudModel$delegate.getValue();
    }

    private final PlatformProvider getPlatformProvider() {
        return (PlatformProvider)platformProvider$delegate.getValue();
    }

    private final KeyBindingHandler getKeyBindingHandler() {
        return (KeyBindingHandler)keyBindingHandler$delegate.getValue();
    }

    public static final void onRenderStart() {
        ContextInput contextInput;
        DrawQueue drawQueue;
        Object object;
        Object object2;
        Object object3;
        Object object4 = INSTANCE;
        ((RenderEvents)object4).getControllerHudModel().getTimer().renderTick();
        ((RenderEvents)object4).getKeyBindingHandler().renderTick(((RenderEvents)object4).getControllerHudModel().getTimer().getRenderTick());
        if (((RenderEvents)object4).getControllerHudModel().getStatus().getVibrate()) {
            object3 = ((RenderEvents)object4).getPlatformProvider().getPlatform();
            if (object3 != null) {
                object3.sendEvent(new VibrateMessage(VibrateMessage.Kind.BLOCK_BROKEN));
            }
            ((RenderEvents)object4).getControllerHudModel().getStatus().setVibrate(false);
        }
        RenderEvents renderEvents = object4;
        object4 = (GlobalConfig)renderEvents.getConfigHolder().getConfig().getValue();
        object3 = renderEvents.getPlayerHandleFactory().getPlayerHandle();
        GameState gameState = renderEvents.getGameStateProvider().currentState();
        Object object5 = renderEvents.getPlatformProvider().getPlatform();
        if (object5 != null) {
            while (true) {
                WindowEvents windowEvents = WindowEvents.INSTANCE;
                int n = windowEvents.getWindowWidth();
                int n2 = windowEvents.getWindowHeight();
                if (n != prevWidth || n2 != prevHeight) {
                    prevWidth = n;
                    prevHeight = n2;
                    object5.resize(n, n2);
                }
                if ((object2 = object5.pollEvent()) == null) break;
                if (object2 instanceof AddPointerMessage) {
                    AddPointerMessage addPointerMessage = (AddPointerMessage)object2;
                    int n3 = addPointerMessage.getIndex();
                    float f = addPointerMessage.getX();
                    float f2 = addPointerMessage.getY();
                    long l = Float.floatToRawIntBits(f2);
                    INSTANCE.getTouchStateModel().addPointer-_0sKWyo(n3, Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL));
                    continue;
                }
                if (object2 instanceof RemovePointerMessage) {
                    INSTANCE.getTouchStateModel().removePointer(((RemovePointerMessage)object2).getIndex());
                    continue;
                }
                if (Intrinsics.areEqual(object2, ClearPointerMessage.INSTANCE)) {
                    INSTANCE.getTouchStateModel().clearPointer();
                    continue;
                }
                if (object2 instanceof CapabilityMessage) {
                    Object var6_31;
                    block29: {
                        for (Object t : PlatformCapability.getEntries()) {
                            var6_31 = t;
                            if (!Intrinsics.areEqual(((PlatformCapability)((Object)t)).getId(), ((CapabilityMessage)object2).getCapability())) continue;
                            break block29;
                        }
                        var6_31 = null;
                    }
                    Object object6 = var6_31;
                    if (object6 != null) {
                        object2 = (CapabilityMessage)object2;
                        logger.info("TouchController capability " + ((CapabilityMessage)object2).getCapability() + " set to " + ((CapabilityMessage)object2).getEnabled());
                        if (((CapabilityMessage)object2).getEnabled()) {
                            ((Collection)_platformCapabilities).add(object6);
                            continue;
                        }
                        ((Collection)_platformCapabilities).remove(object6);
                        continue;
                    }
                    logger.warn("Unknown capability: " + ((CapabilityMessage)object2).getCapability() + ", maybe you should update TouchController?");
                    continue;
                }
                if (object2 instanceof InputStatusMessage) {
                    TextRange textRange;
                    TextRange textRange2;
                    if ((object2 = ((InputStatusMessage)object2).getStatus()) == null) continue;
                    Object object7 = object2;
                    String string = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object7).getText();
                    TextRange textRange3 = textRange2;
                    textRange2 = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getComposition().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getComposition().getLength());
                    object = textRange;
                    textRange = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getSelection().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getSelection().getLength());
                    boolean bl = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object7).getSelectionLeft();
                    InputManager.INSTANCE.updateNativeState(new TextInputState(string, textRange3, (TextRange)object, bl));
                    continue;
                }
                if (!(object2 instanceof MoveViewMessage) || object3 == null) continue;
                MoveViewMessage moveViewMessage = (MoveViewMessage)object2;
                float f = moveViewMessage.getDeltaYaw();
                float f3 = moveViewMessage.getDeltaPitch();
                long l = Float.floatToRawIntBits(f3);
                l = Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL);
                if (moveViewMessage.getScreenBased()) {
                    l = Offset.times-oOeltVE(OffsetHelperKt.fixAspectRadio-5vxnuq4(l, INSTANCE.getWindow().getSize-KlICH20()), ((GlobalConfig)object4).getControl().getViewMovementSensitivity());
                }
                long l2 = l;
                double d = Offset.getX-impl(l2);
                double d2 = Offset.getY-impl(l2);
                object3.changeLookDirection(d, d2);
            }
        }
        if (((GlobalConfig)object4).getDebug().getEnableTouchEmulation()) {
            object4 = INSTANCE;
            object5 = ((RenderEvents)object4).getWindow().getMousePosition-sHUuaow();
            if (((RenderEvents)object4).getWindow().getMouseLeftPressed() && object5 != null) {
                long l = Offset.div-JopVrvY(((Offset)object5).unbox-impl(), IntSize.toSize-2DEOzdI(((RenderEvents)object4).getWindow().getSize-KlICH20()));
                ((RenderEvents)object4).getTouchStateModel().addPointer-_0sKWyo(0, l);
            } else {
                ((RenderEvents)object4).getTouchStateModel().clearPointer();
            }
        }
        if (!gameState.getInGame()) {
            return;
        }
        if (gameState.getInGui()) {
            INSTANCE.getTouchStateModel().clearPointer();
        }
        if (object3 == null) {
            return;
        }
        if (object3.isFlying() || object3.isSubmergedInWater()) {
            INSTANCE.getKeyBindingHandler().getState(DefaultKeyBindingType.SNEAK).clearLock();
        }
        object4 = INSTANCE;
        object5 = (LayoutPreset)((RenderEvents)object4).getConfigHolder().getCurrentPreset().getValue();
        object2 = (Uuid)((RenderEvents)object4).getConfigHolder().getCurrentPresetUuid().getValue();
        if (!Intrinsics.areEqual(((RenderEvents)object4).getControllerHudModel().getStatus().getPreviousPresetUuid(), object2)) {
            Iterator iterator2 = object4;
            super.getControllerHudModel().getStatus().setPreviousPresetUuid((Uuid)object2);
            super.getControllerHudModel().getStatus().getEnabledCustomConditions().clear();
        }
        object2 = object3.getRidingEntityType();
        Object object8 = MapsKt__MapsJVMKt.createMapBuilder();
        object8.put(LayerConditionKey.FLYING, object3.isFlying());
        object8.put(LayerConditionKey.CAN_FLY, object3.getCanFly());
        object8.put(LayerConditionKey.SWIMMING, object3.isTouchingWater());
        object8.put(LayerConditionKey.UNDERWATER, object3.isSubmergedInWater());
        object8.put(LayerConditionKey.SPRINTING, object3.isSprinting());
        object8.put(LayerConditionKey.SNEAKING, object3.isSneaking());
        object8.put(LayerConditionKey.ON_GROUND, object3.getOnGround());
        object8.put(LayerConditionKey.NOT_ON_GROUND, object3.getOnGround() ^ true);
        object8.put(LayerConditionKey.USING_ITEM, object3.isUsingItem());
        Object object9 = LayerConditionKey.RIDING;
        object = object2 != null;
        object8.put(object9, object);
        object9 = LayerConditionKey.BLOCK_SELECTED;
        object = ((RenderEvents)object4).getViewActionProvider().getCrosshairTarget() == CrosshairTarget.BLOCK;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_MINECART;
        object = object2 == RidingEntityType.MINECART;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_BOAT;
        object = object2 == RidingEntityType.BOAT;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_PIG;
        object = object2 == RidingEntityType.PIG;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_HORSE;
        object = object2 == RidingEntityType.HORSE;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_CAMEL;
        object = object2 == RidingEntityType.CAMEL;
        object8.put(object9, object);
        object9 = LayerConditionKey.ON_LLAMA;
        object = object2 == RidingEntityType.LLAMA;
        Object object10 = object2;
        object8.put(object9, object);
        object2 = LayerConditionKey.ON_STRIDER;
        object9 = object10 == RidingEntityType.STRIDER;
        Iterator iterator3 = object4;
        Map map2 = object8;
        map2.put(object2, object9);
        object2 = ExtensionsKt.toPersistentMap(MapsKt__MapsJVMKt.build(map2));
        object8 = drawQueue;
        drawQueue = new DrawQueue();
        long l = ((RenderEvents)((Object)iterator3)).getWindow().getSize-KlICH20();
        long l3 = ((RenderEvents)((Object)iterator3)).getWindow().getScaledSize-KlICH20();
        long l4 = ((RenderEvents)((Object)iterator3)).getWindow().getScaledSize-KlICH20();
        long l5 = IntOffset.Companion.getZERO-ITD3_cg();
        HashMap hashMap = ((RenderEvents)((Object)iterator3)).getTouchStateModel().getPointers();
        ContextInput contextInput2 = contextInput;
        boolean bl = gameState.getInGui();
        Object object11 = ExtensionsKt.toPersistentSet(super.getControllerHudModel().getStatus().getEnabledCustomConditions());
        Object object12 = gameState.getPerspective();
        contextInput = new ContextInput(bl, (PersistentMap)object2, (PersistentSet)object11, (CameraPerspective)((Object)object12));
        Object object13 = super.getControllerHudModel().getStatus();
        object2 = super.getControllerHudModel().getTimer();
        object11 = super.getKeyBindingHandler();
        object12 = (GlobalConfig)((RenderEvents)((Object)iterator3)).getConfigHolder().getConfig().getValue();
        PresetControlInfo presetControlInfo = ((LayoutPreset)object5).getControlInfo();
        Context context = new Context(l, l3, (DrawQueue)object8, l4, l5, 0.0f, hashMap, contextInput2, null, (ContextStatus)object13, (KeyBindingHandler)object11, (ContextTimer)object2, (GlobalConfig)object12, presetControlInfo, 288, null);
        HudKt.Hud(context, ControllerLayout.box-impl(((LayoutPreset)object5).getLayout-HWbCNyc()));
        object13 = context.getResult();
        Iterator iterator4 = object4;
        super.getControllerHudModel().setResult((ContextResult)object13);
        super.getControllerHudModel().setPendingDrawQueue((DrawQueue)object8);
        super.getControllerHudModel().getStatus().getDoubleClickCounter().clean(super.getControllerHudModel().getTimer().getClientTick());
        object4 = ((ContextResult)object13).getPendingAction().iterator();
        while (object4.hasNext()) {
            ((Function2)object4.next()).invoke(INSTANCE.getControllerHudModel().getTimer(), object3);
        }
        object4 = ((ContextResult)object13).getLookDirection-sHUuaow();
        if (object4 != null) {
            long l6 = ((Offset)object4).unbox-impl();
            float f = Offset.component1-impl(l6);
            double d = f;
            double d3 = Offset.component2-impl(l6);
            object3.changeLookDirection(d, d3);
        }
        InventorySlotStatus[] inventorySlotStatusArray = ((ContextResult)object13).getInventory().getSlots();
        int n = 0;
        for (InventorySlotStatus inventorySlotStatus : inventorySlotStatusArray) {
            int n4 = n + 1;
            if (inventorySlotStatus.getSelect()) {
                object3.setCurrentSelectedSlot(n);
            }
            if (inventorySlotStatus.getDrop()) {
                if (object3.getInventorySlot(n).isEmpty()) {
                    object3.setCurrentSelectedSlot(n);
                } else {
                    object3.dropSlot(n);
                }
            }
            n = n4;
        }
    }

    static {
        RenderEvents renderEvents;
        RenderEvents renderEvents2 = renderEvents;
        INSTANCE = new RenderEvents();
        logger = LoggerFactory.getLogger(RenderEvents.class);
        KoinPlatformTools koinPlatformTools = KoinPlatformTools.INSTANCE;
        window$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WindowHandle.class), qualifier, function0);
            }
        });
        configHolder$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$2 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GlobalConfigHolder.class), qualifier, function0);
            }
        });
        controllerHudModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$3 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ControllerHudModel.class), qualifier, function0);
            }
        });
        touchStateModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$4 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(TouchStateModel.class), qualifier, function0);
            }
        });
        playerHandleFactory$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$5 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlayerHandleFactory.class), qualifier, function0);
            }
        });
        platformProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$6 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlatformProvider.class), qualifier, function0);
            }
        });
        gameStateProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$7 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GameStateProvider.class), qualifier, function0);
            }
        });
        keyBindingHandler$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$8 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(KeyBindingHandler.class), qualifier, function0);
            }
        });
        viewActionProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$9 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ViewActionProvider.class), qualifier, function0);
            }
        });
        _platformCapabilities = new LinkedHashSet();
        Set set = Collections.unmodifiableSet(_platformCapabilities);
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        platformCapabilities = set;
        $stable = 8;
    }

    public final Set getPlatformCapabilities() {
        return platformCapabilities;
    }

    public final void onHudRender(Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        DrawQueue drawQueue = ((RenderEvents)((Object)drawQueue)).getControllerHudModel().getPendingDrawQueue();
        if (drawQueue != null) {
            drawQueue.execute(canvas);
            INSTANCE.getControllerHudModel().setPendingDrawQueue(null);
        }
    }

    public final boolean shouldRenderCrosshair() {
        RenderEvents renderEvents = this;
        GlobalConfig globalConfig = (GlobalConfig)renderEvents.getConfigHolder().getConfig().getValue();
        if (!((LayoutPreset)renderEvents.getConfigHolder().getCurrentPreset().getValue()).getControlInfo().getDisableCrosshair()) {
            return true;
        }
        if ((this = ((RenderEvents)this).getPlayerHandleFactory().getPlayerHandle()) == null) {
            return false;
        }
        return this.hasItemsOnHand(globalConfig.getItem().getShowCrosshairItems());
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final WindowHandle getWindow() {
        return (WindowHandle)window$delegate.getValue();
    }

    public final GlobalConfigHolder getConfigHolder() {
        return (GlobalConfigHolder)configHolder$delegate.getValue();
    }

    public final TouchStateModel getTouchStateModel() {
        return (TouchStateModel)touchStateModel$delegate.getValue();
    }

    public final PlayerHandleFactory getPlayerHandleFactory() {
        return (PlayerHandleFactory)playerHandleFactory$delegate.getValue();
    }

    public final GameStateProvider getGameStateProvider() {
        return (GameStateProvider)gameStateProvider$delegate.getValue();
    }

    public final ViewActionProvider getViewActionProvider() {
        return (ViewActionProvider)viewActionProvider$delegate.getValue();
    }
}

