/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.FloatRect;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class InputCursorMessage
extends ProxyMessage {
    public final FloatRect cursorRect;
    public final int type;

    public InputCursorMessage(FloatRect floatRect) {
        super(null);
        this.cursorRect = floatRect;
        this.type = 9;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        InputCursorMessage inputCursorMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        if (inputCursorMessage.cursorRect != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putFloat(this.cursorRect.getLeft());
            byteBuffer.putFloat(this.cursorRect.getTop());
            byteBuffer.putFloat(this.cursorRect.getWidth());
            byteBuffer.putFloat(this.cursorRect.getHeight());
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String toString() {
        return "InputCursorMessage(cursorRect=" + this.cursorRect + ')';
    }

    public int hashCode() {
        FloatRect floatRect = ((InputCursorMessage)((Object)floatRect)).cursorRect;
        return floatRect == null ? 0 : floatRect.hashCode();
    }

    public boolean equals(Object object) {
        if (inputCursorMessage2 == object) {
            return true;
        }
        if (!(object instanceof InputCursorMessage)) {
            return false;
        }
        InputCursorMessage inputCursorMessage = inputCursorMessage2;
        InputCursorMessage inputCursorMessage2 = (InputCursorMessage)object;
        return Intrinsics.areEqual(inputCursorMessage.cursorRect, inputCursorMessage2.cursorRect);
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public InputCursorMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 1) {
                if (byteBuffer.get() != 0) {
                    if (byteBuffer.remaining() == 16) {
                        FloatRect floatRect;
                        FloatRect floatRect2 = floatRect;
                        ByteBuffer byteBuffer3 = byteBuffer;
                        float f = byteBuffer3.getFloat();
                        float f2 = byteBuffer3.getFloat();
                        float f3 = byteBuffer3.getFloat();
                        float f4 = byteBuffer3.getFloat();
                        floatRect = new FloatRect(f, f2, f3, f4);
                        return new InputCursorMessage(floatRect2);
                    }
                    throw new BadMessageLengthException(16, byteBuffer.remaining());
                }
                return new InputCursorMessage(null);
            }
            throw new BadMessageLengthException(1, byteBuffer.remaining());
        }
    }
}

