/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.config;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.config.ConfigDirectoryProvider;
import top.fifthlight.touchcontroller.common.config.GameConfigEditor;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder$special$;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetConfig;
import top.fifthlight.touchcontroller.common.config.preset.PresetManager;
import top.fifthlight.touchcontroller.common.config.preset.PresetsContainer;
import top.fifthlight.touchcontroller.common.config.preset.builtin.BuiltInPresetKey;
import top.fifthlight.touchcontroller.common.config.widget.WidgetPresetManager;
import top.fifthlight.touchcontroller.common.ext.MapStateKt;
import top.fifthlight.touchcontroller.common.gal.DefaultItemListProvider;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.NoWhenBranchMatchedException;
import top.fifthlight.touchcontroller.relocated.kotlin.Result;
import top.fifthlight.touchcontroller.relocated.kotlin.ResultKt;
import top.fifthlight.touchcontroller.relocated.kotlin.io.path.PathsKt__PathReadWriteKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.flow.FlowKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.flow.MutableStateFlow;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.flow.StateFlow;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.flow.StateFlowKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.Json;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;

public final class GlobalConfigHolder
implements KoinComponent {
    public final Logger logger;
    public final Lazy gameConfigEditor$delegate;
    public final Lazy presetManager$delegate;
    public final Lazy widgetPresetManager$delegate;
    public final DefaultItemListProvider defaultItemListProvider;
    public final ConfigDirectoryProvider configDirectoryProvider;
    public final Path configDir;
    public final Path configFile;
    public final Lazy json$delegate;
    public final MutableStateFlow _config;
    public final StateFlow config;
    public final StateFlow currentPreset;

    public GlobalConfigHolder() {
        GlobalConfigHolder globalConfigHolder = this;
        globalConfigHolder.logger = LoggerFactory.getLogger(GlobalConfig.class);
        Object object = KoinPlatformTools.INSTANCE;
        globalConfigHolder.gameConfigEditor$delegate = LazyKt__LazyJVMKt.lazy(((KoinPlatformTools)object).defaultLazyMode(), new Function0(this, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GameConfigEditor.class), qualifier, function0);
            }
        });
        globalConfigHolder.presetManager$delegate = LazyKt__LazyJVMKt.lazy(((KoinPlatformTools)object).defaultLazyMode(), new Function0(this, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$2 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PresetManager.class), qualifier, function0);
            }
        });
        globalConfigHolder.widgetPresetManager$delegate = LazyKt__LazyJVMKt.lazy(((KoinPlatformTools)object).defaultLazyMode(), new Function0(this, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$3 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WidgetPresetManager.class), qualifier, function0);
            }
        });
        DefaultItemListProvider defaultItemListProvider = null;
        Qualifier qualifier = null;
        globalConfigHolder.defaultItemListProvider = defaultItemListProvider = (DefaultItemListProvider)globalConfigHolder.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(DefaultItemListProvider.class), (Qualifier)((Object)defaultItemListProvider), (Function0)((Object)qualifier));
        qualifier = null;
        Function0 function0 = null;
        this.configDirectoryProvider = (ConfigDirectoryProvider)globalConfigHolder.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ConfigDirectoryProvider.class), qualifier, function0);
        this.configDir = this.configDirectoryProvider.getConfigDirectory();
        globalConfigHolder.configFile = this.configDir.resolve("config.json");
        globalConfigHolder.json$delegate = LazyKt__LazyJVMKt.lazy(((KoinPlatformTools)object).defaultLazyMode(), new Function0(this, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$4 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Json.class), qualifier, function0);
            }
        });
        this._config = StateFlowKt.MutableStateFlow(GlobalConfig.Companion.default(defaultItemListProvider));
        this.config = object = FlowKt.asStateFlow(this._config);
        globalConfigHolder.currentPreset = MapStateKt.combineStates((StateFlow)object, this.getPresetManager().getPresets(), GlobalConfigHolder::currentPreset$lambda$0);
    }

    public static final LayoutPreset currentPreset$lambda$0(GlobalConfig object, PresetsContainer presetsContainer) {
        block6: {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(object, "config");
                    Intrinsics.checkNotNullParameter(presetsContainer, "presets");
                    object = ((GlobalConfig)object).getPreset();
                    if (!(object instanceof PresetConfig.BuiltIn)) break block4;
                    object = ((PresetConfig.BuiltIn)object).getKey().getPreset();
                    break block5;
                }
                if (!(object instanceof PresetConfig.Custom)) break block6;
                if ((object = (LayoutPreset)presetsContainer.get((Object)((PresetConfig.Custom)object).getUuid())) == null) {
                    object = BuiltInPresetKey.Companion.getDEFAULT().getPreset();
                }
            }
            return object;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final void createConfigDirectory$lambda$2(GameConfigEditor.Editor editor) {
        GameConfigEditor.Editor editor2 = editor;
        Intrinsics.checkNotNullParameter(editor2, "editor");
        editor2.setAutoJump(true);
    }

    public final StateFlow getConfig() {
        return this.config;
    }

    public final StateFlow getCurrentPreset() {
        return this.currentPreset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void load() {
        GlobalConfigHolder globalConfigHolder;
        GlobalConfigHolder globalConfigHolder2;
        try {
            GlobalConfigHolder globalConfigHolder3 = this;
            globalConfigHolder2 = globalConfigHolder3;
            globalConfigHolder = globalConfigHolder3;
            globalConfigHolder3.createConfigDirectory();
        }
        catch (Exception exception) {
            this.logger.warn("Failed to create config folder: ", (Throwable)exception);
            return;
        }
        globalConfigHolder.logger.info("Reading TouchController config file");
        MutableStateFlow mutableStateFlow = globalConfigHolder2._config;
        Json json = this.getJson();
        Json json2 = json;
        Path path = this.configFile;
        Intrinsics.checkNotNullExpressionValue(path, "configFile");
        String string = PathsKt__PathReadWriteKt.readText$default(path, null, 1, null);
        json.getSerializersModule();
        try {
            mutableStateFlow.setValue(json2.decodeFromString(GlobalConfig.Companion.serializer(), string));
        }
        catch (Exception exception) {
            GlobalConfigHolder globalConfigHolder4 = this;
            globalConfigHolder4.logger.warn("Failed to read config: ", (Throwable)exception);
            long l = System.currentTimeMillis();
            Path path2 = globalConfigHolder4.configFile.resolveSibling(this.configFile.getFileName() + "-backup-" + l);
            // empty try
            Path path3 = globalConfigHolder4.configFile;
            Path path4 = path2;
            Path path5 = path4;
            Intrinsics.checkNotNullExpressionValue(path3, "configFile");
            Intrinsics.checkNotNull(path4);
            int n = 1;
            CopyOption[] copyOptionArray = new CopyOption[1];
            try {
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Path path6 = Files.move(path3, path5, Arrays.copyOf(copyOptionArray, n));
                Intrinsics.checkNotNullExpressionValue(path6, "move(...)");
                Result.constructor-impl(path6);
            }
            catch (Throwable throwable) {
                Result.constructor-impl(ResultKt.createFailure(throwable));
            }
        }
        GlobalConfigHolder globalConfigHolder5 = this;
        globalConfigHolder5.getPresetManager().load();
        globalConfigHolder5.getWidgetPresetManager().load();
    }

    public final void updateConfig(Function1 object) {
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(object, "editor");
        MutableStateFlow mutableStateFlow = this._config;
        while (!mutableStateFlow.compareAndSet(object3 = mutableStateFlow.getValue(), object2 = object.invoke(object3))) {
        }
        GlobalConfigHolder globalConfigHolder = this;
        object = (GlobalConfig)object2;
        globalConfigHolder.createConfigDirectory();
        globalConfigHolder.logger.info("Saving TouchController config file");
        Path path = globalConfigHolder.configFile;
        Intrinsics.checkNotNullExpressionValue(path, "configFile");
        Json json = this.getJson();
        json.getSerializersModule();
        PathsKt__PathReadWriteKt.writeText$default(path, json.encodeToString(GlobalConfig.Companion.serializer(), object), null, new OpenOption[0], 2, null);
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final GameConfigEditor getGameConfigEditor() {
        return (GameConfigEditor)this.gameConfigEditor$delegate.getValue();
    }

    public final PresetManager getPresetManager() {
        return (PresetManager)this.presetManager$delegate.getValue();
    }

    public final WidgetPresetManager getWidgetPresetManager() {
        return (WidgetPresetManager)this.widgetPresetManager$delegate.getValue();
    }

    public final Json getJson() {
        return (Json)this.json$delegate.getValue();
    }

    public final void createConfigDirectory() {
        int n;
        Path path;
        if (!Files.exists(this.configDir, Arrays.copyOf(new LinkOption[0], 0))) {
            GlobalConfigHolder globalConfigHolder = this;
            globalConfigHolder.logger.info("First startup of TouchController, turn on auto jumping");
            globalConfigHolder.getGameConfigEditor().submit(GlobalConfigHolder::createConfigDirectory$lambda$2);
        }
        try {
            path = this.configDir;
            n = 0;
        }
        catch (IOException iOException) {}
        Intrinsics.checkNotNullExpressionValue(Files.createDirectories(path, Arrays.copyOf(new FileAttribute[0], n)), "createDirectories(...)");
    }
}

