/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageException;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.UInt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;

public final class CapabilityMessage
extends ProxyMessage {
    public final String capability;
    public final int type;

    public CapabilityMessage(String string) {
        CapabilityMessage capabilityMessage = this;
        Intrinsics.checkNotNullParameter(string, "capability");
        super(null);
        capabilityMessage.capability = string;
        capabilityMessage.type = 5;
        if (string.length() < 128) {
            return;
        }
        string = "Capability too long: " + string;
        throw new IllegalArgumentException(string.toString());
    }

    public final String getCapability() {
        return this.capability;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        CapabilityMessage capabilityMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        byteBuffer.put((byte)capabilityMessage.capability.length());
        byteBuffer.put(StringsKt__StringsJVMKt.encodeToByteArray(this.capability));
    }

    public String toString() {
        return "CapabilityMessage(capability=" + this.capability + ')';
    }

    public int hashCode() {
        return this.capability.hashCode();
    }

    public boolean equals(Object object) {
        if (capabilityMessage2 == object) {
            return true;
        }
        if (!(object instanceof CapabilityMessage)) {
            return false;
        }
        CapabilityMessage capabilityMessage = capabilityMessage2;
        CapabilityMessage capabilityMessage2 = (CapabilityMessage)object;
        return Intrinsics.areEqual(capabilityMessage.capability, capabilityMessage2.capability);
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public CapabilityMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 1) {
                int n = UInt.constructor-impl(byteBuffer.get());
                if (n > 0) {
                    if (byteBuffer.remaining() == n) {
                        byte[] byArray = new byte[n];
                        byteBuffer.get(byArray);
                        return new CapabilityMessage(StringsKt__StringsJVMKt.decodeToString(byArray));
                    }
                    throw new BadMessageLengthException(n, byteBuffer.remaining());
                }
                throw new BadMessageException("Bad capability message: length " + n);
            }
            throw new BadMessageLengthException(1, byteBuffer.remaining());
        }
    }
}

