/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__MutableCollectionsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt___CollectionsJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SlidingWindowKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.random.Random;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.sequences.Sequence;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__AppendableKt;

public abstract class CollectionsKt___CollectionsKt
extends CollectionsKt___CollectionsJvmKt {
    public static boolean contains(Iterable iterable, Object object) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            return ((Collection)iterable).contains(object);
        }
        return CollectionsKt___CollectionsKt.indexOf(iterable, object) >= 0;
    }

    public static final Object elementAt(Iterable iterable, int n) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof List) {
            return ((List)iterable).get(n);
        }
        int n2 = n;
        return CollectionsKt___CollectionsKt.elementAtOrElse(iterable, n2, arg_0 -> CollectionsKt___CollectionsKt.elementAt$lambda$0$CollectionsKt___CollectionsKt(n2, arg_0));
    }

    public static final Object elementAtOrElse(Iterable object, int n, Function1 function1) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(function1, "defaultValue");
        if (object instanceof List) {
            object = (List)object;
            return n >= 0 && n < object.size() ? object.get(n) : function1.invoke(n);
        }
        if (n < 0) {
            return function1.invoke(n);
        }
        object = object.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            Object e = object.next();
            int n3 = n2 + 1;
            if (n == n2) {
                return e;
            }
            n2 = n3;
        }
        return function1.invoke(n);
    }

    public static Object first(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (!list2.isEmpty()) {
            return list.get(0);
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object firstOrNull(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        return list2.isEmpty() ? null : list.get(0);
    }

    public static Object getOrNull(List list, int n) {
        Intrinsics.checkNotNullParameter(list, "<this>");
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    public static final int indexOf(Iterable iterable, Object object) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof List) {
            return ((List)iterable).indexOf(object);
        }
        int n = 0;
        for (Object t : iterable) {
            if (n < 0) {
                CollectionsKt__CollectionsKt.throwIndexOverflow();
            }
            if (Intrinsics.areEqual(object, t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Object last(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (!list2.isEmpty()) {
            List list3 = list;
            return list3.get(CollectionsKt__CollectionsKt.getLastIndex(list3));
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object lastOrNull(List list) {
        Object v1;
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (list2.isEmpty()) {
            v1 = null;
        } else {
            List list3 = list;
            v1 = list3.get(list3.size() - 1);
        }
        return v1;
    }

    public static Object randomOrNull(Collection collection, Random random) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        if (collection.isEmpty()) {
            return null;
        }
        return CollectionsKt___CollectionsKt.elementAt(collection, random.nextInt(collection.size()));
    }

    public static Object single(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            return CollectionsKt___CollectionsKt.single((List)object);
        }
        if ((object = object.iterator()).hasNext()) {
            Object object2 = object;
            object = object2.next();
            if (!object2.hasNext()) {
                return object;
            }
            throw new IllegalArgumentException("Collection has more than one element.");
        }
        throw new NoSuchElementException("Collection is empty.");
    }

    public static final Object single(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        int n = list2.size();
        if (n != 0) {
            if (n == 1) {
                return list.get(0);
            }
            throw new IllegalArgumentException("List has more than one element.");
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object singleOrNull(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        return list2.size() == 1 ? list.get(0) : null;
    }

    public static List reversed(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection && ((Collection)iterable).size() <= 1) {
            return CollectionsKt___CollectionsKt.toList(iterable);
        }
        List list = CollectionsKt___CollectionsKt.toMutableList(iterable);
        CollectionsKt___CollectionsJvmKt.reverse(list);
        return list;
    }

    public static List sorted(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.size() <= 1) {
                return CollectionsKt___CollectionsKt.toList(iterable);
            }
            Object[] objectArray = collection.toArray(new Comparable[0]);
            ArraysKt___ArraysJvmKt.sort(objectArray);
            return ArraysKt___ArraysJvmKt.asList(objectArray);
        }
        List list = CollectionsKt___CollectionsKt.toMutableList(iterable);
        CollectionsKt__MutableCollectionsJVMKt.sort(list);
        return list;
    }

    public static List sortedWith(Iterable iterable, Comparator comparator) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.size() <= 1) {
                return CollectionsKt___CollectionsKt.toList(iterable);
            }
            Object[] objectArray = collection.toArray(new Object[0]);
            ArraysKt___ArraysJvmKt.sortWith(objectArray, comparator);
            return ArraysKt___ArraysJvmKt.asList(objectArray);
        }
        List list = CollectionsKt___CollectionsKt.toMutableList(iterable);
        CollectionsKt__MutableCollectionsJVMKt.sortWith(list, comparator);
        return list;
    }

    public static boolean[] toBooleanArray(Collection object) {
        Collection collection = object;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        object = new boolean[collection.size()];
        int n = 0;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            boolean bl = (Boolean)iterator2.next();
            object[n++] = bl;
        }
        return object;
    }

    public static int[] toIntArray(Collection object) {
        Collection collection = object;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        object = new int[collection.size()];
        int n = 0;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            int n2 = ((Number)iterator2.next()).intValue();
            object[n++] = n2;
        }
        return object;
    }

    public static final Collection toCollection(Iterable object, Collection collection) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        object = object.iterator();
        while (object.hasNext()) {
            collection.add(object.next());
        }
        return collection;
    }

    public static HashSet toHashSet(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        return (HashSet)CollectionsKt___CollectionsKt.toCollection(iterable2, new HashSet(MapsKt__MapsJVMKt.mapCapacity(CollectionsKt__IterablesKt.collectionSizeOrDefault(iterable, 12))));
    }

    public static List toList(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            int n = collection.size();
            return n != 0 ? (n != 1 ? CollectionsKt___CollectionsKt.toMutableList(collection) : CollectionsKt__CollectionsJVMKt.listOf(iterable instanceof List ? ((List)iterable).get(0) : collection.iterator().next())) : CollectionsKt__CollectionsKt.emptyList();
        }
        return CollectionsKt__CollectionsKt.optimizeReadOnlyList(CollectionsKt___CollectionsKt.toMutableList(iterable));
    }

    public static final List toMutableList(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            return CollectionsKt___CollectionsKt.toMutableList((Collection)iterable);
        }
        return (List)CollectionsKt___CollectionsKt.toCollection(iterable, new ArrayList());
    }

    public static List toMutableList(Collection collection) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        return new ArrayList(collection);
    }

    public static Set toSet(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            int n = collection.size();
            return n != 0 ? (n != 1 ? (Set)CollectionsKt___CollectionsKt.toCollection(iterable, new LinkedHashSet(MapsKt__MapsJVMKt.mapCapacity(collection.size()))) : SetsKt__SetsJVMKt.setOf(iterable instanceof List ? ((List)iterable).get(0) : collection.iterator().next())) : SetsKt__SetsKt.emptySet();
        }
        return SetsKt__SetsKt.optimizeReadOnlySet((Set)CollectionsKt___CollectionsKt.toCollection(iterable, new LinkedHashSet()));
    }

    public static Comparable minOrNull(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        object = iterable.iterator();
        if (!object.hasNext()) {
            return null;
        }
        Comparable comparable = (Comparable)object.next();
        while (object.hasNext()) {
            Comparable comparable2 = (Comparable)object.next();
            if (comparable.compareTo(comparable2) <= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static List chunked(Iterable iterable, int n) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        return CollectionsKt___CollectionsKt.windowed(iterable, n, n, true);
    }

    public static List minus(Iterable iterable, Object object) {
        ArrayList arrayList;
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(CollectionsKt__IterablesKt.collectionSizeOrDefault(iterable, 10));
        boolean bl = false;
        for (Object t : iterable2) {
            boolean bl2;
            if (!bl && Intrinsics.areEqual(t, object)) {
                bl = true;
                bl2 = false;
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            arrayList2.add(t);
        }
        return arrayList2;
    }

    public static List plus(Collection collection, Object object) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        ArrayList<Object> arrayList2 = arrayList;
        arrayList2(collection.size() + 1);
        arrayList2.addAll(collection);
        arrayList.add(object);
        return arrayList;
    }

    public static List plus(Collection collection, Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "elements");
        if (iterable2 instanceof Collection) {
            int n = collection.size();
            collection = (Collection)iterable;
            ArrayList arrayList = new ArrayList(n + collection.size());
            arrayList.addAll(collection);
            arrayList.addAll(collection);
            return arrayList;
        }
        ArrayList arrayList = new ArrayList(collection);
        CollectionsKt__MutableCollectionsKt.addAll(arrayList, iterable);
        return arrayList;
    }

    public static final List windowed(Iterable iterable, int n, int n2, boolean bl) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        SlidingWindowKt.checkWindowSizeStep(n, n2);
        if (iterable instanceof RandomAccess && iterable instanceof List) {
            int n3;
            ArrayList arrayList2;
            iterable = (List)iterable;
            int n4 = iterable.size();
            int n5 = n4 / n2;
            int n6 = n4 % n2 == 0 ? 0 : 1;
            ArrayList arrayList3 = arrayList2;
            arrayList2 = new ArrayList(n5 += n6);
            for (n5 = 0; n5 >= 0 && n5 < n4 && ((n3 = RangesKt___RangesKt.coerceAtMost(n, n4 - n5)) >= n || bl); n5 += n2) {
                ArrayList arrayList4;
                ArrayList arrayList5 = arrayList4;
                arrayList4 = new ArrayList(n3);
                for (int i = 0; i < n3; ++i) {
                    arrayList5.add(iterable.get(i + n5));
                }
                arrayList3.add(arrayList5);
            }
            return arrayList3;
        }
        Iterable iterable2 = iterable;
        iterable = arrayList;
        arrayList = new ArrayList();
        Iterator iterator2 = SlidingWindowKt.windowedIterator(iterable2.iterator(), n, n2, bl, false);
        while (iterator2.hasNext()) {
            ((ArrayList)iterable).add((List)iterator2.next());
        }
        return iterable;
    }

    public static final Appendable joinTo(Iterable iterable, Appendable appendable, CharSequence charSequence, CharSequence object, CharSequence charSequence2, int n, CharSequence charSequence3, Function1 function1) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(appendable, "buffer");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(object, "prefix");
        Intrinsics.checkNotNullParameter(charSequence2, "postfix");
        Intrinsics.checkNotNullParameter(charSequence3, "truncated");
        appendable.append((CharSequence)object);
        int n2 = 0;
        for (Object e : iterable) {
            if (++n2 > 1) {
                appendable.append(charSequence);
            }
            if (n >= 0 && n2 > n) break;
            StringsKt__AppendableKt.appendElement(appendable, e, function1);
        }
        if (n >= 0 && n2 > n) {
            appendable.append(charSequence3);
        }
        Appendable appendable2 = appendable;
        appendable2.append(charSequence2);
        return appendable2;
    }

    public static /* synthetic */ Appendable joinTo$default(Iterable iterable, Appendable appendable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 4) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 8) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        return CollectionsKt___CollectionsKt.joinTo(iterable, appendable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final String joinToString(Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        Intrinsics.checkNotNullParameter(charSequence3, "postfix");
        Intrinsics.checkNotNullParameter(charSequence4, "truncated");
        return ((StringBuilder)CollectionsKt___CollectionsKt.joinTo(iterable, new StringBuilder(), charSequence, charSequence2, charSequence3, n, charSequence4, function1)).toString();
    }

    public static /* synthetic */ String joinToString$default(Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return CollectionsKt___CollectionsKt.joinToString(iterable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static Sequence asSequence(Iterable iterable) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        return new Sequence(iterable){
            public final /* synthetic */ Iterable $this_asSequence$inlined;
            {
                this.$this_asSequence$inlined = iterable;
            }

            public Iterator iterator() {
                return this.$this_asSequence$inlined.iterator();
            }
        };
    }

    public static final Object elementAt$lambda$0$CollectionsKt___CollectionsKt(int n, int n2) {
        throw new IndexOutOfBoundsException("Collection doesn't contain element at index " + n + '.');
    }
}

