/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.time;

import java.util.Collection;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.IntIterator;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.math.MathKt__MathJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.IntRange;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt___StringsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.time.Duration;
import top.fifthlight.touchcontroller.relocated.kotlin.time.DurationUnit;
import top.fifthlight.touchcontroller.relocated.kotlin.time.DurationUnitKt__DurationUnitJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.time.DurationUnitKt__DurationUnitKt;

public abstract class DurationKt {
    public static final long toDuration(long l, DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "unit");
        DurationUnit durationUnit2 = DurationUnit.NANOSECONDS;
        long l2 = DurationUnitKt__DurationUnitJvmKt.convertDurationUnitOverflow(4611686018426999999L, durationUnit2, durationUnit);
        if (-l2 <= l && l <= l2) {
            return DurationKt.durationOfNanos(DurationUnitKt__DurationUnitJvmKt.convertDurationUnitOverflow(l, durationUnit, durationUnit2));
        }
        return DurationKt.durationOfMillis(RangesKt___RangesKt.coerceIn(DurationUnitKt__DurationUnitJvmKt.convertDurationUnit(l, durationUnit, DurationUnit.MILLISECONDS), -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final long toDuration(double d, DurationUnit durationUnit) {
        DurationUnit durationUnit2 = durationUnit;
        Intrinsics.checkNotNullParameter((Object)durationUnit2, "unit");
        double d2 = DurationUnitKt__DurationUnitJvmKt.convertDurationUnit(d, durationUnit2, DurationUnit.NANOSECONDS);
        if (Double.isNaN(d2) ^ true) {
            long l = MathKt__MathJVMKt.roundToLong(d2);
            return -4611686018426999999L <= l && l < 4611686018427000000L ? DurationKt.durationOfNanos(l) : DurationKt.durationOfMillisNormalized(MathKt__MathJVMKt.roundToLong(DurationUnitKt__DurationUnitJvmKt.convertDurationUnit(d, durationUnit, DurationUnit.MILLISECONDS)));
        }
        throw new IllegalArgumentException("Duration value cannot be NaN.".toString());
    }

    public static final long parseDuration(String string, boolean n) {
        block24: {
            block25: {
                block29: {
                    boolean bl;
                    long l;
                    block28: {
                        int n2;
                        Object object;
                        Duration.Companion companion;
                        int n3;
                        int n4;
                        block26: {
                            block27: {
                                n4 = string.length();
                                if (n4 == 0) break block24;
                                n3 = 0;
                                companion = Duration.Companion;
                                l = companion.getZERO-UwyO8pc();
                                object = "Infinity";
                                n2 = string.charAt(n3);
                                if (n2 == 43 || n2 == 45) {
                                    n3 = 1;
                                }
                                n2 = n3 > 0 ? 1 : 0;
                                bl = n2 != 0 && StringsKt__StringsKt.startsWith$default((CharSequence)string, '-', false, 2, null);
                                if (n4 <= n3) break block25;
                                if (string.charAt(n3) != 'P') break block26;
                                n = n3 + 1;
                                if (n == n4) break block27;
                                String string2 = "+-.";
                                boolean bl2 = false;
                                object = null;
                                while (n < n4) {
                                    char c;
                                    if (string.charAt(n) == 'T') {
                                        if (!bl2 && ++n != n4) {
                                            bl2 = true;
                                            continue;
                                        }
                                        throw new IllegalArgumentException();
                                    }
                                    for (n2 = n; n2 < string.length() && ('0' <= (c = string.charAt(n2)) && c < ':' || StringsKt__StringsKt.contains$default((CharSequence)string2, c, false, 2, null)); ++n2) {
                                    }
                                    Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                                    String string3 = string.substring(n, n2);
                                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                                    if (string3.length() != 0) {
                                        if ((n += string3.length()) >= 0 && n < string.length()) {
                                            char c2 = string.charAt(n);
                                            ++n;
                                            DurationUnit durationUnit = DurationUnitKt__DurationUnitKt.durationUnitByIsoChar(c2, bl2);
                                            if (object != null && ((Enum)object).compareTo(durationUnit) <= 0) {
                                                throw new IllegalArgumentException("Unexpected order of duration components");
                                            }
                                            int n5 = StringsKt__StringsKt.indexOf$default((CharSequence)string3, '.', 0, false, 6, null);
                                            if (durationUnit == DurationUnit.SECONDS && n5 > 0) {
                                                String string4 = string3;
                                                Intrinsics.checkNotNull(string4, "null cannot be cast to non-null type java.lang.String");
                                                String string5 = string4.substring(0, n5);
                                                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                                                long l2 = Duration.plus-LRDsOJo(l, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(string5), durationUnit));
                                                Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
                                                String string6 = string3.substring(n5);
                                                Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                                                l = Duration.plus-LRDsOJo(l2, DurationKt.toDuration(Double.parseDouble(string6), durationUnit));
                                                object = durationUnit;
                                                continue;
                                            }
                                            l = Duration.plus-LRDsOJo(l, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(string3), durationUnit));
                                            object = durationUnit;
                                            continue;
                                        }
                                        throw new IllegalArgumentException("Missing unit for value " + string3);
                                    }
                                    throw new IllegalArgumentException();
                                }
                                break block28;
                            }
                            throw new IllegalArgumentException();
                        }
                        if (n == 0) {
                            n = Math.max(n4 - n3, 8);
                            if (StringsKt__StringsJVMKt.regionMatches(string, n3, object, 0, n, true)) {
                                l = companion.getINFINITE-UwyO8pc();
                            } else {
                                int n6 = n2;
                                Enum enum_ = null;
                                boolean bl3 = false;
                                int n7 = n6 ^ 1;
                                if (n6 != 0 && string.charAt(n3) == '(' && StringsKt___StringsKt.last(string) == ')') {
                                    n7 = 1;
                                    if (++n3 == (n4 += -1)) {
                                        throw new IllegalArgumentException("No components");
                                    }
                                }
                                while (n3 < n4) {
                                    char c;
                                    if (bl3 && n7 != 0) {
                                        while (n3 < string.length() && string.charAt(n3) == ' ') {
                                            ++n3;
                                        }
                                    }
                                    bl3 = true;
                                    for (n2 = n3; n2 < string.length() && ('0' <= (c = string.charAt(n2)) && c < ':' || c == '.'); ++n2) {
                                    }
                                    Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                                    String string7 = string.substring(n3, n2);
                                    Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
                                    if (string7.length() != 0) {
                                        char c3;
                                        int n8;
                                        for (n8 = n3 += string7.length(); n8 < string.length() && 'a' <= (c3 = string.charAt(n8)) && c3 < '{'; ++n8) {
                                        }
                                        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                                        String string8 = string.substring(n3, n8);
                                        Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
                                        n3 += string8.length();
                                        DurationUnit durationUnit = DurationUnitKt__DurationUnitKt.durationUnitByShortName(string8);
                                        if (enum_ != null && enum_.compareTo(durationUnit) <= 0) {
                                            throw new IllegalArgumentException("Unexpected order of duration components");
                                        }
                                        int n9 = StringsKt__StringsKt.indexOf$default((CharSequence)string7, '.', 0, false, 6, null);
                                        if (n9 > 0) {
                                            String string9 = string7;
                                            Intrinsics.checkNotNull(string9, "null cannot be cast to non-null type java.lang.String");
                                            String string10 = string9.substring(0, n9);
                                            Intrinsics.checkNotNullExpressionValue(string10, "substring(...)");
                                            long l3 = Duration.plus-LRDsOJo(l, DurationKt.toDuration(Long.parseLong(string10), durationUnit));
                                            Intrinsics.checkNotNull(string7, "null cannot be cast to non-null type java.lang.String");
                                            String string11 = string7.substring(n9);
                                            Intrinsics.checkNotNullExpressionValue(string11, "substring(...)");
                                            l = Duration.plus-LRDsOJo(l3, DurationKt.toDuration(Double.parseDouble(string11), durationUnit));
                                            if (n3 >= n4) {
                                                enum_ = durationUnit;
                                                continue;
                                            }
                                            throw new IllegalArgumentException("Fractional component must be last");
                                        }
                                        l = Duration.plus-LRDsOJo(l, DurationKt.toDuration(Long.parseLong(string7), durationUnit));
                                        enum_ = durationUnit;
                                        continue;
                                    }
                                    throw new IllegalArgumentException();
                                }
                            }
                        }
                        break block29;
                    }
                    if (bl) {
                        l = Duration.unaryMinus-UwyO8pc(l);
                    }
                    return l;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException("No components");
        }
        throw new IllegalArgumentException("The string is empty");
    }

    public static final long parseOverLongIsoComponent(String string) {
        int n = string.length();
        int n2 = 0;
        if (n > 0 && StringsKt__StringsKt.contains$default((CharSequence)"+-", string.charAt(0), false, 2, null)) {
            n2 = 1;
        }
        if (n - n2 > 16) {
            IntRange intRange;
            Object object = intRange;
            if (!(new IntRange(n2, StringsKt__StringsKt.getLastIndex(string)) instanceof Collection) || !((Collection)object).isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    n2 = string.charAt(((IntIterator)object).nextInt());
                    if (48 <= n2 && n2 < 58) {
                        continue;
                    }
                    break;
                }
            } else {
                return string.charAt(0) == '-' ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
        }
        return StringsKt__StringsJVMKt.startsWith$default(string, "+", false, 2, null) ? Long.parseLong(StringsKt___StringsKt.drop(string, 1)) : Long.parseLong(string);
    }

    public static final long nanosToMillis(long l) {
        return l / (long)1000000;
    }

    public static final long millisToNanos(long l) {
        return l * (long)1000000;
    }

    public static final long durationOfNanos(long l) {
        return Duration.constructor-impl(l << 1);
    }

    public static final long durationOfMillis(long l) {
        return Duration.constructor-impl((l << 1) + 1L);
    }

    public static final long durationOf(long l, int n) {
        return Duration.constructor-impl((l << 1) + (long)n);
    }

    public static final long durationOfNanosNormalized(long l) {
        return -4611686018426999999L <= l && l < 4611686018427000000L ? DurationKt.durationOfNanos(l) : DurationKt.durationOfMillis(DurationKt.nanosToMillis(l));
    }

    public static final long durationOfMillisNormalized(long l) {
        return -4611686018426L <= l && l < 4611686018427L ? DurationKt.durationOfNanos(DurationKt.millisToNanos(l)) : DurationKt.durationOfMillis(RangesKt___RangesKt.coerceIn(l, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final /* synthetic */ long access$parseDuration(String string, boolean bl) {
        return DurationKt.parseDuration(string, bl);
    }

    public static final /* synthetic */ long access$durationOf(long l, int n) {
        return DurationKt.durationOf(l, n);
    }

    public static final /* synthetic */ long access$durationOfNanosNormalized(long l) {
        return DurationKt.durationOfNanosNormalized(l);
    }

    public static final /* synthetic */ long access$durationOfMillisNormalized(long l) {
        return DurationKt.durationOfMillisNormalized(l);
    }

    public static final /* synthetic */ long access$nanosToMillis(long l) {
        return DurationKt.nanosToMillis(l);
    }

    public static final /* synthetic */ long access$millisToNanos(long l) {
        return DurationKt.millisToNanos(l);
    }

    public static final /* synthetic */ long access$durationOfNanos(long l) {
        return DurationKt.durationOfNanos(l);
    }

    public static final /* synthetic */ long access$durationOfMillis(long l) {
        return DurationKt.durationOfMillis(l);
    }
}

