/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import java.util.Arrays;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.UInt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class LargeMessage
extends ProxyMessage {
    public static final Companion Companion = new Companion(null);
    public final byte[] payload;
    public final boolean end;

    public LargeMessage(byte[] byArray, boolean bl) {
        Intrinsics.checkNotNullParameter(byArray, "payload");
        super(null);
        this.payload = byArray;
        this.end = bl;
        if (byArray.length <= 240) {
            return;
        }
        throw new IllegalArgumentException("Payload length too large: 240".toString());
    }

    public final byte[] getPayload() {
        return this.payload;
    }

    public final boolean getEnd() {
        return this.end;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        LargeMessage largeMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        byteBuffer.put((byte)largeMessage.payload.length);
        if (this.end) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put(this.payload);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Class<LargeMessage> clazz = LargeMessage.class;
        Class<?> clazz2 = object != null ? object.getClass() : null;
        if (!Intrinsics.areEqual(clazz, clazz2)) {
            return false;
        }
        Object object2 = object;
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type top.fifthlight.touchcontroller.proxy.message.LargeMessage");
        object = (LargeMessage)object2;
        if (this.getType() != ((LargeMessage)object).getType()) {
            return false;
        }
        return Arrays.equals(this.payload, ((LargeMessage)object).payload);
    }

    public int hashCode() {
        return this.getType() * 31 + Arrays.hashCode(this.payload);
    }

    public String toString() {
        return "LargeMessage(payload=" + Arrays.toString(this.payload) + ", end=" + this.end + ')';
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public LargeMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 2) {
                ByteBuffer byteBuffer3 = byteBuffer;
                int n = UInt.constructor-impl(byteBuffer3.get());
                boolean bl = byteBuffer3.get() != 0;
                if (byteBuffer.remaining() >= n) {
                    byte[] byArray = new byte[n];
                    byteBuffer.get(byArray);
                    return new LargeMessage(byArray, bl);
                }
                throw new BadMessageLengthException(++n, byteBuffer.remaining());
            }
            throw new BadMessageLengthException(2, byteBuffer.remaining());
        }
    }
}

