/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class MoveViewMessage
extends ProxyMessage {
    public final boolean screenBased;
    public final float deltaPitch;
    public final float deltaYaw;
    public final int type;

    public MoveViewMessage(boolean bl, float f, float f2) {
        super(null);
        this.screenBased = bl;
        this.deltaPitch = f;
        this.deltaYaw = f2;
        this.type = 12;
    }

    public final boolean getScreenBased() {
        return this.screenBased;
    }

    public final float getDeltaPitch() {
        return this.deltaPitch;
    }

    public final float getDeltaYaw() {
        return this.deltaYaw;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        MoveViewMessage moveViewMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        byteBuffer.put((byte)(moveViewMessage.screenBased ? 1 : 0));
        byteBuffer.putFloat(this.deltaPitch);
        byteBuffer.putFloat(this.deltaYaw);
    }

    public String toString() {
        return "MoveViewMessage(screenBased=" + this.screenBased + ", deltaPitch=" + this.deltaPitch + ", deltaYaw=" + this.deltaYaw + ')';
    }

    public int hashCode() {
        return (Boolean.hashCode(this.screenBased) * 31 + Float.hashCode(this.deltaPitch)) * 31 + Float.hashCode(this.deltaYaw);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MoveViewMessage)) {
            return false;
        }
        object = (MoveViewMessage)object;
        if (this.screenBased != ((MoveViewMessage)object).screenBased) {
            return false;
        }
        if (Float.compare(this.deltaPitch, ((MoveViewMessage)object).deltaPitch) != 0) {
            return false;
        }
        return Float.compare(this.deltaYaw, ((MoveViewMessage)object).deltaYaw) == 0;
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public MoveViewMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 5) {
                boolean bl = byteBuffer.get() != 0;
                ByteBuffer byteBuffer3 = byteBuffer;
                float f = byteBuffer3.getFloat();
                float f2 = byteBuffer3.getFloat();
                return new MoveViewMessage(bl, f, f2);
            }
            throw new BadMessageLengthException(5, byteBuffer.remaining());
        }
    }
}

