/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common_1_21_x.gal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import top.fifthlight.touchcontroller.common.gal.PlayerHandle;
import top.fifthlight.touchcontroller.helper.SyncableGameMode;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public abstract class AbstractPlayerHandleImpl
implements PlayerHandle {
    public final LocalPlayer inner;

    public AbstractPlayerHandleImpl(LocalPlayer localPlayer) {
        Intrinsics.checkNotNullParameter(localPlayer, "inner");
        this.inner = localPlayer;
    }

    public final LocalPlayer getInner() {
        return this.inner;
    }

    @Override
    public void changeLookDirection(double d, double d2) {
        double d3 = d / 0.15;
        double d4 = d2 / 0.15;
        this.inner.turn(d3, d4);
    }

    @Override
    public void dropSlot(int n) {
        if (n == this.getCurrentSelectedSlot()) {
            this.inner.drop(true);
            return;
        }
        AbstractPlayerHandleImpl abstractPlayerHandleImpl = this;
        int n2 = abstractPlayerHandleImpl.getCurrentSelectedSlot();
        MultiPlayerGameMode multiPlayerGameMode = abstractPlayerHandleImpl.getClient().gameMode;
        Intrinsics.checkNotNull(multiPlayerGameMode, "null cannot be cast to non-null type top.fifthlight.touchcontroller.helper.SyncableGameMode");
        SyncableGameMode syncableGameMode = (SyncableGameMode)multiPlayerGameMode;
        this.setCurrentSelectedSlot(n);
        syncableGameMode.touchcontroller$callSyncSelectedSlot();
        this.inner.drop(true);
        this.setCurrentSelectedSlot(n2);
        syncableGameMode.touchcontroller$callSyncSelectedSlot();
    }

    @Override
    public boolean isUsingItem() {
        return this.inner.isUsingItem();
    }

    @Override
    public boolean getOnGround() {
        return this.inner.onGround();
    }

    @Override
    public boolean isFlying() {
        return this.inner.getAbilities().flying;
    }

    @Override
    public void setFlying(boolean bl) {
        this.inner.getAbilities().flying = bl;
    }

    @Override
    public boolean isSubmergedInWater() {
        return this.inner.isUnderWater();
    }

    @Override
    public boolean isTouchingWater() {
        return this.inner.isInWater();
    }

    @Override
    public boolean isSprinting() {
        return this.inner.isSprinting();
    }

    @Override
    public void setSprinting(boolean bl) {
        this.inner.setSprinting(bl);
    }

    @Override
    public boolean isSneaking() {
        return this.inner.isSteppingCarefully();
    }

    @Override
    public boolean getCanFly() {
        return this.inner.getAbilities().mayfly;
    }

    public final Minecraft getClient() {
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNullExpressionValue(minecraft, "getInstance(...)");
        return minecraft;
    }
}

