/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import top.fifthlight.touchcontroller.relocated.androidx.collection.MutableIntObjectMap;
import top.fifthlight.touchcontroller.relocated.androidx.collection.MutableObjectList;
import top.fifthlight.touchcontroller.relocated.androidx.collection.ObjectList;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Anchor;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Composer;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.GroupSourceInformation;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.IntStack;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.PreconditionsKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.PrioritySet;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTable;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTableKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class SlotWriter {
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    public final SlotTable table;
    public int[] groups;
    public Object[] slots;
    public ArrayList anchors;
    public HashMap sourceInformationMap;
    public MutableIntObjectMap calledByMap;
    public int groupGapStart;
    public int groupGapLen;
    public int currentSlot;
    public int currentSlotEnd;
    public int slotsGapStart;
    public int slotsGapLen;
    public int slotsGapOwner;
    public int insertCount;
    public int nodeCount;
    public final IntStack startStack;
    public final IntStack endStack;
    public final IntStack nodeCountStack;
    public MutableIntObjectMap deferredSlotWrites;
    public int currentGroup;
    public int currentGroupEnd;
    public int parent;
    public boolean closed;
    public PrioritySet pendingRecalculateMarks;

    public SlotWriter(SlotTable slotTable) {
        SlotWriter slotWriter = this;
        SlotWriter slotWriter2 = this;
        Intrinsics.checkNotNullParameter(slotTable, "table");
        this.table = slotTable;
        this.groups = slotTable.getGroups();
        this.slots = slotTable.getSlots();
        this.anchors = slotTable.getAnchors$runtime();
        this.sourceInformationMap = slotTable.getSourceInformationMap$runtime();
        this.calledByMap = slotTable.getCalledByMap$runtime();
        this.groupGapStart = slotTable.getGroupsSize();
        this.groupGapLen = this.groups.length / 5 - slotTable.getGroupsSize();
        this.slotsGapStart = slotTable.getSlotsSize();
        this.slotsGapLen = this.slots.length - slotTable.getSlotsSize();
        slotWriter2.slotsGapOwner = slotTable.getGroupsSize();
        slotWriter2.startStack = new IntStack();
        slotWriter2.endStack = new IntStack();
        slotWriter2.nodeCountStack = new IntStack();
        slotWriter.currentGroupEnd = slotTable.getGroupsSize();
        slotWriter.parent = -1;
    }

    public static /* synthetic */ void markGroup$default(SlotWriter slotWriter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotWriter.parent;
        }
        slotWriter.markGroup(n);
    }

    public static final /* synthetic */ int access$dataIndexToDataAddress(SlotWriter slotWriter, int n) {
        return slotWriter.dataIndexToDataAddress(n);
    }

    public static final /* synthetic */ int access$groupIndexToAddress(SlotWriter slotWriter, int n) {
        return slotWriter.groupIndexToAddress(n);
    }

    public final Object rawUpdate(Object object) {
        Object object2 = this.skip();
        this.set(object);
        return object2;
    }

    public final GroupSourceInformation groupSourceInformationFor(int n, String string) {
        GroupSourceInformation groupSourceInformation;
        HashMap hashMap = this.sourceInformationMap;
        if (hashMap != null) {
            Anchor anchor = this.anchor(n);
            Object object = hashMap.get(anchor);
            if (object == null) {
                GroupSourceInformation groupSourceInformation2;
                object = groupSourceInformation2;
                groupSourceInformation2 = new GroupSourceInformation(0, string, 0);
                if (string == null) {
                    ++n;
                    int n2 = this.currentGroup;
                    while (n < n2) {
                        ((GroupSourceInformation)object).reportGroup(this, n);
                        n += SlotTableKt.access$groupSize(this.groups, n);
                    }
                }
                hashMap.put(anchor, object);
            }
            groupSourceInformation = (GroupSourceInformation)object;
        } else {
            groupSourceInformation = null;
        }
        return groupSourceInformation;
    }

    public final int getCurrentGroupSlotIndex() {
        SlotWriter slotWriter = this;
        SlotWriter slotWriter2 = this;
        int n = slotWriter.currentSlot - slotWriter2.slotsStartIndex$runtime(slotWriter2.parent);
        MutableIntObjectMap mutableIntObjectMap = slotWriter.deferredSlotWrites;
        int n2 = mutableIntObjectMap != null && (this = (MutableObjectList)mutableIntObjectMap.get(((SlotWriter)this).parent)) != null ? ((ObjectList)this).getSize() : 0;
        return n + n2;
    }

    /*
     * WARNING - void declaration
     */
    public final void startGroup(int n, Object object, boolean bl, Object object2) {
        void var4_11;
        int n2 = this.parent;
        boolean bl2 = this.insertCount > 0;
        this.nodeCountStack.push(this.nodeCount);
        if (bl2) {
            int n3 = this.currentGroup;
            int n4 = this.groupIndexToAddress(n3);
            n4 = this.dataIndex(this.groups, n4);
            this.insertGroups(1);
            this.currentSlot = n4;
            this.currentSlotEnd = n4;
            int n5 = this.groupIndexToAddress(n3);
            Composer.Companion companion = Composer.Companion;
            int n6 = object != companion.getEmpty() ? 1 : 0;
            int n7 = !bl && var4_11 != companion.getEmpty() ? 1 : 0;
            int n8 = this.slotsGapLen;
            int n9 = this.slotsGapStart;
            int n10 = this.slots.length;
            n4 = this.dataIndexToDataAnchor(n4, n9, n8, n10);
            if (n4 >= 0 && this.slotsGapOwner < n3) {
                n4 = -(this.slots.length - this.slotsGapLen - n4 + 1);
            }
            int n11 = n;
            n = this.parent;
            SlotTableKt.access$initGroup(this.groups, n5, n11, bl, n6 != 0, n7 != 0, n, n4);
            n = bl + n6 + n7;
            if (n > 0) {
                void var3_9;
                void var3_8;
                int n12;
                this.insertSlots(n, n3);
                Object[] objectArray = this.slots;
                int n13 = this.currentSlot;
                if (bl) {
                    int n14 = n13;
                    n12 = n14 + 1;
                    objectArray[n14] = var4_11;
                }
                if (n6 != 0) {
                    void v3 = n12;
                    var3_8 = v3 + true;
                    objectArray[v3] = object;
                }
                if (n7 != 0) {
                    void v4 = var3_8;
                    var3_9 = v4 + true;
                    objectArray[v4] = var4_11;
                }
                this.currentSlot = var3_9;
            }
            this.nodeCount = 0;
            n = n3 + 1;
            this.parent = n3;
            this.currentGroup = n;
            if (n2 >= 0 && (object = this.sourceInformationOf(n2)) != null) {
                ((GroupSourceInformation)object).reportGroup(this, n3);
            }
        } else {
            this.startStack.push(n2);
            this.saveCurrentGroupEnd();
            n = this.currentGroup;
            int n12 = this.groupIndexToAddress(n);
            if (!Intrinsics.areEqual(var4_11, Composer.Companion.getEmpty())) {
                if (bl) {
                    this.updateNode(var4_11);
                } else {
                    this.updateAux(var4_11);
                }
            }
            int n15 = n;
            this.currentSlot = this.slotIndex(this.groups, n12);
            int n16 = this.groupIndexToAddress(this.currentGroup + 1);
            this.currentSlotEnd = this.dataIndex(this.groups, n16);
            this.nodeCount = SlotTableKt.access$nodeCount(this.groups, n12);
            this.parent = n;
            this.currentGroup = n15 + 1;
            n = n15 + SlotTableKt.access$groupSize(this.groups, n12);
        }
        this.currentGroupEnd = n;
    }

    public final boolean containsGroupMark(int n) {
        return n >= 0 && SlotTableKt.access$containsMark(this.groups, this.groupIndexToAddress(n));
    }

    public final boolean containsAnyGroupMarks(int n) {
        return n >= 0 && SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(n));
    }

    public final void recalculateMarks() {
        PrioritySet prioritySet = this.pendingRecalculateMarks;
        if (prioritySet != null) {
            while (prioritySet.isNotEmpty()) {
                this.updateContainsMarkNow(prioritySet.takeMax(), prioritySet);
            }
        }
    }

    public final void updateContainsMark(int n) {
        if (n >= 0) {
            PrioritySet prioritySet = this.pendingRecalculateMarks;
            if (prioritySet == null) {
                PrioritySet prioritySet2;
                prioritySet = prioritySet2;
                prioritySet2 = new PrioritySet(null, 1, null);
                this.pendingRecalculateMarks = prioritySet;
            }
            prioritySet.add(n);
        }
    }

    public final void updateContainsMarkNow(int n, PrioritySet prioritySet) {
        SlotWriter slotWriter = this;
        int n2 = this.groupIndexToAddress(n);
        boolean bl = slotWriter.childContainsAnyMarks(n);
        if (SlotTableKt.access$containsMark(slotWriter.groups, n2) != bl) {
            SlotTableKt.access$updateContainsMark(this.groups, n2, bl);
            int n3 = this.parent(n);
            if (n3 >= 0) {
                prioritySet.add(n3);
            }
        }
    }

    public final boolean childContainsAnyMarks(int n) {
        int n2 = n + this.groupSize(n++);
        while (n < n2) {
            if (SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(n))) {
                return true;
            }
            n += this.groupSize(n);
        }
        return false;
    }

    public final void saveCurrentGroupEnd() {
        this.endStack.push(this.getCapacity() - this.groupGapLen - this.currentGroupEnd);
    }

    public final int restoreCurrentGroupEnd() {
        this.currentGroupEnd = this.getCapacity() - this.groupGapLen - this.endStack.pop();
        return this.currentGroupEnd;
    }

    public final void fixParentAnchorsFor(int n, int n2, int n3) {
        SlotWriter slotWriter = this;
        n = slotWriter.parentIndexToAnchor(n, slotWriter.groupGapStart);
        while (n3 < n2) {
            int n4 = n3;
            SlotWriter slotWriter2 = this;
            SlotTableKt.access$updateParentAnchor(slotWriter2.groups, this.groupIndexToAddress(n3), n);
            int n5 = n4 + SlotTableKt.access$groupSize(slotWriter2.groups, this.groupIndexToAddress(n3));
            this.fixParentAnchorsFor(n4, n5, n3 + 1);
            n3 = n5;
        }
    }

    public final void moveGroupGapTo(int n) {
        SlotWriter slotWriter = this;
        int n2 = slotWriter.groupGapLen;
        int n3 = slotWriter.groupGapStart;
        if (n3 != n) {
            int n4;
            int n5;
            int n6;
            if (this.anchors.isEmpty() ^ true) {
                this.updateAnchors(n3, n);
            }
            if (n2 > 0) {
                int[] nArray = this.groups;
                n6 = n * 5;
                n5 = n2 * 5;
                int n7 = n3 * 5;
                if (n < n3) {
                    ArraysKt___ArraysJvmKt.copyInto(nArray, nArray, n6 + n5, n6, n7);
                } else {
                    int n8 = n6;
                    n6 = n7 + n5;
                    n5 = n8 + n5;
                    ArraysKt___ArraysJvmKt.copyInto(nArray, nArray, n7, n6, n5);
                }
            }
            if (n < n3) {
                n3 = n + n2;
            }
            ComposerKt.runtimeCheck(n3 < (n4 = this.getCapacity()));
            while (n3 < n4) {
                SlotWriter slotWriter2 = this;
                n6 = SlotTableKt.access$parentAnchor(slotWriter2.groups, n3);
                n5 = slotWriter2.parentIndexToAnchor(slotWriter2.parentAnchorToIndex(n6), n);
                if (n5 != n6) {
                    SlotTableKt.access$updateParentAnchor(this.groups, n3, n5);
                }
                if (++n3 != n) continue;
                n3 += n2;
            }
        }
        this.groupGapStart = n;
    }

    public final void moveSlotGapTo(int n, int n2) {
        int n3;
        SlotWriter slotWriter = this;
        int n4 = slotWriter.slotsGapLen;
        int n5 = slotWriter.slotsGapStart;
        int n6 = this.slotsGapOwner;
        if (n5 != n) {
            Object[] objectArray = this.slots;
            if (n < n5) {
                ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n + n4, n, n5);
            } else {
                n3 = n5 + n4;
                int n7 = n + n4;
                ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n5, n3, n7);
            }
        }
        if (n6 != (n2 = Math.min(n2 + 1, this.getSize$runtime()))) {
            n4 = this.slots.length - n4;
            if (n2 < n6) {
                SlotWriter slotWriter2 = this;
                n5 = slotWriter2.groupIndexToAddress(n2);
                n6 = slotWriter2.groupIndexToAddress(n6);
                int n8 = slotWriter2.groupGapStart;
                while (n5 < n6) {
                    n3 = SlotTableKt.access$dataAnchor(this.groups, n5);
                    if (!(n3 >= 0)) {
                        ComposerKt.composeImmediateRuntimeError("Unexpected anchor value, expected a positive anchor");
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, n5, -(n4 - n3 + 1));
                    if (++n5 != n8) continue;
                    n5 += this.groupGapLen;
                }
            } else {
                SlotWriter slotWriter3 = this;
                n5 = slotWriter3.groupIndexToAddress(n6);
                n6 = slotWriter3.groupIndexToAddress(n2);
                while (n5 < n6) {
                    int n9 = SlotTableKt.access$dataAnchor(this.groups, n5);
                    if (!(n9 < 0)) {
                        ComposerKt.composeImmediateRuntimeError("Unexpected anchor value, expected a negative anchor");
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, n5, n4 + n9 + 1);
                    if (++n5 != this.groupGapStart) continue;
                    n5 += this.groupGapLen;
                }
            }
            this.slotsGapOwner = n2;
        }
        this.slotsGapStart = n;
    }

    public final void clearSlotGap() {
        SlotWriter slotWriter = this;
        int n = slotWriter.slotsGapStart;
        int n2 = n + this.slotsGapLen;
        ArraysKt___ArraysJvmKt.fill(slotWriter.slots, null, n, n2);
    }

    public final void insertGroups(int n) {
        if (n > 0) {
            int n2;
            SlotWriter slotWriter = this;
            int n3 = slotWriter.currentGroup;
            slotWriter.moveGroupGapTo(n3);
            int n4 = slotWriter.groupGapStart;
            int n5 = slotWriter.groupGapLen;
            int[] nArray = this.groups;
            int n6 = this.groups.length / 5;
            int n7 = n6 - n5;
            if (n5 < n) {
                int n8 = n6;
                int n9 = Math.max(Math.max(n6 * 2, n7 + n), 32);
                int[] nArray2 = new int[n9 * 5];
                n6 = n9 - n7;
                int n10 = n4 * 5;
                ArraysKt___ArraysJvmKt.copyInto(nArray, nArray2, 0, 0, n10);
                n10 = (n4 + n6) * 5;
                int n11 = (n4 + n5) * 5;
                int n12 = n8 * 5;
                ArraysKt___ArraysJvmKt.copyInto(nArray, nArray2, n10, n11, n12);
                this.groups = nArray2;
                n5 = n6;
            }
            if ((n2 = this.currentGroupEnd) >= n4) {
                this.currentGroupEnd = n2 + n;
            }
            int n13 = n5;
            this.groupGapStart = n5 = n4 + n;
            this.groupGapLen = n13 - n;
            n3 = n7 > 0 ? this.dataIndex(n3 + n) : 0;
            n2 = this.slotsGapOwner < n4 ? 0 : this.slotsGapStart;
            int n14 = n3;
            SlotWriter slotWriter2 = this;
            n3 = slotWriter2.slotsGapLen;
            n6 = slotWriter2.slots.length;
            n3 = this.dataIndexToDataAnchor(n14, n2, n3, n6);
            for (n2 = n4; n2 < n5; ++n2) {
                SlotTableKt.access$updateDataAnchor(this.groups, n2, n3);
            }
            n3 = this.slotsGapOwner;
            if (n3 >= n4) {
                this.slotsGapOwner = n3 + n;
            }
        }
    }

    public final void insertSlots(int n, int n2) {
        if (n > 0) {
            int n3;
            SlotWriter slotWriter = this;
            slotWriter.moveSlotGapTo(slotWriter.currentSlot, n2);
            n2 = slotWriter.slotsGapStart;
            int n4 = slotWriter.slotsGapLen;
            if (n4 < n) {
                Object[] objectArray = this.slots;
                int n5 = this.slots.length;
                int n6 = n5 - n4;
                int n7 = Math.max(Math.max(n5 * 2, n6 + n), 32);
                Object[] objectArray2 = new Object[n7];
                for (int i = 0; i < n7; ++i) {
                    objectArray2[i] = null;
                }
                int n8 = n2;
                n3 = n7 - n6;
                n4 = n8 + n4;
                n6 = n8 + n3;
                ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray2, 0, 0, n2);
                ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray2, n6, n4, n5);
                this.slots = objectArray2;
                n4 = n3;
            }
            if ((n3 = this.currentSlotEnd) >= n2) {
                this.currentSlotEnd = n3 + n;
            }
            this.slotsGapStart = n2 + n;
            this.slotsGapLen = n4 - n;
        }
    }

    public final boolean removeGroups(int n, int n2) {
        boolean bl;
        if (n2 > 0) {
            bl = false;
            ArrayList arrayList = this.anchors;
            this.moveGroupGapTo(n);
            if (arrayList.isEmpty() ^ true) {
                SlotWriter slotWriter = this;
                HashMap hashMap = slotWriter.sourceInformationMap;
                bl = slotWriter.removeAnchors(n, n2, hashMap);
            }
            SlotWriter slotWriter = this;
            slotWriter.groupGapStart = n;
            slotWriter.groupGapLen += n2;
            int n3 = slotWriter.slotsGapOwner;
            if (n3 > n) {
                this.slotsGapOwner = Math.max(n, n3 - n2);
            }
            if ((n = this.currentGroupEnd) >= this.groupGapStart) {
                this.currentGroupEnd = n - n2;
            }
            SlotWriter slotWriter2 = this;
            n = slotWriter2.parent;
            if (slotWriter2.containsGroupMark(n)) {
                this.updateContainsMark(n);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final GroupSourceInformation sourceInformationOf(int n) {
        HashMap hashMap = ((SlotWriter)object).sourceInformationMap;
        Object object = hashMap != null && (object = ((SlotWriter)object).tryAnchor$runtime(n)) != null ? (GroupSourceInformation)hashMap.get(object) : null;
        return object;
    }

    public final void removeSlots(int n, int n2, int n3) {
        if (n2 > 0) {
            SlotWriter slotWriter = this;
            int n4 = slotWriter.slotsGapLen;
            int n5 = n + n2;
            this.moveSlotGapTo(n5, n3);
            this.slotsGapStart = n;
            slotWriter.slotsGapLen = n4 + n2;
            ArraysKt___ArraysJvmKt.fill(slotWriter.slots, null, n, n5);
            n3 = slotWriter.currentSlotEnd;
            if (n3 >= n) {
                this.currentSlotEnd = n3 - n2;
            }
        }
    }

    public final void updateNodeOfGroup(int n, Object object) {
        int n2 = this.groupIndexToAddress(n);
        int[] nArray = this.groups;
        if (!(n2 < this.groups.length && SlotTableKt.access$isNode(nArray, n2))) {
            ComposerKt.composeImmediateRuntimeError("Updating the node of a group at " + n + " that was not created with as a node group");
        }
        SlotWriter slotWriter = this;
        this.slots[slotWriter.dataIndexToDataAddress((int)slotWriter.nodeIndex((int[])slotWriter.groups, (int)n2))] = object;
    }

    public final void updateAnchors(int n, int n2) {
        SlotWriter slotWriter = this;
        int n3 = slotWriter.groupGapLen;
        n3 = slotWriter.getCapacity() - n3;
        if (n < n2) {
            for (n = SlotTableKt.access$locationOf(this.anchors, n, n3); n < this.anchors.size(); ++n) {
                Object e = this.anchors.get(n);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                Anchor anchor = (Anchor)e;
                int n4 = anchor.getLocation$runtime();
                if (n4 < 0 && (n4 = n3 + n4) < n2) {
                    anchor.setLocation$runtime(n4);
                    continue;
                }
                break;
            }
        } else {
            for (n = SlotTableKt.access$locationOf(this.anchors, n2, n3); n < this.anchors.size(); ++n) {
                Object e = this.anchors.get(n);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                Anchor anchor = (Anchor)e;
                int n5 = anchor.getLocation$runtime();
                if (n5 >= 0) {
                    anchor.setLocation$runtime(-(n3 - n5));
                    continue;
                }
                break;
            }
        }
    }

    public final boolean removeAnchors(int n, int n2, HashMap hashMap) {
        SlotWriter slotWriter = this;
        int n3 = n2;
        n2 = this.groupGapLen;
        int n4 = n + n3;
        n2 = slotWriter.getCapacity() - n2;
        if ((n2 = SlotTableKt.access$locationOf(slotWriter.anchors, n4, n2)) >= this.anchors.size()) {
            --n2;
        }
        int n5 = 0;
        int n6 = n2 + 1;
        while (n2 >= 0) {
            SlotWriter slotWriter2 = this;
            Object e = slotWriter2.anchors.get(n2);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            Anchor anchor = (Anchor)e;
            int n7 = slotWriter2.anchorIndex(anchor);
            if (n7 < n) break;
            if (n7 < n4) {
                anchor.setLocation$runtime(Integer.MIN_VALUE);
                if (hashMap != null) {
                    GroupSourceInformation cfr_ignored_0 = (GroupSourceInformation)hashMap.remove(anchor);
                }
                if (n5 == 0) {
                    n5 = n2 + 1;
                    n6 = n2;
                } else {
                    n6 = n2;
                }
            }
            --n2;
        }
        if ((n = n6 < n5 ? 1 : 0) != 0) {
            this.anchors.subList(n6, n5).clear();
        }
        return n != 0;
    }

    public final void moveAnchors(int n, int n2, int n3) {
        ArrayList<Anchor> arrayList;
        SlotWriter slotWriter = this;
        n3 = n + n3;
        int n4 = slotWriter.getSize$runtime();
        int n5 = SlotTableKt.access$locationOf(slotWriter.anchors, n, n4);
        ArrayList<Anchor> arrayList2 = arrayList;
        arrayList = new ArrayList<Anchor>();
        if (n5 >= 0) {
            while (n5 < this.anchors.size()) {
                SlotWriter slotWriter2 = this;
                Object e = slotWriter2.anchors.get(n5);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                Anchor anchor = (Anchor)e;
                int n6 = slotWriter2.anchorIndex(anchor);
                if (n6 < n || n6 >= n3) break;
                arrayList2.add(anchor);
                this.anchors.remove(n5);
            }
        }
        n = n2 - n;
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Anchor anchor = (Anchor)arrayList2.get(n2);
            int n7 = this.anchorIndex(anchor) + n;
            if (n7 >= this.groupGapStart) {
                anchor.setLocation$runtime(-(n4 - n7));
            } else {
                anchor.setLocation$runtime(n7);
            }
            SlotWriter slotWriter3 = this;
            n7 = SlotTableKt.access$locationOf(slotWriter3.anchors, n7, n4);
            slotWriter3.anchors.add(n7, anchor);
        }
    }

    public final int getCapacity() {
        return this.groups.length / 5;
    }

    public final int groupIndexToAddress(int n) {
        if (n >= this.groupGapStart) {
            n += this.groupGapLen;
        }
        return n;
    }

    public final int dataIndexToDataAddress(int n) {
        if (n >= this.slotsGapStart) {
            n += this.slotsGapLen;
        }
        return n;
    }

    public final int parent(int[] nArray, int n) {
        return this.parentAnchorToIndex(SlotTableKt.access$parentAnchor(nArray, this.groupIndexToAddress(n)));
    }

    public final int dataIndex(int n) {
        SlotWriter slotWriter = object;
        Object object = ((SlotWriter)object).groups;
        return slotWriter.dataIndex((int[])object, slotWriter.groupIndexToAddress(n));
    }

    public final int dataIndex(int[] nArray, int n) {
        int n2;
        if (n >= this.getCapacity()) {
            n2 = this.slots.length - this.slotsGapLen;
        } else {
            SlotWriter slotWriter = this;
            int n3 = SlotTableKt.access$dataAnchor(nArray, n);
            n = slotWriter.slotsGapLen;
            n2 = slotWriter.dataAnchorToDataIndex(n3, n, this.slots.length);
        }
        return n2;
    }

    public final int slotIndex(int[] nArray, int n) {
        int n2;
        if (n >= this.getCapacity()) {
            n2 = this.slots.length - this.slotsGapLen;
        } else {
            SlotWriter slotWriter = this;
            int n3 = SlotTableKt.access$slotAnchor(nArray, n);
            n = slotWriter.slotsGapLen;
            n2 = slotWriter.dataAnchorToDataIndex(n3, n, this.slots.length);
        }
        return n2;
    }

    public final void updateDataIndex(int[] nArray, int n, int n2) {
        int n3 = n;
        SlotWriter slotWriter = this;
        int n4 = slotWriter.slotsGapStart;
        int n5 = slotWriter.slotsGapLen;
        n = slotWriter.slots.length;
        SlotTableKt.access$updateDataAnchor(nArray, n3, this.dataIndexToDataAnchor(n2, n4, n5, n));
    }

    public final int nodeIndex(int[] nArray, int n) {
        return this.dataIndex(nArray, n);
    }

    public final int auxIndex(int[] nArray, int n) {
        return this.dataIndex(nArray, n) + SlotTableKt.access$countOneBits(SlotTableKt.access$groupInfo(nArray, n) >> 29);
    }

    public final int dataIndexToDataAnchor(int n, int n2, int n3, int n4) {
        if (n > n2) {
            n = -(n4 - n3 - n + 1);
        }
        return n;
    }

    public final int dataAnchorToDataIndex(int n, int n2, int n3) {
        if (n < 0) {
            n = n3 - n2 + n + 1;
        }
        return n;
    }

    public final int parentIndexToAnchor(int n, int n2) {
        if (n >= n2) {
            n = -(this.getSize$runtime() - n - -2);
        }
        return n;
    }

    public final int parentAnchorToIndex(int n) {
        if (n <= -2) {
            n = this.getSize$runtime() + n - -2;
        }
        return n;
    }

    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getSlotsSize() {
        return this.slots.length - this.slotsGapLen;
    }

    public final boolean isNode() {
        int n = this.currentGroup;
        return n < this.currentGroupEnd && SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(n));
    }

    public final boolean isNode(int n) {
        return SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(n));
    }

    public final int nodeCount(int n) {
        return SlotTableKt.access$nodeCount(this.groups, this.groupIndexToAddress(n));
    }

    public final int groupKey(int n) {
        return SlotTableKt.access$key(this.groups, this.groupIndexToAddress(n));
    }

    public final Object groupObjectKey(int n) {
        SlotWriter slotWriter = this;
        return SlotTableKt.access$hasObjectKey(slotWriter.groups, n = slotWriter.groupIndexToAddress(n)) ? this.slots[SlotTableKt.access$objectKeyIndex(this.groups, n)] : null;
    }

    public final int groupSize(int n) {
        return SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(n));
    }

    public final Object groupAux(int n) {
        Object object;
        SlotWriter slotWriter = this;
        if (SlotTableKt.access$hasAux(slotWriter.groups, n = slotWriter.groupIndexToAddress(n))) {
            SlotWriter slotWriter2 = this;
            object = this.slots[slotWriter2.auxIndex(slotWriter2.groups, n)];
        } else {
            object = Composer.Companion.getEmpty();
        }
        return object;
    }

    public final boolean indexInParent(int n) {
        int n2 = this.parent;
        return n > n2 && n < this.currentGroupEnd || n2 == 0 && n == 0;
    }

    public final boolean indexInCurrentGroup(int n) {
        return this.indexInGroup(n, this.currentGroup);
    }

    public final boolean indexInGroup(int n, int n2) {
        int n3;
        int n4 = n2 == this.parent ? this.currentGroupEnd : (n2 > this.startStack.peekOr(0) ? n2 + this.groupSize(n2) : ((n3 = this.startStack.indexOf(n2)) < 0 ? n2 + this.groupSize(n2) : this.getCapacity() - this.groupGapLen - this.endStack.peek(n3)));
        return n > n2 && n < n4;
    }

    public final Object node(int n) {
        Object object;
        SlotWriter slotWriter = this;
        if (SlotTableKt.access$isNode(slotWriter.groups, n = slotWriter.groupIndexToAddress(n))) {
            SlotWriter slotWriter2 = this;
            object = this.slots[slotWriter2.dataIndexToDataAddress(slotWriter2.nodeIndex(slotWriter2.groups, n))];
        } else {
            object = null;
        }
        return object;
    }

    public final Object node(Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        return this.node(anchor.toIndexFor(this));
    }

    public final int getParent() {
        return this.parent;
    }

    public final int parent(int n) {
        SlotWriter slotWriter = this;
        return slotWriter.parent(slotWriter.groups, n);
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void close(boolean bl) {
        Object object;
        ((SlotWriter)object).closed = true;
        if (bl && ((SlotWriter)object).startStack.isEmpty()) {
            SlotWriter slotWriter = object;
            slotWriter.moveGroupGapTo(slotWriter.getSize$runtime());
            int n = slotWriter.slots.length - ((SlotWriter)object).slotsGapLen;
            slotWriter.moveSlotGapTo(n, slotWriter.groupGapStart);
            slotWriter.clearSlotGap();
            slotWriter.recalculateMarks();
        }
        SlotWriter slotWriter = object;
        object = slotWriter.groups;
        int n = slotWriter.groupGapStart;
        Object[] objectArray = slotWriter.slots;
        int n2 = slotWriter.slotsGapStart;
        ArrayList arrayList = slotWriter.anchors;
        HashMap hashMap = slotWriter.sourceInformationMap;
        MutableIntObjectMap mutableIntObjectMap = slotWriter.calledByMap;
        ((SlotWriter)object).table.close$runtime(slotWriter, (int[])object, n, objectArray, n2, arrayList, hashMap, mutableIntObjectMap);
    }

    public final void reset() {
        if (!(this.insertCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot reset when inserting");
        }
        SlotWriter slotWriter = this;
        slotWriter.recalculateMarks();
        slotWriter.currentGroup = 0;
        slotWriter.currentGroupEnd = slotWriter.getCapacity() - this.groupGapLen;
        slotWriter.currentSlot = 0;
        slotWriter.currentSlotEnd = 0;
        slotWriter.nodeCount = 0;
    }

    public final Object update(Object object) {
        if (this.insertCount > 0 && this.currentSlot != this.slotsGapStart) {
            MutableIntObjectMap mutableIntObjectMap = this.deferredSlotWrites;
            if (mutableIntObjectMap == null) {
                MutableIntObjectMap mutableIntObjectMap2;
                mutableIntObjectMap = mutableIntObjectMap2;
                mutableIntObjectMap2 = new MutableIntObjectMap(0, 1, null);
            }
            this.deferredSlotWrites = mutableIntObjectMap;
            int n = this.parent;
            Object object2 = mutableIntObjectMap.get(n);
            if (object2 == null) {
                MutableObjectList mutableObjectList;
                object2 = mutableObjectList;
                mutableObjectList = new MutableObjectList(0, 1, null);
                mutableIntObjectMap.set(n, object2);
            }
            ((MutableObjectList)object2).add(object);
            return Composer.Companion.getEmpty();
        }
        return this.rawUpdate(object);
    }

    public final void appendSlot(Anchor anchor, Object object) {
        int n;
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        if (!(this.insertCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Can only append a slot if not current inserting");
        }
        int n2 = this.currentSlot;
        SlotWriter slotWriter = this;
        int n3 = this.currentSlotEnd;
        int n4 = slotWriter.anchorIndex(anchor);
        int[] nArray = this.groups;
        slotWriter.currentSlot = n = slotWriter.dataIndex(nArray, slotWriter.groupIndexToAddress(n4 + 1));
        slotWriter.currentSlotEnd = n;
        slotWriter.insertSlots(1, n4);
        if (n2 >= n) {
            ++n2;
            ++n3;
        }
        this.slots[n] = object;
        this.currentSlot = n2;
        this.currentSlotEnd = n3;
    }

    public final void trimTailSlots(int n) {
        ComposerKt.runtimeCheck(n > 0);
        SlotWriter slotWriter = this;
        int n2 = slotWriter.parent;
        SlotWriter slotWriter2 = this;
        int[] nArray = this.groups;
        int n3 = slotWriter2.slotIndex(nArray, slotWriter2.groupIndexToAddress(n2));
        int[] nArray2 = slotWriter2.groups;
        int n4 = slotWriter.dataIndex(nArray2, slotWriter.groupIndexToAddress(n2 + 1)) - n;
        ComposerKt.runtimeCheck(n4 >= n3);
        SlotWriter slotWriter3 = this;
        slotWriter3.removeSlots(n4, n, n2);
        n2 = slotWriter3.currentSlot;
        if (n2 >= n3) {
            this.currentSlot = n2 - n;
        }
    }

    public final void updateAux(Object object) {
        SlotWriter slotWriter = this;
        int n = slotWriter.groupIndexToAddress(slotWriter.currentGroup);
        if (!SlotTableKt.access$hasAux(slotWriter.groups, n)) {
            ComposerKt.composeImmediateRuntimeError("Updating the data of a group that was not created with a data slot");
        }
        SlotWriter slotWriter2 = this;
        this.slots[slotWriter2.dataIndexToDataAddress((int)slotWriter2.auxIndex((int[])slotWriter2.groups, (int)n))] = object;
    }

    public final void recordGroupSourceInformation(String string) {
        Intrinsics.checkNotNullParameter(string, "sourceInformation");
        if (this.insertCount > 0) {
            SlotWriter slotWriter = this;
            slotWriter.groupSourceInformationFor(slotWriter.parent, string);
        }
    }

    public final void recordGrouplessCallSourceInformationStart(int n, String string) {
        Intrinsics.checkNotNullParameter(string, "value");
        if (this.insertCount > 0) {
            Object object = this.calledByMap;
            if (object != null) {
                SlotWriter slotWriter = this;
                SlotTableKt.access$add((MutableIntObjectMap)object, n, slotWriter.groupKey(slotWriter.parent));
            }
            SlotWriter slotWriter = this;
            object = slotWriter.groupSourceInformationFor(slotWriter.parent, null);
            if (object != null) {
                int n2 = this.getCurrentGroupSlotIndex();
                ((GroupSourceInformation)object).startGrouplessCall(n, string, n2);
            }
        }
    }

    public final void recordGrouplessCallSourceInformationEnd() {
        if (this.insertCount > 0) {
            SlotWriter slotWriter = this;
            GroupSourceInformation groupSourceInformation = slotWriter.groupSourceInformationFor(slotWriter.parent, null);
            if (groupSourceInformation != null) {
                groupSourceInformation.endGrouplessCall(this.getCurrentGroupSlotIndex());
            }
        }
    }

    public final void updateNode(Object object) {
        SlotWriter slotWriter = this;
        slotWriter.updateNodeOfGroup(slotWriter.currentGroup, object);
    }

    public final void updateNode(Anchor anchor, Object object) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.updateNodeOfGroup(anchor.toIndexFor(this), object);
    }

    public final void set(Object object) {
        if (!(this.currentSlot <= this.currentSlotEnd)) {
            ComposerKt.composeImmediateRuntimeError("Writing to an invalid slot");
        }
        SlotWriter slotWriter = this;
        this.slots[slotWriter.dataIndexToDataAddress((int)(slotWriter.currentSlot - 1))] = object;
    }

    public final Object set(int n, Object object) {
        SlotWriter slotWriter = this;
        return slotWriter.set(slotWriter.currentGroup, n, object);
    }

    public final int slotIndexOfGroupSlotIndex(int n, int n2) {
        SlotWriter slotWriter = object;
        int n3 = slotWriter.groupIndexToAddress(n);
        n3 = slotWriter.slotIndex(slotWriter.groups, n3);
        SlotWriter slotWriter2 = object;
        Object object = ((SlotWriter)object).groups;
        int n4 = slotWriter2.dataIndex((int[])object, slotWriter2.groupIndexToAddress(n + 1));
        int n5 = n3 + n2;
        if (!(n5 >= n3 && n5 < n4)) {
            ComposerKt.composeImmediateRuntimeError("Write to an invalid slot index " + n2 + " for group " + n);
        }
        return n5;
    }

    public final Object set(int n, int n2, Object object) {
        SlotWriter slotWriter = this;
        int n3 = slotWriter.dataIndexToDataAddress(slotWriter.slotIndexOfGroupSlotIndex(n, n2));
        Object[] objectArray = slotWriter.slots;
        objectArray[n3] = object;
        return slotWriter.slots[n3];
    }

    public final Object skip() {
        if (this.insertCount > 0) {
            SlotWriter slotWriter = this;
            slotWriter.insertSlots(1, slotWriter.parent);
        }
        SlotWriter slotWriter = this;
        int n = slotWriter.currentSlot;
        slotWriter.currentSlot = n + 1;
        return this.slots[slotWriter.dataIndexToDataAddress(n)];
    }

    public final Object slot(Anchor anchor, int n) {
        SlotWriter slotWriter = this;
        Anchor anchor2 = anchor;
        Intrinsics.checkNotNullParameter(anchor2, "anchor");
        return slotWriter.slot(slotWriter.anchorIndex(anchor2), n);
    }

    public final Object slot(int n, int n2) {
        SlotWriter slotWriter = this;
        int n3 = slotWriter.groupIndexToAddress(n);
        int n4 = slotWriter.slotIndex(slotWriter.groups, n3);
        SlotWriter slotWriter2 = this;
        int[] nArray = this.groups;
        int n5 = slotWriter2.dataIndex(nArray, slotWriter2.groupIndexToAddress(n + 1));
        if (n4 <= (n2 = n4 + n2) && n2 < n5) {
            SlotWriter slotWriter3 = this;
            int n6 = slotWriter3.dataIndexToDataAddress(n2);
            return slotWriter3.slots[n6];
        }
        return Composer.Companion.getEmpty();
    }

    public final int slotsStartIndex$runtime(int n) {
        SlotWriter slotWriter = object;
        Object object = ((SlotWriter)object).groups;
        return slotWriter.slotIndex((int[])object, slotWriter.groupIndexToAddress(n));
    }

    public final int slotsEndIndex$runtime(int n) {
        SlotWriter slotWriter = object;
        Object object = ((SlotWriter)object).groups;
        return slotWriter.dataIndex((int[])object, slotWriter.groupIndexToAddress(n + 1));
    }

    public final int slotsEndAllIndex$runtime(int n) {
        SlotWriter slotWriter = object;
        SlotWriter slotWriter2 = object;
        Object object = ((SlotWriter)object).groups;
        return slotWriter.dataIndex((int[])object, slotWriter.groupIndexToAddress(n + slotWriter2.groupSize(n)));
    }

    public final void advanceBy(int n) {
        int n2;
        if (!(n >= 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot seek backwards");
        }
        if (!(((SlotWriter)object).insertCount <= 0)) {
            PreconditionsKt.throwIllegalStateException("Cannot call seek() while inserting");
        }
        if (n == 0) {
            return;
        }
        if (!((n = ((SlotWriter)object).currentGroup + n) >= ((SlotWriter)object).parent && n <= ((SlotWriter)object).currentGroupEnd)) {
            ComposerKt.composeImmediateRuntimeError("Cannot seek outside the current group (" + ((SlotWriter)object).parent + '-' + ((SlotWriter)object).currentGroupEnd + ')');
        }
        SlotWriter slotWriter = object;
        slotWriter.currentGroup = n;
        Object object = slotWriter.groups;
        slotWriter.currentSlot = n2 = slotWriter.dataIndex((int[])object, slotWriter.groupIndexToAddress(n));
        slotWriter.currentSlotEnd = n2;
    }

    public final void skipToGroupEnd() {
        int n;
        SlotWriter slotWriter = this;
        slotWriter.currentGroup = n = slotWriter.currentGroupEnd;
        int[] nArray = slotWriter.groups;
        slotWriter.currentSlot = slotWriter.dataIndex(nArray, slotWriter.groupIndexToAddress(n));
    }

    public final void beginInsert() {
        if (this.insertCount++ == 0) {
            this.saveCurrentGroupEnd();
        }
    }

    public final void endInsert() {
        if (!(this.insertCount > 0)) {
            PreconditionsKt.throwIllegalStateException("Unbalanced begin/end insert");
        }
        if ((this.insertCount += -1) == 0) {
            if (!(this.nodeCountStack.getSize() == this.startStack.getSize())) {
                ComposerKt.composeImmediateRuntimeError("startGroup/endGroup mismatch while inserting");
            }
            this.restoreCurrentGroupEnd();
        }
    }

    public final void startGroup() {
        if (!(((SlotWriter)object).insertCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Key must be supplied when inserting");
        }
        SlotWriter slotWriter = object;
        Composer.Companion companion = Composer.Companion;
        Object object = companion.getEmpty();
        Object object2 = companion.getEmpty();
        slotWriter.startGroup(0, object, false, object2);
    }

    public final void startGroup(int n, Object object) {
        SlotWriter slotWriter = object2;
        Object object2 = Composer.Companion.getEmpty();
        slotWriter.startGroup(n, object, false, object2);
    }

    public final void startNode(int n, Object object) {
        SlotWriter slotWriter = object2;
        Object object2 = Composer.Companion.getEmpty();
        slotWriter.startGroup(n, object, true, object2);
    }

    public final void startData(int n, Object object, Object object2) {
        this.startGroup(n, object, false, object2);
    }

    public final int endGroup() {
        int n = this.currentGroup;
        int n2 = this.currentGroupEnd;
        int n3 = this.parent;
        int n4 = this.groupIndexToAddress(n3);
        int n5 = this.nodeCount;
        int n6 = n - n3;
        int n7 = SlotTableKt.access$isNode(this.groups, n4);
        if (this.insertCount > 0) {
            Object[] objectArray;
            MutableIntObjectMap mutableIntObjectMap = this.deferredSlotWrites;
            if (mutableIntObjectMap != null && (objectArray = (Object[])mutableIntObjectMap.get(n3)) != null) {
                objectArray = objectArray.content;
                int n8 = objectArray._size;
                for (int i = 0; i < n8; ++i) {
                    this.rawUpdate(objectArray[i]);
                }
                MutableObjectList cfr_ignored_0 = (MutableObjectList)mutableIntObjectMap.remove(n3);
            }
            SlotTableKt.access$updateGroupSize(this.groups, n4, n6);
            SlotTableKt.access$updateNodeCount(this.groups, n4, n5);
            int n9 = this.nodeCountStack.pop();
            n2 = n7 != 0 ? 1 : n5;
            this.nodeCount = n9 + n2;
            this.parent = n9 = this.parent(this.groups, n3);
            n9 = n9 < 0 ? this.getSize$runtime() : this.groupIndexToAddress(n9 + 1);
            n9 = n9 < 0 ? 0 : this.dataIndex(this.groups, n9);
            this.currentSlot = n9;
            this.currentSlotEnd = n9;
        } else {
            int n10;
            if (!(n == n2)) {
                ComposerKt.composeImmediateRuntimeError("Expected to be at the end of a group");
            }
            n = SlotTableKt.access$groupSize(this.groups, n4);
            n2 = SlotTableKt.access$nodeCount(this.groups, n4);
            SlotTableKt.access$updateGroupSize(this.groups, n4, n6);
            SlotTableKt.access$updateNodeCount(this.groups, n4, n5);
            n4 = this.startStack.pop();
            this.restoreCurrentGroupEnd();
            this.parent = n4;
            n3 = this.parent(this.groups, n3);
            this.nodeCount = n10 = this.nodeCountStack.pop();
            if (n3 == n4) {
                n = n7 != 0 ? 0 : n5 - n2;
                this.nodeCount = n10 + n;
            } else {
                n = n6 - n;
                n2 = n7 != 0 ? 0 : n5 - n2;
                if (n != 0 || n2 != 0) {
                    while (n3 != 0 && n3 != n4 && (n2 != 0 || n != 0)) {
                        n6 = this.groupIndexToAddress(n3);
                        if (n != 0) {
                            n7 = SlotTableKt.access$groupSize(this.groups, n6) + n;
                            SlotTableKt.access$updateGroupSize(this.groups, n6, n7);
                        }
                        if (n2 != 0) {
                            SlotTableKt.access$updateNodeCount(this.groups, n6, SlotTableKt.access$nodeCount(this.groups, n6) + n2);
                        }
                        if (SlotTableKt.access$isNode(this.groups, n6)) {
                            n2 = 0;
                        }
                        n3 = this.parent(this.groups, n3);
                    }
                }
                this.nodeCount += n2;
            }
        }
        return n5;
    }

    public final void ensureStarted(int n) {
        int n2;
        if (!(this.insertCount <= 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot call ensureStarted() while inserting");
        }
        if ((n2 = this.parent) != n) {
            if (!(n >= n2 && n < this.currentGroupEnd)) {
                ComposerKt.composeImmediateRuntimeError("Started group at " + n + " must be a subgroup of the group at " + n2);
            }
            SlotWriter slotWriter = this;
            int n3 = slotWriter.currentGroup;
            n2 = slotWriter.currentSlot;
            int n4 = slotWriter.currentSlotEnd;
            slotWriter.currentGroup = n;
            slotWriter.startGroup();
            slotWriter.currentGroup = n3;
            slotWriter.currentSlot = n2;
            slotWriter.currentSlotEnd = n4;
        }
    }

    public final void ensureStarted(Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.ensureStarted(anchor.toIndexFor(this));
    }

    public final int skipGroup() {
        int n;
        SlotWriter slotWriter = this;
        int n2 = slotWriter.groupIndexToAddress(slotWriter.currentGroup);
        slotWriter.currentGroup = n = slotWriter.currentGroup + SlotTableKt.access$groupSize(this.groups, n2);
        int[] nArray = slotWriter.groups;
        slotWriter.currentSlot = slotWriter.dataIndex(nArray, slotWriter.groupIndexToAddress(n));
        return SlotTableKt.access$isNode(slotWriter.groups, n2) ? 1 : SlotTableKt.access$nodeCount(this.groups, n2);
    }

    public final boolean removeGroup() {
        Anchor anchor;
        if (!(this.insertCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot remove group while inserting");
        }
        SlotWriter slotWriter = this;
        int n = slotWriter.currentGroup;
        int n2 = slotWriter.currentSlot;
        int[] nArray = slotWriter.groups;
        int n3 = slotWriter.dataIndex(nArray, slotWriter.groupIndexToAddress(n));
        int n4 = slotWriter.skipGroup();
        Object object = slotWriter.sourceInformationOf(slotWriter.parent);
        if (object != null && (anchor = this.tryAnchor$runtime(n)) != null) {
            ((GroupSourceInformation)object).removeAnchor(anchor);
        }
        if ((object = this.pendingRecalculateMarks) != null) {
            while (((PrioritySet)object).isNotEmpty() && ((PrioritySet)object).peek() >= n) {
                ((PrioritySet)object).takeMax();
            }
        }
        boolean bl = this.removeGroups(n, this.currentGroup - n);
        int n5 = this.currentSlot - n3;
        this.removeSlots(n3, n5, n - 1);
        this.currentGroup = n;
        this.currentSlot = n2;
        this.nodeCount -= n4;
        return bl;
    }

    public final void moveGroup(int n) {
        if (!(this.insertCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot move a group while inserting");
        }
        if (!(n >= 0)) {
            ComposerKt.composeImmediateRuntimeError("Parameter offset is out of bounds");
        }
        if (n == 0) {
            return;
        }
        int n2 = this.currentGroup;
        int n3 = this.parent;
        int n4 = this.currentGroupEnd;
        int n5 = n2;
        while (n > 0) {
            if (!((n5 += SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(n5))) <= n4)) {
                ComposerKt.composeImmediateRuntimeError("Parameter offset is out of bounds");
            }
            --n;
        }
        int n6 = n5;
        n = SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(n5));
        n4 = this.groupIndexToAddress(this.currentGroup);
        n4 = this.dataIndex(this.groups, n4);
        n5 = this.groupIndexToAddress(n5);
        n5 = this.dataIndex(this.groups, n5);
        int[] nArray = this.groups;
        int n7 = n6 + n;
        int n8 = this.groupIndexToAddress(n7);
        int n9 = this.dataIndex(nArray, n8);
        n8 = n9 - n5;
        int n10 = Math.max(this.currentGroup - 1, 0);
        this.insertSlots(n8, n10);
        this.insertGroups(n);
        int[] nArray2 = this.groups;
        int n11 = this.groupIndexToAddress(n7) * 5;
        int n12 = this.groupIndexToAddress(n2) * 5;
        int n13 = n11 + n * 5;
        ArraysKt___ArraysJvmKt.copyInto(this.groups, nArray2, n12, n11, n13);
        if (n8 > 0) {
            Object[] objectArray = this.slots;
            int n14 = n9;
            n9 = this.dataIndexToDataAddress(n5 + n8);
            n12 = this.dataIndexToDataAddress(n14 + n8);
            ArraysKt___ArraysJvmKt.copyInto(this.slots, objectArray, n4, n9, n12);
        }
        n4 = (n5 += n8) - n4;
        n9 = this.slotsGapStart;
        n11 = this.slotsGapLen;
        n12 = this.slots.length;
        n13 = this.slotsGapOwner;
        int n15 = n2 + n;
        for (int i = n2; i < n15; ++i) {
            int n16 = this.groupIndexToAddress(i);
            int n17 = this.dataIndex(nArray2, n16) - n4;
            int n18 = n13 < n16 ? 0 : n9;
            n17 = this.dataIndexToDataAnchor(n17, n18, n11, n12);
            this.updateDataIndex(nArray2, n16, n17);
        }
        this.moveAnchors(n7, n2, n);
        if (!(this.removeGroups(n7, n) ^ true)) {
            ComposerKt.composeImmediateRuntimeError("Unexpectedly removed anchors");
        }
        n = this.currentGroupEnd;
        this.fixParentAnchorsFor(n3, n, n2);
        if (n8 > 0) {
            n = n7 - 1;
            this.removeSlots(n5, n8, n);
        }
    }

    public final List moveFrom(SlotTable objectArray, int n, boolean bl) {
        List list;
        Intrinsics.checkNotNullParameter(objectArray, "table");
        ComposerKt.runtimeCheck(((SlotWriter)object).insertCount > 0);
        if (n == 0 && ((SlotWriter)object).currentGroup == 0 && ((SlotWriter)object).table.getGroupsSize() == 0 && SlotTableKt.access$groupSize(objectArray.getGroups(), n) == objectArray.getGroupsSize()) {
            SlotWriter slotWriter = object;
            Object[] objectArray2 = objectArray;
            SlotWriter slotWriter2 = object;
            Object[] objectArray3 = objectArray;
            SlotWriter slotWriter3 = object;
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = objectArray;
            SlotWriter slotWriter4 = object;
            Object object = slotWriter4.groups;
            objectArray = slotWriter4.slots;
            ArrayList arrayList = slotWriter4.anchors;
            HashMap hashMap = slotWriter4.sourceInformationMap;
            MutableIntObjectMap mutableIntObjectMap = slotWriter4.calledByMap;
            int[] nArray = objectArray4.getGroups();
            int n2 = objectArray5.getGroupsSize();
            Object[] objectArray6 = objectArray4.getSlots();
            int n3 = objectArray5.getSlotsSize();
            HashMap hashMap2 = objectArray4.getSourceInformationMap$runtime();
            MutableIntObjectMap mutableIntObjectMap2 = objectArray5.getCalledByMap$runtime();
            slotWriter3.groups = nArray;
            slotWriter3.slots = objectArray6;
            slotWriter2.anchors = objectArray3.getAnchors$runtime();
            slotWriter2.groupGapStart = n2;
            slotWriter2.groupGapLen = nArray.length / 5 - n2;
            slotWriter2.slotsGapStart = n3;
            slotWriter2.slotsGapLen = objectArray6.length - n3;
            slotWriter2.slotsGapOwner = n2;
            slotWriter2.sourceInformationMap = hashMap2;
            slotWriter2.calledByMap = mutableIntObjectMap2;
            objectArray2.setTo$runtime((int[])object, 0, objectArray, 0, arrayList, hashMap, mutableIntObjectMap);
            return slotWriter.anchors;
        }
        objectArray = objectArray.openWriter();
        boolean bl2 = false;
        try {
            list = SlotWriter.Companion.moveGroup((SlotWriter)objectArray, n, (SlotWriter)object, true, true, bl);
            objectArray.close(true);
        }
        catch (Throwable throwable) {
            objectArray.close(bl2);
            throw throwable;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public final List moveIntoGroupFrom(int var1_1, SlotTable var2_2, int var3_4) {
        Intrinsics.checkNotNullParameter(var2_2, "table");
        if (this.insertCount > 0) ** GOTO lbl-1000
        v0 = this;
        if (v0.groupSize(v0.currentGroup + var1_1) == 1) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        ComposerKt.runtimeCheck(v1);
        v2 = this;
        v3 = var1_1;
        v4 = this;
        var1_1 = v4.currentGroup;
        var2_3 = v4.currentSlot;
        var4_5 = v4.currentSlotEnd;
        v2.advanceBy(v3);
        v2.startGroup();
        v2.beginInsert();
        var5_6 = var2_2.openWriter();
        var6_7 = false;
        try {
            v5 = top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotWriter$Companion.moveGroup$default(SlotWriter.Companion, var5_6, var3_4, this, false, true, false, 32, null);
            v6 = this;
            var5_6.close(true);
            v6.endInsert();
            v6.endGroup();
        }
        catch (Throwable v7) {
            var5_6.close(var6_7);
            throw v7;
        }
        this.currentGroup = var1_1;
        this.currentSlot = var2_3;
        this.currentSlotEnd = var4_5;
        return v5;
    }

    public final Anchor anchor(int n) {
        Anchor anchor;
        ArrayList arrayList = this.anchors;
        int n2 = SlotTableKt.access$search(arrayList, n, this.getSize$runtime());
        if (n2 < 0) {
            if (n > this.groupGapStart) {
                n = -(this.getSize$runtime() - n);
            }
            anchor = new Anchor(n);
            arrayList.add(-(n2 + 1), anchor);
        } else {
            Object e = arrayList.get(n2);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    public final void markGroup(int n) {
        SlotWriter slotWriter = this;
        int n2 = slotWriter.groupIndexToAddress(n);
        if (!SlotTableKt.access$hasMark(slotWriter.groups, n2)) {
            SlotWriter slotWriter2 = this;
            SlotTableKt.access$updateMark(slotWriter2.groups, n2, true);
            if (!SlotTableKt.access$containsMark(slotWriter2.groups, n2)) {
                SlotWriter slotWriter3 = this;
                slotWriter3.updateContainsMark(slotWriter3.parent(n));
            }
        }
    }

    public final int anchorIndex(Anchor anchor) {
        Anchor anchor2 = anchor;
        Intrinsics.checkNotNullParameter(anchor2, "anchor");
        int n = anchor2.getLocation$runtime();
        if (n < 0) {
            n = this.getSize$runtime() + n;
        }
        return n;
    }

    public String toString() {
        return "SlotWriter(current = " + this.currentGroup + " end=" + this.currentGroupEnd + " size = " + this.getSize$runtime() + " gap=" + this.groupGapStart + '-' + (this.groupGapStart + this.groupGapLen) + ')';
    }

    public final Anchor tryAnchor$runtime(int n) {
        return n >= 0 && n < this.getSize$runtime() ? SlotTableKt.access$find(this.anchors, n, this.getSize$runtime()) : null;
    }

    public final int getSize$runtime() {
        return this.getCapacity() - this.groupGapLen;
    }

    public static final class Companion {
        public Companion() {
        }

        public static /* synthetic */ List moveGroup$default(Companion companion, SlotWriter slotWriter, int n, SlotWriter slotWriter2, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                bl3 = true;
            }
            return companion.moveGroup(slotWriter, n, slotWriter2, bl, bl2, bl3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final List moveGroup(SlotWriter slotWriter, int n, SlotWriter slotWriter2, boolean bl, boolean bl2, boolean n2) {
            List list;
            int n3 = slotWriter.groupSize(n);
            int n4 = n + n3;
            int n5 = slotWriter.dataIndex(n);
            int n6 = slotWriter.dataIndex(n4);
            int n7 = n6 - n5;
            boolean bl3 = slotWriter.containsAnyGroupMarks(n);
            slotWriter2.insertGroups(n3);
            int n8 = slotWriter2.getCurrentGroup();
            slotWriter2.insertSlots(n7, n8);
            if (slotWriter.groupGapStart < n4) {
                slotWriter.moveGroupGapTo(n4);
            }
            if (slotWriter.slotsGapStart < n6) {
                slotWriter.moveSlotGapTo(n6, n4);
            }
            int[] nArray = slotWriter2.groups;
            int n9 = slotWriter2.getCurrentGroup();
            int n10 = n9 * 5;
            int n11 = n * 5;
            int n12 = n4 * 5;
            ArraysKt___ArraysJvmKt.copyInto(slotWriter.groups, nArray, n10, n11, n12);
            Object[] objectArray = slotWriter2.slots;
            n11 = slotWriter2.currentSlot;
            ArraysKt___ArraysJvmKt.copyInto(slotWriter.slots, objectArray, n11, n5, n6);
            n6 = slotWriter2.getParent();
            SlotTableKt.access$updateParentAnchor(nArray, n9, n6);
            int n13 = n9 - n;
            n12 = n9 + n3;
            int n14 = n11 - slotWriter2.dataIndex(nArray, n9);
            int n15 = slotWriter2.slotsGapOwner;
            int n16 = slotWriter2.slotsGapLen;
            int n17 = objectArray.length;
            for (int i = n9; i < n12; ++i) {
                if (i != n9) {
                    SlotTableKt.access$updateParentAnchor(nArray, i, SlotTableKt.access$parentAnchor(nArray, i) + n13);
                }
                int n18 = slotWriter2.dataIndex(nArray, i) + n14;
                int n19 = n15 < i ? 0 : slotWriter2.slotsGapStart;
                SlotTableKt.access$updateDataAnchor(nArray, i, slotWriter2.dataIndexToDataAnchor(n18, n19, n16, n17));
                if (i != n15) continue;
                ++n15;
            }
            slotWriter2.slotsGapOwner = n15;
            n14 = SlotTableKt.access$locationOf(slotWriter.anchors, n, slotWriter.getSize$runtime());
            n4 = SlotTableKt.access$locationOf(slotWriter.anchors, n4, slotWriter.getSize$runtime());
            if (n14 < n4) {
                ArrayList arrayList;
                ArrayList arrayList2 = slotWriter.anchors;
                list = arrayList;
                arrayList = new ArrayList(n4 - n14);
                for (n17 = n14; n17 < n4; ++n17) {
                    Object e = arrayList2.get(n17);
                    Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                    Anchor anchor = (Anchor)e;
                    anchor.setLocation$runtime(anchor.getLocation$runtime() + n13);
                    ((ArrayList)list).add(anchor);
                }
                slotWriter2.anchors.addAll(SlotTableKt.access$locationOf(slotWriter2.anchors, slotWriter2.getCurrentGroup(), slotWriter2.getSize$runtime()), list);
                arrayList2.subList(n14, n4).clear();
            } else {
                list = CollectionsKt__CollectionsKt.emptyList();
            }
            if (list.isEmpty() ^ true) {
                HashMap hashMap = slotWriter.sourceInformationMap;
                HashMap hashMap2 = slotWriter2.sourceInformationMap;
                if (hashMap != null && hashMap2 != null) {
                    int n20 = list.size();
                    for (n14 = 0; n14 < n20; ++n14) {
                        Anchor anchor = (Anchor)list.get(n14);
                        GroupSourceInformation groupSourceInformation = (GroupSourceInformation)hashMap.get(anchor);
                        if (groupSourceInformation == null) continue;
                        hashMap.remove(anchor);
                        hashMap2.put(anchor, groupSourceInformation);
                    }
                }
            }
            int n21 = slotWriter2.getParent();
            GroupSourceInformation groupSourceInformation = slotWriter2.sourceInformationOf(n6);
            if (groupSourceInformation != null) {
                n14 = -1;
                int n22 = slotWriter2.getCurrentGroup();
                int n23 = ++n21;
                n21 = n14;
                n14 = n23;
                while (n14 < n22) {
                    int n24 = n21 = n14 + SlotTableKt.access$groupSize(slotWriter2.groups, n14);
                    n21 = n14;
                    n14 = n24;
                }
                groupSourceInformation.addGroupAfter(slotWriter2, n21, n22);
            }
            int n25 = n2;
            n2 = slotWriter.parent(n);
            if (n25 == 0) {
                n3 = 0;
            } else if (bl) {
                n3 = n2 >= 0 ? 1 : 0;
                if (n3 != 0) {
                    slotWriter.startGroup();
                    slotWriter.advanceBy(n2 - slotWriter.getCurrentGroup());
                    slotWriter.startGroup();
                }
                int n26 = n3;
                slotWriter.advanceBy(n - slotWriter.getCurrentGroup());
                n3 = slotWriter.removeGroup() ? 1 : 0;
                if (n26 != 0) {
                    slotWriter.skipToGroupEnd();
                    slotWriter.endGroup();
                    slotWriter.skipToGroupEnd();
                    slotWriter.endGroup();
                }
            } else {
                n3 = slotWriter.removeGroups(n, n3) ? 1 : 0;
                slotWriter.removeSlots(n5, n7, --n);
            }
            if ((n3 ^ 1) == 0) {
                ComposerKt.composeImmediateRuntimeError("Unexpectedly removed anchors");
            }
            n3 = slotWriter2.nodeCount;
            int n27 = SlotTableKt.access$isNode(nArray, n9) ? 1 : SlotTableKt.access$nodeCount(nArray, n9);
            slotWriter2.nodeCount = n3 + n27;
            if (bl2) {
                slotWriter2.currentGroup = n12;
                slotWriter2.currentSlot = n11 + n7;
            }
            if (bl3) {
                slotWriter2.updateContainsMark(n6);
            }
            return list;
        }
    }
}

