/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.gal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.gal.NativeLibraryPathGetter;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class NativeLibraryPathGetterImpl
implements NativeLibraryPathGetter {
    public static final NativeLibraryPathGetterImpl INSTANCE = new NativeLibraryPathGetterImpl();
    public static final Logger logger = LoggerFactory.getLogger(NativeLibraryPathGetterImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getNativeLibraryPath(String string, Path path) {
        IOException iOException2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(string, "path");
                try {
                    if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
                        return NativeLibraryPathGetterImpl.class.getClassLoader().getResourceAsStream(string);
                    }
                    if (path == null) break block5;
                    int n = 0;
                    InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(new OpenOption[0], n));
                }
                catch (IOException iOException2) {
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
                if (inputStream != null) return inputStream;
            }
            logger.warn("No debug library for your platform");
            return null;
        }
        logger.warn("Open native library failed", (Throwable)iOException2);
        return null;
    }
}

