/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import top.fifthlight.touchcontroller.relocated.kotlin.Pair;
import top.fifthlight.touchcontroller.relocated.kotlin.TuplesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.IndexingIterable;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.ArrayIteratorKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.IntRange;

public abstract class ArraysKt___ArraysKt
extends ArraysKt___ArraysJvmKt {
    public static boolean contains(Object[] objectArray, Object object) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(objectArray, object) >= 0;
    }

    public static boolean contains(byte[] byArray, byte by) {
        Intrinsics.checkNotNullParameter(byArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(byArray, by) >= 0;
    }

    public static boolean contains(short[] sArray, short s) {
        Intrinsics.checkNotNullParameter(sArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(sArray, s) >= 0;
    }

    public static boolean contains(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(nArray, n) >= 0;
    }

    public static boolean contains(long[] lArray, long l) {
        Intrinsics.checkNotNullParameter(lArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(lArray, l) >= 0;
    }

    public static boolean contains(char[] cArray, char c) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(cArray, c) >= 0;
    }

    public static Object getOrNull(Object[] objectArray, int n) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return n >= 0 && n < objectArray.length ? objectArray[n] : null;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (object == null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(object, objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int indexOf(byte[] byArray, byte by) {
        Intrinsics.checkNotNullParameter(byArray, "<this>");
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (by != byArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(short[] sArray, short s) {
        Intrinsics.checkNotNullParameter(sArray, "<this>");
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            if (s != sArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(long[] lArray, long l) {
        Intrinsics.checkNotNullParameter(lArray, "<this>");
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (l != lArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(char[] cArray, char c) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] objectArray, Object object) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (object == null) {
            int n = objectArray.length + -1;
            if (n >= 0) {
                while (true) {
                    int n2 = n;
                    int n3 = n2 + -1;
                    if (objectArray[n2] == null) {
                        return n;
                    }
                    if (n3 >= 0) {
                        n = n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n = objectArray.length + -1;
            if (n >= 0) {
                while (true) {
                    int n4 = n;
                    int n5 = n4 + -1;
                    if (Intrinsics.areEqual(object, objectArray[n4])) {
                        return n;
                    }
                    if (n5 < 0) break;
                    n = n5;
                }
            }
        }
        return -1;
    }

    public static char single(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        int n = cArray.length;
        if (n != 0) {
            if (n == 1) {
                return cArray[0];
            }
            throw new IllegalArgumentException("Array has more than one element.");
        }
        throw new NoSuchElementException("Array is empty.");
    }

    public static Object singleOrNull(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return objectArray.length == 1 ? objectArray[0] : null;
    }

    public static float[] sliceArray(float[] fArray, IntRange intRange) {
        IntRange intRange2 = intRange;
        Intrinsics.checkNotNullParameter(fArray, "<this>");
        Intrinsics.checkNotNullParameter(intRange2, "indices");
        if (intRange2.isEmpty()) {
            return new float[0];
        }
        return ArraysKt___ArraysJvmKt.copyOfRange(fArray, (int)intRange.getStart(), intRange.getEndInclusive() + 1);
    }

    public static final int getLastIndex(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return objectArray.length - 1;
    }

    public static int getLastIndex(int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        return nArray.length - 1;
    }

    public static int getLastIndex(long[] lArray) {
        Intrinsics.checkNotNullParameter(lArray, "<this>");
        return lArray.length - 1;
    }

    public static final Collection toCollection(Object[] objectArray, Collection collection) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            collection.add(objectArray[i]);
        }
        return collection;
    }

    public static List toList(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        int n = objectArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(objectArray) : CollectionsKt__CollectionsJVMKt.listOf(objectArray[0])) : CollectionsKt__CollectionsKt.emptyList();
    }

    public static List toMutableList(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return new ArrayList(CollectionsKt__CollectionsKt.asCollection(objectArray));
    }

    public static final Set toSet(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        int n = objectArray.length;
        return n != 0 ? (n != 1 ? (Set)ArraysKt___ArraysKt.toCollection(objectArray, new LinkedHashSet(MapsKt__MapsJVMKt.mapCapacity(objectArray.length))) : SetsKt__SetsJVMKt.setOf(objectArray[0])) : SetsKt__SetsKt.emptySet();
    }

    public static Iterable withIndex(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return new IndexingIterable(() -> ArraysKt___ArraysKt.withIndex$lambda$108$ArraysKt___ArraysKt(objectArray));
    }

    public static List zip(Object[] objectArray, Object[] objectArray2) {
        ArrayList<Pair> arrayList;
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(objectArray2, "other");
        int n = Math.min(objectArray.length, objectArray2.length);
        ArrayList<Pair> arrayList2 = arrayList;
        arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(TuplesKt.to(objectArray[i], objectArray2[i]));
        }
        return arrayList2;
    }

    public static final Iterator withIndex$lambda$108$ArraysKt___ArraysKt(Object[] objectArray) {
        return ArrayIteratorKt.iterator(objectArray);
    }
}

