/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal;

import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.reflect.KClass;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.KSerializer;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.PolymorphicKind;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.PrimitiveKind;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialKind;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.StructureKind;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.ClassDiscriminatorMode;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.JsonConfiguration;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.modules.SerializersModuleCollector;

public final class JsonSerializersModuleValidator
implements SerializersModuleCollector {
    public final String discriminator;
    public final boolean useArrayPolymorphism;
    public final boolean isDiscriminatorRequired;

    public JsonSerializersModuleValidator(JsonConfiguration jsonConfiguration) {
        Intrinsics.checkNotNullParameter(jsonConfiguration, "configuration");
        this.discriminator = jsonConfiguration.getClassDiscriminator();
        this.useArrayPolymorphism = jsonConfiguration.getUseArrayPolymorphism();
        boolean bl = jsonConfiguration.getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        this.isDiscriminatorRequired = bl;
    }

    @Override
    public void polymorphic(KClass object, KClass kClass, KSerializer kSerializer) {
        JsonSerializersModuleValidator jsonSerializersModuleValidator = this;
        KSerializer kSerializer2 = kSerializer;
        Intrinsics.checkNotNullParameter(object, "baseClass");
        Intrinsics.checkNotNullParameter(kClass, "actualClass");
        Intrinsics.checkNotNullParameter(kSerializer2, "actualSerializer");
        object = kSerializer2.getDescriptor();
        jsonSerializersModuleValidator.checkKind((SerialDescriptor)object, kClass);
        if (!jsonSerializersModuleValidator.useArrayPolymorphism && this.isDiscriminatorRequired) {
            this.checkDiscriminatorCollisions((SerialDescriptor)object, kClass);
        }
    }

    @Override
    public void polymorphicDefaultSerializer(KClass kClass, Function1 function1) {
        Intrinsics.checkNotNullParameter(kClass, "baseClass");
        Intrinsics.checkNotNullParameter(function1, "defaultSerializerProvider");
    }

    @Override
    public void polymorphicDefaultDeserializer(KClass kClass, Function1 function1) {
        Intrinsics.checkNotNullParameter(kClass, "baseClass");
        Intrinsics.checkNotNullParameter(function1, "defaultDeserializerProvider");
    }

    public final void checkKind(SerialDescriptor object, KClass kClass) {
        if (!((object = object.getKind()) instanceof PolymorphicKind) && !Intrinsics.areEqual(object, SerialKind.CONTEXTUAL.INSTANCE)) {
            if (this.useArrayPolymorphism) {
                return;
            }
            if (!this.isDiscriminatorRequired) {
                return;
            }
            if (!(Intrinsics.areEqual(object, StructureKind.LIST.INSTANCE) || Intrinsics.areEqual(object, StructureKind.MAP.INSTANCE) || object instanceof PrimitiveKind || object instanceof SerialKind.ENUM)) {
                return;
            }
            throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " of kind " + object + " cannot be serialized polymorphically with class discriminator.");
        }
        throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization because its kind " + object + " is not concrete. To work with multiple hierarchies, register it as a base class.");
    }

    public final void checkDiscriminatorCollisions(SerialDescriptor serialDescriptor, KClass kClass) {
        int n = serialDescriptor.getElementsCount();
        for (int i = 0; i < n; ++i) {
            String string = serialDescriptor.getElementName(i);
            if (!Intrinsics.areEqual(string, this.discriminator)) {
                continue;
            }
            throw new IllegalArgumentException("Polymorphic serializer for " + kClass + " has property '" + string + "' that conflicts with JSON class discriminator. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism");
        }
    }
}

