/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal;

import top.fifthlight.touchcontroller.relocated.kotlin.KotlinNothingValueException;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal.AbstractJsonLexer;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal.JsonDecodingException;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal.JsonEncodingException;

public abstract class JsonExceptionsKt {
    public static final JsonDecodingException JsonDecodingException(int n, String string) {
        JsonDecodingException jsonDecodingException;
        Intrinsics.checkNotNullParameter(string, "message");
        if (n >= 0) {
            string = "Unexpected JSON token at offset " + n + ": " + string;
        }
        JsonDecodingException jsonDecodingException2 = jsonDecodingException;
        jsonDecodingException2(string);
        return jsonDecodingException2;
    }

    public static final JsonDecodingException JsonDecodingException(int n, String string, CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(string, "message");
        Intrinsics.checkNotNullParameter(charSequence, "input");
        return JsonExceptionsKt.JsonDecodingException(n, string + "\nJSON input: " + JsonExceptionsKt.minify(charSequence, n));
    }

    public static final JsonEncodingException InvalidFloatingPointEncoded(Number number, String string) {
        Intrinsics.checkNotNullParameter(number, "value");
        Intrinsics.checkNotNullParameter(string, "output");
        return new JsonEncodingException("Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(string, 0, 1, null));
    }

    public static final Void throwInvalidFloatingPointDecoded(AbstractJsonLexer abstractJsonLexer, Number number) {
        Intrinsics.checkNotNullParameter(abstractJsonLexer, "<this>");
        Intrinsics.checkNotNullParameter(number, "result");
        AbstractJsonLexer.fail$default(abstractJsonLexer, "Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    public static final Void invalidTrailingComma(AbstractJsonLexer abstractJsonLexer, String string) {
        Intrinsics.checkNotNullParameter(abstractJsonLexer, "<this>");
        Intrinsics.checkNotNullParameter(string, "entity");
        abstractJsonLexer.fail("Trailing comma before the end of JSON " + string, abstractJsonLexer.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingComma = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    public static final JsonEncodingException InvalidKeyKindException(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "keyDescriptor");
        return new JsonEncodingException("Value of type '" + serialDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + serialDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    public static final JsonDecodingException InvalidFloatingPointDecoded(Number number, String string, String string2) {
        Intrinsics.checkNotNullParameter(number, "value");
        Intrinsics.checkNotNullParameter(string, "key");
        Intrinsics.checkNotNullParameter(string2, "output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(number, string, string2));
    }

    public static final String unexpectedFpErrorMessage(Number number, String string, String string2) {
        return "Unexpected special floating-point value " + number + " with key " + string + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(string2, 0, 1, null);
    }

    public static final CharSequence minify(CharSequence charSequence, int n) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        if (charSequence2.length() < 200) {
            return charSequence;
        }
        if (n == -1) {
            n = charSequence.length() - 60;
            if (n <= 0) {
                return charSequence;
            }
            return "....." + ((Object)charSequence.subSequence(n, charSequence.length())).toString();
        }
        int n2 = n - 30;
        String string = n2 <= 0 ? "" : ".....";
        String string2 = (n += 30) >= charSequence.length() ? "" : ".....";
        int n3 = RangesKt___RangesKt.coerceAtLeast(n2, 0);
        return string + ((Object)charSequence.subSequence(n3, RangesKt___RangesKt.coerceAtMost(n, charSequence.length()))).toString() + string2;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

