/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.proxy.message.input.TextInputState;
import top.fifthlight.touchcontroller.proxy.message.input.TextRange;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;

public final class InputStatusMessage
extends ProxyMessage {
    public final TextInputState status;
    public final int type;

    public InputStatusMessage(TextInputState textInputState) {
        super(null);
        this.status = textInputState;
        this.type = 7;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        InputStatusMessage inputStatusMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        if (inputStatusMessage.status == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.status.getText().length());
            byteBuffer.put(StringsKt__StringsJVMKt.encodeToByteArray(this.status.getText()));
            byteBuffer.putInt(this.status.getComposition().getStart());
            byteBuffer.putInt(this.status.getComposition().getLength());
            byteBuffer.putInt(this.status.getSelection().getStart());
            byteBuffer.putInt(this.status.getSelection().getLength());
            byteBuffer.put((byte)(this.status.getSelectionLeft() ? 1 : 0));
        }
    }

    public String toString() {
        return "InputStatusMessage(status=" + this.status + ')';
    }

    public int hashCode() {
        TextInputState textInputState = ((InputStatusMessage)((Object)textInputState)).status;
        return textInputState == null ? 0 : textInputState.hashCode();
    }

    public boolean equals(Object object) {
        if (inputStatusMessage2 == object) {
            return true;
        }
        if (!(object instanceof InputStatusMessage)) {
            return false;
        }
        InputStatusMessage inputStatusMessage = inputStatusMessage2;
        InputStatusMessage inputStatusMessage2 = (InputStatusMessage)object;
        return Intrinsics.areEqual(inputStatusMessage.status, inputStatusMessage2.status);
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public InputStatusMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 22) {
                if (byteBuffer.get() != 0) {
                    ByteBuffer byteBuffer3 = byteBuffer;
                    int n = byteBuffer3.getInt();
                    int n2 = n + 17;
                    if (byteBuffer3.remaining() >= n2) {
                        TextRange textRange;
                        TextRange textRange2;
                        TextInputState textInputState;
                        ByteBuffer byteBuffer4 = byteBuffer;
                        byte[] byArray = new byte[n];
                        byteBuffer.get(byArray);
                        String string = StringsKt__StringsJVMKt.decodeToString(byArray);
                        int n3 = byteBuffer4.getInt();
                        n2 = byteBuffer4.getInt();
                        int n4 = byteBuffer4.getInt();
                        int n5 = byteBuffer4.getInt();
                        boolean bl = byteBuffer4.get() != 0;
                        TextInputState textInputState2 = textInputState;
                        TextRange textRange3 = textRange2;
                        textRange2 = new TextRange(n3, n2);
                        TextRange textRange4 = textRange;
                        textRange = new TextRange(n4, n5);
                        textInputState = new TextInputState(string, textRange3, textRange4, bl);
                        return new InputStatusMessage(textInputState2);
                    }
                    throw new BadMessageLengthException(n2, byteBuffer.remaining());
                }
                return new InputStatusMessage(null);
            }
            throw new BadMessageLengthException(22, byteBuffer.remaining());
        }
    }
}

