/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message.input;

import top.fifthlight.touchcontroller.proxy.message.input.TextRange;
import top.fifthlight.touchcontroller.proxy.message.input.TextRangeKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class TextInputState {
    public final String text;
    public final TextRange composition;
    public final TextRange selection;
    public final boolean selectionLeft;
    public final String compositionText;
    public final String selectionText;

    public TextInputState(String string, TextRange textRange, TextRange textRange2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "text");
        Intrinsics.checkNotNullParameter(textRange, "composition");
        Intrinsics.checkNotNullParameter(textRange2, "selection");
        this.text = string;
        this.composition = textRange;
        this.selection = textRange2;
        this.selectionLeft = bl;
        if (textRange.getEnd() <= string.length()) {
            if (textRange2.getEnd() <= string.length()) {
                this.compositionText = TextRangeKt.substring(string, textRange);
                this.selectionText = TextRangeKt.substring(string, textRange2);
                return;
            }
            string = "selection region end " + textRange2.getEnd() + " should not exceed text length " + string.length();
            throw new IllegalArgumentException(string.toString());
        }
        string = "composition region end " + textRange.getEnd() + " should not exceed text length " + string.length();
        throw new IllegalArgumentException(string.toString());
    }

    public final String getText() {
        return this.text;
    }

    public final TextRange getComposition() {
        return this.composition;
    }

    public final TextRange getSelection() {
        return this.selection;
    }

    public final boolean getSelectionLeft() {
        return this.selectionLeft;
    }

    public String toString() {
        return "TextInputState(text=" + this.text + ", composition=" + this.composition + ", selection=" + this.selection + ", selectionLeft=" + this.selectionLeft + ')';
    }

    public int hashCode() {
        return ((this.text.hashCode() * 31 + this.composition.hashCode()) * 31 + this.selection.hashCode()) * 31 + Boolean.hashCode(this.selectionLeft);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextInputState)) {
            return false;
        }
        object = (TextInputState)object;
        if (!Intrinsics.areEqual(this.text, ((TextInputState)object).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.composition, ((TextInputState)object).composition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.selection, ((TextInputState)object).selection)) {
            return false;
        }
        return this.selectionLeft == ((TextInputState)object).selectionLeft;
    }
}

