/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class AddPointerMessage
extends ProxyMessage {
    public final int index;
    public final float x;
    public final float y;
    public final int type;

    public AddPointerMessage(int n, float f, float f2) {
        super(null);
        this.index = n;
        this.x = f;
        this.y = f2;
        this.type = 1;
    }

    public final int getIndex() {
        return this.index;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        AddPointerMessage addPointerMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        byteBuffer.putInt(addPointerMessage.index);
        byteBuffer.putFloat(this.x);
        byteBuffer.putFloat(this.y);
    }

    public String toString() {
        return "AddPointerMessage(index=" + this.index + ", x=" + this.x + ", y=" + this.y + ')';
    }

    public int hashCode() {
        return (Integer.hashCode(this.index) * 31 + Float.hashCode(this.x)) * 31 + Float.hashCode(this.y);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AddPointerMessage)) {
            return false;
        }
        object = (AddPointerMessage)object;
        if (this.index != ((AddPointerMessage)object).index) {
            return false;
        }
        if (Float.compare(this.x, ((AddPointerMessage)object).x) != 0) {
            return false;
        }
        return Float.compare(this.y, ((AddPointerMessage)object).y) == 0;
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public AddPointerMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() == 12) {
                ByteBuffer byteBuffer3 = byteBuffer;
                int n = byteBuffer3.getInt();
                float f = byteBuffer3.getFloat();
                float f2 = byteBuffer3.getFloat();
                return new AddPointerMessage(n, f, f2);
            }
            throw new BadMessageLengthException(12, byteBuffer.remaining());
        }
    }
}

