/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.text;

import top.fifthlight.touchcontroller.relocated.kotlin.KotlinNothingValueException;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractList;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.CharsKt__CharKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.HexFormat;

public abstract class HexExtensionsKt {
    public static final int[] BYTE_TO_LOWER_CASE_HEX_DIGITS;
    public static final int[] BYTE_TO_UPPER_CASE_HEX_DIGITS;
    public static final int[] HEX_DIGITS_TO_DECIMAL;
    public static final long[] HEX_DIGITS_TO_LONG_DECIMAL;

    public static final int[] getBYTE_TO_LOWER_CASE_HEX_DIGITS() {
        return BYTE_TO_LOWER_CASE_HEX_DIGITS;
    }

    public static final long hexToLong(String string, int n, int n2, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(hexFormat, "format");
        return HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, 16);
    }

    public static /* synthetic */ long hexToLong$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, n, n2, hexFormat);
    }

    public static final long hexToLongImpl(String string, int n, int n2, HexFormat object, int n3) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n, n2, string.length());
        object = ((HexFormat)object).getNumber();
        if (((HexFormat.NumberHexFormat)object).isDigitsOnly$kotlin_stdlib()) {
            HexExtensionsKt.checkNumberOfDigits(string, n, n2, n3);
            return HexExtensionsKt.parseLong(string, n, n2);
        }
        String string2 = string;
        String string3 = string;
        Object object2 = object;
        string = ((HexFormat.NumberHexFormat)object2).getPrefix();
        String string4 = ((HexFormat.NumberHexFormat)object2).getSuffix();
        boolean bl = ((HexFormat.NumberHexFormat)object2).getIgnoreCase$kotlin_stdlib();
        HexExtensionsKt.checkPrefixSuffixNumberOfDigits(string3, n, n2, string, string4, bl, n3);
        int n4 = n + string.length();
        return HexExtensionsKt.parseLong(string2, n4, n2 - string4.length());
    }

    public static final void checkPrefixSuffixNumberOfDigits(String string, int n, int n2, String string2, String string3, boolean bl, int n3) {
        int n4;
        int n5;
        if (n2 - n - string2.length() <= string3.length()) {
            HexExtensionsKt.throwInvalidPrefixSuffix(string, n, n2, string2, string3);
        }
        String string4 = "prefix";
        if (string2.length() != 0) {
            n5 = string2.length();
            for (n4 = 0; n4 < n5; ++n4) {
                if (CharsKt__CharKt.equals(string2.charAt(n4), string.charAt(n + n4), bl)) continue;
                HexExtensionsKt.throwNotContainedAt(string, n, n2, string2, string4);
            }
            n += string2.length();
        }
        int n6 = n2 - string3.length();
        string4 = "suffix";
        if (string3.length() != 0) {
            n5 = string3.length();
            for (n4 = 0; n4 < n5; ++n4) {
                if (CharsKt__CharKt.equals(string3.charAt(n4), string.charAt(n6 + n4), bl)) continue;
                HexExtensionsKt.throwNotContainedAt(string, n6, n2, string3, string4);
            }
        }
        HexExtensionsKt.checkNumberOfDigits(string, n, n6, n3);
    }

    public static final void checkNumberOfDigits(String string, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 < 1) {
            HexExtensionsKt.throwInvalidNumberOfDigits(string, n, n2, "at least", 1);
        } else if (n4 > n3) {
            int n5 = n;
            HexExtensionsKt.checkZeroDigits(string, n5, n5 + n4 - n3);
        }
    }

    public static final void checkZeroDigits(String string, int n, int n2) {
        while (n < n2) {
            if (string.charAt(n) == '0') {
                ++n;
                continue;
            }
            throw new NumberFormatException("Expected the hexadecimal digit '0' at index " + n + ", but was '" + string.charAt(n) + "'.\nThe result won't fit the type being parsed.");
        }
    }

    public static final long parseLong(String string, int n, int n2) {
        long l = 0L;
        while (n < n2) {
            long l2;
            l <<= 4;
            char c = string.charAt(n);
            if (c >>> 8 == 0 && (l2 = HEX_DIGITS_TO_LONG_DECIMAL[c]) >= 0L) {
                l |= l2;
                ++n;
                continue;
            }
            HexExtensionsKt.throwInvalidDigitAt(string, n);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public static final void throwInvalidNumberOfDigits(String string, int n, int n2, String string2, int n3) {
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        string = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        throw new NumberFormatException("Expected " + string2 + ' ' + n3 + " hexadecimal digits at index " + n + ", but was \"" + string + "\" of length " + (n2 - n));
    }

    public static final void throwNotContainedAt(String string, int n, int n2, String string2, String string3) {
        int n3 = RangesKt___RangesKt.coerceAtMost(n + string2.length(), n2);
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string4 = string.substring(n, n3);
        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        throw new NumberFormatException("Expected " + string3 + " \"" + string2 + "\" at index " + n + ", but was " + string4);
    }

    public static final void throwInvalidPrefixSuffix(String string, int n, int n2, String string2, String string3) {
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        string = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        throw new NumberFormatException("Expected a hexadecimal number with prefix \"" + string2 + "\" and suffix \"" + string3 + "\", but was " + string);
    }

    public static final Void throwInvalidDigitAt(String string, int n) {
        throw new NumberFormatException("Expected a hexadecimal digit at index " + n + ", but was " + string.charAt(n));
    }

    static {
        int n;
        char c;
        int n2;
        int n3;
        Object[] objectArray = new int[256];
        for (n3 = 0; n3 < 256; ++n3) {
            int n4 = n3;
            objectArray[n4] = "0123456789abcdef".charAt(n4 >> 4) << 8 | "0123456789abcdef".charAt(n3 & 0xF);
        }
        BYTE_TO_LOWER_CASE_HEX_DIGITS = objectArray;
        objectArray = new int[256];
        for (n3 = 0; n3 < 256; ++n3) {
            int n5 = n3;
            objectArray[n5] = "0123456789ABCDEF".charAt(n5 >> 4) << 8 | "0123456789ABCDEF".charAt(n3 & 0xF);
        }
        BYTE_TO_UPPER_CASE_HEX_DIGITS = objectArray;
        objectArray = new int[256];
        for (n3 = 0; n3 < 256; ++n3) {
            objectArray[n3] = -1;
        }
        String string = "0123456789abcdef";
        int n6 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            c = string.charAt(n2);
            n = n6 + 1;
            objectArray[c] = n6;
            n6 = n;
        }
        string = "0123456789ABCDEF";
        n6 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            c = string.charAt(n2);
            n = n6 + 1;
            objectArray[c] = n6;
            n6 = n;
        }
        HEX_DIGITS_TO_DECIMAL = objectArray;
        objectArray = new long[256];
        for (int i = 0; i < 256; ++i) {
            objectArray[i] = (int)-1L;
        }
        String string2 = "0123456789abcdef";
        n6 = 0;
        for (n2 = 0; n2 < string2.length(); ++n2) {
            c = string2.charAt(n2);
            long l = n6++;
            objectArray[c] = (int)l;
        }
        string2 = "0123456789ABCDEF";
        n6 = 0;
        for (n2 = 0; n2 < string2.length(); ++n2) {
            c = string2.charAt(n2);
            long l = n6++;
            objectArray[c] = (int)l;
        }
        HEX_DIGITS_TO_LONG_DECIMAL = objectArray;
    }
}

