/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.AddPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.BadMessageTypeException;
import top.fifthlight.touchcontroller.proxy.message.CapabilityMessage;
import top.fifthlight.touchcontroller.proxy.message.ClearPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.InitializeMessage;
import top.fifthlight.touchcontroller.proxy.message.InputAreaMessage;
import top.fifthlight.touchcontroller.proxy.message.InputCursorMessage;
import top.fifthlight.touchcontroller.proxy.message.InputStatusMessage;
import top.fifthlight.touchcontroller.proxy.message.KeyboardShowMessage;
import top.fifthlight.touchcontroller.proxy.message.LargeMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.proxy.message.RemovePointerMessage;
import top.fifthlight.touchcontroller.proxy.message.VibrateMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public abstract class ProxyMessage {
    public static final Companion Companion = new Companion(null);

    public ProxyMessage() {
    }

    public /* synthetic */ ProxyMessage(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public abstract int getType();

    public boolean getWrapInLargeMessage() {
        return false;
    }

    public void encode(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter(byteBuffer, "buffer");
        byteBuffer.putInt(this.getType());
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final ProxyMessage decode(int n, ByteBuffer byteBuffer) {
            ProxyMessageDecoder proxyMessageDecoder;
            Intrinsics.checkNotNullParameter(byteBuffer, "payload");
            switch (n) {
                default: {
                    throw new BadMessageTypeException(n);
                }
                case 11: {
                    proxyMessageDecoder = InputAreaMessage.Decoder.INSTANCE;
                    break;
                }
                case 10: {
                    proxyMessageDecoder = InitializeMessage.Decoder.INSTANCE;
                    break;
                }
                case 9: {
                    proxyMessageDecoder = InputCursorMessage.Decoder.INSTANCE;
                    break;
                }
                case 8: {
                    proxyMessageDecoder = KeyboardShowMessage.Decoder.INSTANCE;
                    break;
                }
                case 7: {
                    proxyMessageDecoder = InputStatusMessage.Decoder.INSTANCE;
                    break;
                }
                case 6: {
                    proxyMessageDecoder = LargeMessage.Decoder.INSTANCE;
                    break;
                }
                case 5: {
                    proxyMessageDecoder = CapabilityMessage.Decoder.INSTANCE;
                    break;
                }
                case 4: {
                    proxyMessageDecoder = VibrateMessage.Decoder.INSTANCE;
                    break;
                }
                case 3: {
                    proxyMessageDecoder = ClearPointerMessage.Decoder.INSTANCE;
                    break;
                }
                case 2: {
                    proxyMessageDecoder = RemovePointerMessage.Decoder.INSTANCE;
                    break;
                }
                case 1: {
                    proxyMessageDecoder = AddPointerMessage.Decoder.INSTANCE;
                }
            }
            return proxyMessageDecoder.decode(byteBuffer);
        }
    }
}

