/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class InputCursorMessage
extends ProxyMessage {
    public final CursorRect cursorRect;
    public final int type;

    public InputCursorMessage(CursorRect cursorRect) {
        super(null);
        this.cursorRect = cursorRect;
        this.type = 9;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        InputCursorMessage inputCursorMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        if (inputCursorMessage.cursorRect != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putFloat(this.cursorRect.getLeft());
            byteBuffer.putFloat(this.cursorRect.getTop());
            byteBuffer.putFloat(this.cursorRect.getWidth());
            byteBuffer.putFloat(this.cursorRect.getHeight());
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String toString() {
        return "InputCursorMessage(cursorRect=" + this.cursorRect + ')';
    }

    public int hashCode() {
        CursorRect cursorRect = ((InputCursorMessage)((Object)cursorRect)).cursorRect;
        return cursorRect == null ? 0 : cursorRect.hashCode();
    }

    public boolean equals(Object object) {
        if (inputCursorMessage2 == object) {
            return true;
        }
        if (!(object instanceof InputCursorMessage)) {
            return false;
        }
        InputCursorMessage inputCursorMessage = inputCursorMessage2;
        InputCursorMessage inputCursorMessage2 = (InputCursorMessage)object;
        return Intrinsics.areEqual(inputCursorMessage.cursorRect, inputCursorMessage2.cursorRect);
    }

    public static final class CursorRect {
        public final float left;
        public final float top;
        public final float width;
        public final float height;

        public CursorRect(float f, float f2, float f3, float f4) {
            this.left = f;
            this.top = f2;
            this.width = f3;
            this.height = f4;
        }

        public final float getLeft() {
            return this.left;
        }

        public final float getTop() {
            return this.top;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getHeight() {
            return this.height;
        }

        public String toString() {
            return "CursorRect(left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            return ((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.width)) * 31 + Float.hashCode(this.height);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CursorRect)) {
                return false;
            }
            object = (CursorRect)object;
            if (Float.compare(this.left, ((CursorRect)object).left) != 0) {
                return false;
            }
            if (Float.compare(this.top, ((CursorRect)object).top) != 0) {
                return false;
            }
            if (Float.compare(this.width, ((CursorRect)object).width) != 0) {
                return false;
            }
            return Float.compare(this.height, ((CursorRect)object).height) == 0;
        }
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public InputCursorMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 1) {
                if (byteBuffer.get() != 0) {
                    if (byteBuffer.remaining() == 16) {
                        CursorRect cursorRect;
                        CursorRect cursorRect2 = cursorRect;
                        ByteBuffer byteBuffer3 = byteBuffer;
                        float f = byteBuffer3.getFloat();
                        float f2 = byteBuffer3.getFloat();
                        float f3 = byteBuffer3.getFloat();
                        float f4 = byteBuffer3.getFloat();
                        cursorRect = new CursorRect(f, f2, f3, f4);
                        return new InputCursorMessage(cursorRect2);
                    }
                    throw new BadMessageLengthException(16, byteBuffer.remaining());
                }
                return new InputCursorMessage(null);
            }
            throw new BadMessageLengthException(1, byteBuffer.remaining());
        }
    }
}

