/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveArrayBuilder;

public final class CharArrayBuilder
extends PrimitiveArrayBuilder {
    public char[] buffer;
    public int position;

    public CharArrayBuilder(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "bufferWithData");
        this.buffer = cArray;
        this.position = cArray.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int n) {
        char[] cArray = this.buffer;
        if (this.buffer.length < n) {
            char[] cArray2 = Arrays.copyOf(cArray, RangesKt___RangesKt.coerceAtLeast(n, cArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(cArray2, "copyOf(...)");
            this.buffer = cArray2;
        }
    }

    public final void append$kotlinx_serialization_core(char c) {
        CharArrayBuilder charArrayBuilder = this;
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(charArrayBuilder, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        charArrayBuilder.buffer[n] = c;
    }

    public char[] build$kotlinx_serialization_core() {
        char[] cArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(...)");
        return cArray;
    }
}

