/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.ui.state;

import java.util.List;
import top.fifthlight.touchcontroller.common.config.LayoutLayer;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetsContainer;
import top.fifthlight.touchcontroller.common.control.ControllerWidget;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.Uuid;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.ExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentList;

public abstract class CustomControlLayoutTabState {
    public CustomControlLayoutTabState() {
    }

    public /* synthetic */ CustomControlLayoutTabState(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public static final class Disabled
    extends CustomControlLayoutTabState {
        public static final Disabled INSTANCE = new Disabled();

        public Disabled() {
            super(null);
        }

        public String toString() {
            return "Disabled";
        }

        public int hashCode() {
            return -1055199659;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof Disabled;
        }
    }

    public static final class Enabled
    extends CustomControlLayoutTabState {
        public final PresetsContainer allPresets;
        public final Uuid selectedPresetUuid;
        public final LayoutPreset selectedPreset;
        public final LayoutLayer selectedLayer;
        public final ControllerWidget selectedWidget;
        public final PageState pageState;

        public Enabled(PresetsContainer presetsContainer, Uuid uuid, LayoutPreset layoutPreset, LayoutLayer layoutLayer, ControllerWidget controllerWidget, PageState pageState) {
            Intrinsics.checkNotNullParameter(presetsContainer, "allPresets");
            Intrinsics.checkNotNullParameter(pageState, "pageState");
            super(null);
            this.allPresets = presetsContainer;
            this.selectedPresetUuid = uuid;
            this.selectedPreset = layoutPreset;
            this.selectedLayer = layoutLayer;
            this.selectedWidget = controllerWidget;
            this.pageState = pageState;
        }

        public final PresetsContainer getAllPresets() {
            return this.allPresets;
        }

        public final Uuid getSelectedPresetUuid() {
            return this.selectedPresetUuid;
        }

        public final LayoutPreset getSelectedPreset() {
            return this.selectedPreset;
        }

        public final LayoutLayer getSelectedLayer() {
            return this.selectedLayer;
        }

        public final ControllerWidget getSelectedWidget() {
            return this.selectedWidget;
        }

        public final PageState getPageState() {
            return this.pageState;
        }

        public String toString() {
            return "Enabled(allPresets=" + this.allPresets + ", selectedPresetUuid=" + this.selectedPresetUuid + ", selectedPreset=" + this.selectedPreset + ", selectedLayer=" + this.selectedLayer + ", selectedWidget=" + this.selectedWidget + ", pageState=" + this.pageState + ')';
        }

        public int hashCode() {
            Enabled enabled = this;
            int n = enabled.allPresets.hashCode() * 31;
            Uuid uuid = enabled.selectedPresetUuid;
            int n2 = uuid == null ? 0 : uuid.hashCode();
            n = (n + n2) * 31;
            LayoutPreset layoutPreset = this.selectedPreset;
            int n3 = layoutPreset == null ? 0 : layoutPreset.hashCode();
            n = (n + n3) * 31;
            LayoutLayer layoutLayer = this.selectedLayer;
            int n4 = layoutLayer == null ? 0 : layoutLayer.hashCode();
            n = (n + n4) * 31;
            ControllerWidget controllerWidget = this.selectedWidget;
            int n5 = controllerWidget == null ? 0 : controllerWidget.hashCode();
            return (n + n5) * 31 + this.pageState.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Enabled)) {
                return false;
            }
            object = (Enabled)object;
            if (!Intrinsics.areEqual(this.allPresets, ((Enabled)object).allPresets)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.selectedPresetUuid, ((Enabled)object).selectedPresetUuid)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.selectedPreset, ((Enabled)object).selectedPreset)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.selectedLayer, ((Enabled)object).selectedLayer)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.selectedWidget, ((Enabled)object).selectedWidget)) {
                return false;
            }
            return Intrinsics.areEqual(this.pageState, ((Enabled)object).pageState);
        }

        public static final class EditState {
            public final Uuid presetUuid;
            public final UndoStack undoStack;

            public EditState(Uuid uuid, UndoStack undoStack) {
                Intrinsics.checkNotNullParameter(uuid, "presetUuid");
                Intrinsics.checkNotNullParameter(undoStack, "undoStack");
                this.presetUuid = uuid;
                this.undoStack = undoStack;
            }

            public static /* synthetic */ EditState copy$default(EditState editState, Uuid uuid, UndoStack undoStack, int n, Object object) {
                if ((n & 1) != 0) {
                    uuid = editState.presetUuid;
                }
                if ((n & 2) != 0) {
                    undoStack = editState.undoStack;
                }
                return editState.copy(uuid, undoStack);
            }

            public final Uuid getPresetUuid() {
                return this.presetUuid;
            }

            public final UndoStack getUndoStack() {
                return this.undoStack;
            }

            public final EditState copy(Uuid uuid, UndoStack undoStack) {
                Intrinsics.checkNotNullParameter(uuid, "presetUuid");
                Intrinsics.checkNotNullParameter(undoStack, "undoStack");
                return new EditState(uuid, undoStack);
            }

            public String toString() {
                return "EditState(presetUuid=" + this.presetUuid + ", undoStack=" + this.undoStack + ')';
            }

            public int hashCode() {
                return this.presetUuid.hashCode() * 31 + this.undoStack.hashCode();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof EditState)) {
                    return false;
                }
                object = (EditState)object;
                if (!Intrinsics.areEqual(this.presetUuid, ((EditState)object).presetUuid)) {
                    return false;
                }
                return Intrinsics.areEqual(this.undoStack, ((EditState)object).undoStack);
            }
        }

        public static final class PageState {
            public final int selectedLayerIndex;
            public final int selectedWidgetIndex;
            public final boolean moveLocked;
            public final boolean highlight;
            public final boolean showSideBar;
            public final ControllerWidget copiedWidget;
            public final EditState editState;

            public PageState(int n, int n2, boolean bl, boolean bl2, boolean bl3, ControllerWidget controllerWidget, EditState editState) {
                this.selectedLayerIndex = n;
                this.selectedWidgetIndex = n2;
                this.moveLocked = bl;
                this.highlight = bl2;
                this.showSideBar = bl3;
                this.copiedWidget = controllerWidget;
                this.editState = editState;
            }

            public /* synthetic */ PageState(int n, int n2, boolean bl, boolean bl2, boolean bl3, ControllerWidget controllerWidget, EditState editState, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = 0;
                }
                if ((n3 & 2) != 0) {
                    n2 = -1;
                }
                if ((n3 & 4) != 0) {
                    bl = false;
                }
                if ((n3 & 8) != 0) {
                    bl2 = false;
                }
                if ((n3 & 0x10) != 0) {
                    bl3 = false;
                }
                if ((n3 & 0x20) != 0) {
                    controllerWidget = null;
                }
                if ((n3 & 0x40) != 0) {
                    editState = null;
                }
                this(n, n2, bl, bl2, bl3, controllerWidget, editState);
            }

            public static /* synthetic */ PageState copy$default(PageState pageState, int n, int n2, boolean bl, boolean bl2, boolean bl3, ControllerWidget controllerWidget, EditState editState, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = pageState.selectedLayerIndex;
                }
                if ((n3 & 2) != 0) {
                    n2 = pageState.selectedWidgetIndex;
                }
                if ((n3 & 4) != 0) {
                    bl = pageState.moveLocked;
                }
                if ((n3 & 8) != 0) {
                    bl2 = pageState.highlight;
                }
                if ((n3 & 0x10) != 0) {
                    bl3 = pageState.showSideBar;
                }
                if ((n3 & 0x20) != 0) {
                    controllerWidget = pageState.copiedWidget;
                }
                if ((n3 & 0x40) != 0) {
                    editState = pageState.editState;
                }
                return pageState.copy(n, n2, bl, bl2, bl3, controllerWidget, editState);
            }

            public final int getSelectedLayerIndex() {
                return this.selectedLayerIndex;
            }

            public final int getSelectedWidgetIndex() {
                return this.selectedWidgetIndex;
            }

            public final boolean getMoveLocked() {
                return this.moveLocked;
            }

            public final boolean getHighlight() {
                return this.highlight;
            }

            public final boolean getShowSideBar() {
                return this.showSideBar;
            }

            public final ControllerWidget getCopiedWidget() {
                return this.copiedWidget;
            }

            public final EditState getEditState() {
                return this.editState;
            }

            public final PageState copy(int n, int n2, boolean bl, boolean bl2, boolean bl3, ControllerWidget controllerWidget, EditState editState) {
                return new PageState(n, n2, bl, bl2, bl3, controllerWidget, editState);
            }

            public String toString() {
                return "PageState(selectedLayerIndex=" + this.selectedLayerIndex + ", selectedWidgetIndex=" + this.selectedWidgetIndex + ", moveLocked=" + this.moveLocked + ", highlight=" + this.highlight + ", showSideBar=" + this.showSideBar + ", copiedWidget=" + this.copiedWidget + ", editState=" + this.editState + ')';
            }

            public int hashCode() {
                PageState pageState = this;
                int n = ((((Integer.hashCode(pageState.selectedLayerIndex) * 31 + Integer.hashCode(this.selectedWidgetIndex)) * 31 + Boolean.hashCode(this.moveLocked)) * 31 + Boolean.hashCode(this.highlight)) * 31 + Boolean.hashCode(this.showSideBar)) * 31;
                ControllerWidget controllerWidget = pageState.copiedWidget;
                int n2 = controllerWidget == null ? 0 : controllerWidget.hashCode();
                int n3 = (n + n2) * 31;
                EditState editState = this.editState;
                int n4 = editState == null ? 0 : editState.hashCode();
                return n3 + n4;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof PageState)) {
                    return false;
                }
                object = (PageState)object;
                if (this.selectedLayerIndex != ((PageState)object).selectedLayerIndex) {
                    return false;
                }
                if (this.selectedWidgetIndex != ((PageState)object).selectedWidgetIndex) {
                    return false;
                }
                if (this.moveLocked != ((PageState)object).moveLocked) {
                    return false;
                }
                if (this.highlight != ((PageState)object).highlight) {
                    return false;
                }
                if (this.showSideBar != ((PageState)object).showSideBar) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.copiedWidget, ((PageState)object).copiedWidget)) {
                    return false;
                }
                return Intrinsics.areEqual(this.editState, ((PageState)object).editState);
            }
        }

        public static final class UndoStack {
            public static final Companion Companion = new Companion(null);
            public final PersistentList undoStack;
            public final int undoStackIndex;

            public UndoStack(PersistentList object, int n) {
                Intrinsics.checkNotNullParameter(object, "undoStack");
                this.undoStack = object;
                this.undoStackIndex = n;
                if (object.isEmpty() ^ true) {
                    int n2 = object.size();
                    if (n >= 0 && n < n2) {
                        return;
                    }
                    object = "Undo stack index " + n + " not in stack size: [0, " + object.size() + ')';
                    throw new IllegalArgumentException(object.toString());
                }
                throw new IllegalArgumentException("Undo stack is empty".toString());
            }

            public UndoStack(LayoutPreset layoutPreset) {
                Intrinsics.checkNotNullParameter(layoutPreset, "preset");
                this(ExtensionsKt.persistentListOf(layoutPreset), 0);
            }

            public static /* synthetic */ UndoStack copy$default(UndoStack undoStack, PersistentList persistentList, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    persistentList = undoStack.undoStack;
                }
                if ((n2 & 2) != 0) {
                    n = undoStack.undoStackIndex;
                }
                return undoStack.copy(persistentList, n);
            }

            public final LayoutPreset getCurrentItem() {
                return (LayoutPreset)this.undoStack.get(this.undoStackIndex);
            }

            public final boolean getHaveUndoItem() {
                return this.undoStackIndex > 0;
            }

            public final boolean getHaveRedoItem() {
                return this.undoStackIndex < this.undoStack.size() - 1;
            }

            public final UndoStack plus(LayoutPreset layoutPreset) {
                Intrinsics.checkNotNullParameter(layoutPreset, "preset");
                if (Intrinsics.areEqual(layoutPreset, ((UndoStack)object2).getCurrentItem())) {
                    return object2;
                }
                if ((object2 = ExtensionsKt.toPersistentList(((UndoStack)object2).getHaveRedoItem() ? ((UndoStack)object2).undoStack.subList(0, ((UndoStack)object2).undoStackIndex + 1) : ((UndoStack)object2).undoStack).add(layoutPreset)).size() > 64) {
                    Object object = object2;
                    int n = object.size() - 64;
                    Object object2 = ExtensionsKt.toPersistentList(object.subList(n, object.size()));
                }
                return new UndoStack((PersistentList)object2, CollectionsKt__CollectionsKt.getLastIndex((List)object2));
            }

            public final UndoStack undo() {
                if (this.getHaveUndoItem()) {
                    UndoStack undoStack = this;
                    return UndoStack.copy$default(undoStack, null, undoStack.undoStackIndex - 1, 1, null);
                }
                throw new IllegalArgumentException("No undo item available".toString());
            }

            public final UndoStack redo() {
                if (this.getHaveRedoItem()) {
                    UndoStack undoStack = this;
                    return UndoStack.copy$default(undoStack, null, undoStack.undoStackIndex + 1, 1, null);
                }
                throw new IllegalArgumentException("No redo item available".toString());
            }

            public final UndoStack copy(PersistentList persistentList, int n) {
                Intrinsics.checkNotNullParameter(persistentList, "undoStack");
                return new UndoStack(persistentList, n);
            }

            public String toString() {
                return "UndoStack(undoStack=" + this.undoStack + ", undoStackIndex=" + this.undoStackIndex + ')';
            }

            public int hashCode() {
                return this.undoStack.hashCode() * 31 + Integer.hashCode(this.undoStackIndex);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof UndoStack)) {
                    return false;
                }
                object = (UndoStack)object;
                if (!Intrinsics.areEqual(this.undoStack, ((UndoStack)object).undoStack)) {
                    return false;
                }
                return this.undoStackIndex == ((UndoStack)object).undoStackIndex;
            }

            public static final class Companion {
                public Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                    this();
                }
            }
        }
    }
}

