/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.fifthlight.touchcontroller.common.event.RenderEvents;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.relocated.org.koin.java.KoinJavaComponent;

@Mixin(value={Gui.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE;
    @Shadow
    @Final
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
    @Shadow
    @Final
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"renderItemHotbar"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", ordinal=0)})
    private void renderHotbar(GuiGraphics guiGraphics, DeltaTracker inventorySlotStatusArray, CallbackInfo callbackInfo) {
        InGameHudMixin inGameHudMixin = inGameHudMixin.minecraft.f_91074_;
        if (inGameHudMixin != null) {
            GuiGraphics guiGraphics2 = guiGraphics;
            inventorySlotStatusArray = ((ControllerHudModel)KoinJavaComponent.get(ControllerHudModel.class)).getResult().getInventory().getSlots();
            int n = (guiGraphics2.m_280182_() - 182) / 2 + 1;
            int n2 = guiGraphics2.m_280206_();
            for (int i = 0; i < 9; ++i) {
                if (inGameHudMixin.m_150109_().m_8020_(i).m_41619_()) continue;
                int n3 = (int)(inventorySlotStatusArray[i].getProgress() * 16.0f);
                int n4 = n + i * 20;
                int n5 = n4 + 2;
                int n6 = n2 - 3;
                guiGraphics.m_280509_(n5, n6 - n3, n4 + 18, n6, -16729344);
            }
        }
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0)}, cancellable=true)
    public void renderCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo callbackInfo) {
        if (!RenderEvents.INSTANCE.shouldRenderCrosshair()) {
            if (this.minecraft.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR) {
                InGameHudMixin inGameHudMixin = this;
                float f = inGameHudMixin.minecraft.f_91074_.m_36403_(0.0f);
                int n = 0;
                if (inGameHudMixin.minecraft.f_91076_ != null && this.minecraft.f_91076_ instanceof LivingEntity && f >= 1.0f) {
                    int n2;
                    int n3;
                    n = this.minecraft.f_91074_.m_36333_() > 5.0f && this.minecraft.f_91076_.m_6084_() ? (n3 = 1) : (n2 = 0);
                }
                int n4 = n;
                GuiGraphics guiGraphics2 = guiGraphics;
                int n5 = guiGraphics2.m_280182_() / 2;
                n = guiGraphics2.m_280206_() / 2;
                if (n4 != 0) {
                    ResourceLocation resourceLocation = CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE;
                    int n6 = n5 - 8;
                    int n7 = n - 8;
                    guiGraphics.m_292816_(resourceLocation, n6, n7, 16, 16);
                } else if (f < 1.0f) {
                    GuiGraphics guiGraphics3 = guiGraphics;
                    int n8 = n5;
                    n5 = (int)(f * 17.0f);
                    guiGraphics = CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
                    int n9 = n8 - 8;
                    guiGraphics3.m_292816_((ResourceLocation)guiGraphics, n9, n -= 2, 16, 4);
                    guiGraphics3.m_294122_(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, n9, n, n5, 4);
                }
            }
            callbackInfo.cancel();
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }
}

